/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.enums;

import kd.sit.sitbp.common.cal.api.CalOperator;
import kd.sit.sitbp.common.cal.api.OperatorName;
import kd.sit.sitbp.common.cal.impl.operator.arith.DivideOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.MultiplyOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.PlusOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.SubtractOperator;
import kd.sit.sitbp.common.cal.model.OpMatcherInfo;

public enum ArithmeticOperatorEnum implements OperatorName
{
    MULTIPLY('*', 4021, MultiplyOperator.getInstance()),
    DIVIDE('/', 4021, DivideOperator.getInstance()),
    PLUS('+', 4011, PlusOperator.getInstance()),
    SUBTRACT('-', 4011, SubtractOperator.getInstance());

    public static final int SINGLE_OP_PRIORITY = 1000;
    private final char code;
    private final int priority;
    private final CalOperator operator;

    private ArithmeticOperatorEnum(char code, int priority, CalOperator operator) {
        this.code = code;
        this.priority = priority;
        this.operator = operator;
    }

    @Override
    public boolean match(OpMatcherInfo opMatcherInfo, char[] chars) {
        int startIndex = opMatcherInfo.getStartIndex();
        if (this.code == chars[startIndex]) {
            opMatcherInfo.setOperatorName(this);
            opMatcherInfo.setStartIndex(startIndex);
            opMatcherInfo.setEndIndex(startIndex + 1);
            return true;
        }
        return false;
    }

    @Override
    public char[] startCode() {
        return new char[]{this.code};
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public CalOperator operator() {
        return this.operator;
    }

    @Override
    public String expression() {
        return this.code + " ";
    }
}

