/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.enums;

import kd.sit.sitbp.common.cal.api.CalOperator;
import kd.sit.sitbp.common.cal.api.CalUnitOpName;
import kd.sit.sitbp.common.cal.factory.CalResolverFactory;
import kd.sit.sitbp.common.cal.impl.operator.NonOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.AvgOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.MaxOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.MinOperator;
import kd.sit.sitbp.common.cal.impl.operator.arith.SumOperator;
import kd.sit.sitbp.common.cal.model.OpMatcherInfo;
import kd.sit.sitbp.common.util.MatchUtil;

public enum CalUnitOperatorEnum implements CalUnitOpName
{
    SUM("SUM(".toCharArray(), ")".toCharArray(), 8089, SumOperator.getInstance(), ", "),
    MAX("MAX(".toCharArray(), ")".toCharArray(), 8089, MaxOperator.getInstance(), ", "),
    MIN("MIN(".toCharArray(), ")".toCharArray(), 8089, MinOperator.getInstance(), ", "),
    AVG("AVG(".toCharArray(), ")".toCharArray(), 8089, AvgOperator.getInstance(), ", "),
    UNIT("(".toCharArray(), ")".toCharArray(), 8088, NonOperator.getInstance(), ", ");

    private final char[] startCode;
    private final char[] endCode;
    private final int priority;
    private final CalOperator operator;
    private final String splitChars;

    private CalUnitOperatorEnum(char[] startCode, char[] endCode, int priority, CalOperator operator, String splitChars) {
        this.startCode = startCode;
        this.endCode = endCode;
        this.priority = priority;
        this.operator = operator;
        this.splitChars = splitChars;
    }

    @Override
    public boolean match(OpMatcherInfo opMatcherInfo, char[] chars) {
        return CalResolverFactory.matchCalUnit(opMatcherInfo, this, chars, opMatcherInfo.getStartIndex());
    }

    @Override
    public int matchEnd(char[] chars, int startIndex) {
        return MatchUtil.matchChars(this.endCode, chars, startIndex);
    }

    @Override
    public boolean isSplitChar(char ch) {
        return this.splitChars.indexOf(ch) >= 0;
    }

    @Override
    public char[] startCode() {
        return this.startCode;
    }

    @Override
    public char[] endCode() {
        return this.startCode;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public CalOperator operator() {
        return this.operator;
    }

    @Override
    public String expression() {
        return new String(this.startCode);
    }
}

