/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.factory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.sit.sitbp.common.cal.api.CalNode;
import kd.sit.sitbp.common.cal.api.CalOperatorNode;
import kd.sit.sitbp.common.cal.api.CalUnitOpName;
import kd.sit.sitbp.common.cal.api.OperatorMatcher;
import kd.sit.sitbp.common.cal.api.OperatorName;
import kd.sit.sitbp.common.cal.exception.IllegalExpresionException;
import kd.sit.sitbp.common.cal.impl.NonCalUnitOpName;
import kd.sit.sitbp.common.cal.model.OpMatcherInfo;
import kd.sit.sitbp.common.cal.model.node.NumberNode;
import kd.sit.sitbp.common.cal.model.node.UnitProxyOpNode;
import kd.sit.sitbp.common.util.MatchUtil;

public class CalResolverFactory {
    private static final List<OperatorMatcher> OPERATOR_MATCHERS = new ArrayList<OperatorMatcher>();
    private static final List<OperatorName> OPERATOR_NAMES = new ArrayList<OperatorName>();

    public static CalNode resolve(String expression) {
        OpMatcherInfo parentInfo = new OpMatcherInfo();
        CalResolverFactory.resolveChars(parentInfo, NonCalUnitOpName.getInstance(), expression.toCharArray(), 0);
        return CalResolverFactory.organize(parentInfo.getNodes());
    }

    public static void resolveChars(OpMatcherInfo parentInfo, CalUnitOpName opName, char[] chars, int startIndex) {
        LinkedList<CalNode> nodeQueue = new LinkedList<CalNode>();
        OpMatcherInfo opMatcherInfo = new OpMatcherInfo();
        CalNode node = null;
        StringBuilder query = new StringBuilder();
        block0: for (int i = startIndex; i < chars.length; ++i) {
            Object rightNode;
            int unitEndIndex = opName.matchEnd(chars, i);
            if (unitEndIndex > 0) {
                parentInfo.setEndIndex(unitEndIndex);
                parentInfo.setNodes(nodeQueue);
                node = parentInfo.calNode(chars);
                if (query.length() > 0) {
                    rightNode = CalResolverFactory.generateNode(node, query, false);
                    nodeQueue.add((CalNode)rightNode);
                    rightNode.ready();
                    query.setLength(0);
                }
                return;
            }
            for (OperatorMatcher matcher : OPERATOR_MATCHERS) {
                if (!matcher.match(opMatcherInfo.refresh(matcher, i, nodeQueue.peekLast(), query), chars)) continue;
                node = opMatcherInfo.calNode(chars);
                if (query.length() > 0) {
                    CalNode leftNode = CalResolverFactory.generateNode(node, query, true);
                    nodeQueue.add(leftNode);
                    leftNode.ready();
                    query.setLength(0);
                }
                nodeQueue.add(node);
                node.ready();
                i = opMatcherInfo.getEndIndex() - 1;
                opMatcherInfo = new OpMatcherInfo();
                continue block0;
            }
            if (opName.isSplitChar(chars[i])) {
                if (query.length() == 0) continue;
                rightNode = CalResolverFactory.generateNode(node, query, false);
                nodeQueue.add((CalNode)rightNode);
                rightNode.ready();
                query.setLength(0);
                continue;
            }
            query.append(chars[i]);
        }
        if (query.length() > 0) {
            CalNode rightNode = CalResolverFactory.generateNode(node, query, false);
            nodeQueue.add(rightNode);
            rightNode.ready();
        }
        parentInfo.setNodes(nodeQueue);
    }

    public static boolean matchCalUnit(OpMatcherInfo opMatcherInfo, CalUnitOpName opName, char[] chars, int startIndex) {
        int endIndex = MatchUtil.matchChars(opName.startCode(), chars, startIndex);
        if (endIndex == 0) {
            return false;
        }
        if (!ArrayUtils.isEmpty((char[])opName.endCode())) {
            CalResolverFactory.resolveChars(opMatcherInfo, opName, chars, endIndex);
        }
        if (opMatcherInfo.getEndIndex() == 0) {
            return false;
        }
        opMatcherInfo.setOperatorName(opName);
        opMatcherInfo.setStartIndex(startIndex);
        return true;
    }

    public static CalNode generateNode(CalNode parent, StringBuilder query, boolean left) {
        if (!(parent instanceof CalOperatorNode)) {
            return new NumberNode(query.toString());
        }
        if (left) {
            return ((CalOperatorNode)parent).genLeftChild(query);
        }
        return ((CalOperatorNode)parent).genRightChild(query);
    }

    public static CalNode organize(LinkedList<CalNode> nodeQueue) {
        CalOperatorNode root = null;
        ArrayList<CalNode> numNodes = new ArrayList<CalNode>(10);
        while (!nodeQueue.isEmpty()) {
            CalNode node = nodeQueue.remove();
            if (node instanceof CalOperatorNode) {
                if (root == null) {
                    root = (CalOperatorNode)node;
                    if (numNodes.isEmpty()) continue;
                    root.appendLeftChild(numNodes);
                    numNodes.clear();
                    continue;
                }
                nodeQueue.push(node);
                root.appendRightChild(numNodes);
                numNodes.clear();
                break;
            }
            numNodes.add(node);
        }
        if (!numNodes.isEmpty()) {
            if (root == null) {
                if (numNodes.size() == 1) {
                    return new UnitProxyOpNode((CalNode)numNodes.get(0));
                }
                throw new IllegalExpresionException();
            }
            root.appendRightChild(numNodes);
            numNodes.clear();
            return root;
        }
        CalOperatorNode tmp = null;
        while (!nodeQueue.isEmpty()) {
            CalNode node = nodeQueue.remove();
            if (node instanceof CalOperatorNode) {
                if (tmp == null) {
                    tmp = (CalOperatorNode)node;
                    continue;
                }
                nodeQueue.push(node);
                root = CalResolverFactory.rebuildRoot(root, tmp);
                if (!numNodes.isEmpty()) {
                    tmp.appendRightChild(numNodes);
                }
                tmp = null;
                numNodes.clear();
                continue;
            }
            numNodes.add(node);
        }
        if (tmp != null && !numNodes.isEmpty()) {
            root = CalResolverFactory.rebuildRoot(root, tmp);
            tmp.appendRightChild(numNodes);
            numNodes.clear();
        }
        return root;
    }

    private static CalOperatorNode rebuildRoot(CalOperatorNode root, CalOperatorNode node) {
        if (root == null) {
            return node;
        }
        if (node == null) {
            return root;
        }
        if (node.priority() <= root.priority()) {
            node.appendLeftChild(root);
            return node;
        }
        CalOperatorNode preTmp = root;
        CalNode tmp = root.rightChild();
        while (tmp instanceof CalOperatorNode && tmp.priority() < node.priority()) {
            preTmp = (CalOperatorNode)tmp;
            tmp = preTmp.rightChild();
        }
        if (tmp != null) {
            node.appendLeftChild(tmp);
        }
        preTmp.replaceRight(node);
        return root;
    }

    public static List<OperatorName> supportOps() {
        return OPERATOR_NAMES;
    }

    static {
        ServiceLoader<OperatorMatcher> loader = ServiceLoader.load(OperatorMatcher.class);
        for (OperatorMatcher next : loader) {
            OPERATOR_MATCHERS.add(next);
            List<OperatorName> supportOps = next.supportOps();
            OPERATOR_NAMES.addAll(supportOps);
        }
    }
}

