/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.impl.operator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.cal.api.CalOperator;
import kd.sit.sitbp.common.cal.api.ValueDecorator;

public class ValueByKeyOperator
implements CalOperator<Object> {
    private static final String DEFAULT_PATH = "";
    private String[] paths;
    private static final Map<String, Map<ValueDecorator, Map<ValueDecorator, ValueByKeyOperator>>> INSTANCES = new ConcurrentHashMap<String, Map<ValueDecorator, Map<ValueDecorator, ValueByKeyOperator>>>();
    private final ValueDecorator keyDecorator;
    private final ValueDecorator valueDecorator;

    private ValueByKeyOperator(ValueDecorator keyDecorator, ValueDecorator valueDecorator, String ... paths) {
        this.keyDecorator = keyDecorator == null ? ValueDecorator.DEFAULT : keyDecorator;
        this.valueDecorator = valueDecorator == null ? ValueDecorator.DEFAULT : valueDecorator;
        this.paths = paths;
    }

    public static ValueByKeyOperator getInstance(ValueDecorator keyDecorator, ValueDecorator valueDecorator, String ... paths) {
        String key = DEFAULT_PATH;
        if (!ArrayUtils.isEmpty((Object[])paths)) {
            key = StringUtils.join((Object[])paths, (String)".");
        }
        Map valueDecoratorMapMap = INSTANCES.computeIfAbsent(key, ky -> new ConcurrentHashMap(16));
        Map valueByKeyOperatorMap = valueDecoratorMapMap.computeIfAbsent(keyDecorator, ky -> new ConcurrentHashMap(16));
        return valueByKeyOperatorMap.computeIfAbsent(valueDecorator, ky -> new ValueByKeyOperator(keyDecorator, valueDecorator, paths));
    }

    @Override
    public Object operate(List<?> leftParams, List<?> rightParams, Map<?, ?> params) {
        if (CollectionUtils.isEmpty(rightParams)) {
            return null;
        }
        Object key = this.keyDecorator.decorate(rightParams.get(0));
        Map tmp = params;
        if (!ArrayUtils.isEmpty((Object[])this.paths)) {
            for (int i = 0; i < this.paths.length; ++i) {
                Object obj = tmp.get(this.paths[i]);
                if (!(obj instanceof Map)) {
                    return null;
                }
                tmp = (Map)obj;
            }
        }
        return this.valueDecorator.decorate(tmp.get(key));
    }
}

