/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.impl.operator.arith;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.cal.api.CalOperator;
import kd.sit.sitbp.common.cal.model.ScaleModel;
import kd.sit.sitbp.common.util.SitMathUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class AvgOperator
implements CalOperator<BigDecimal> {
    private static final AvgOperator INSTANCE = new AvgOperator();

    private AvgOperator() {
    }

    public static AvgOperator getInstance() {
        return INSTANCE;
    }

    @Override
    public BigDecimal operate(List<?> leftParams, List<?> rightParams, Map<?, ?> params) {
        AvgUnit avgUnit = new AvgUnit();
        if (!CollectionUtils.isEmpty(leftParams)) {
            for (Object obj : leftParams) {
                avgUnit.join(obj);
            }
        }
        if (!CollectionUtils.isEmpty(rightParams)) {
            for (Object obj : rightParams) {
                avgUnit.join(obj);
            }
        }
        ScaleModel scaleMode = SitMathUtil.resolveScale(params);
        return avgUnit.result(scaleMode);
    }

    public static class AvgUnit {
        private int num = 0;
        private BigDecimal sum = new BigDecimal("0");

        public void join(Object obj) {
            if (obj == null) {
                return;
            }
            ++this.num;
            this.sum = this.sum.add(BaseDataConverter.convert(obj, BigDecimal.class));
        }

        public BigDecimal result(ScaleModel scaleMode) {
            if (this.num == 0) {
                return this.sum;
            }
            return this.sum.divide(new BigDecimal(this.num), scaleMode.getScale(), scaleMode.getRoundingMode());
        }
    }
}

