/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.impl.unicode.insurance;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.basecal.BaseCalParam;
import kd.sdk.sit.sitbp.entity.Pair;
import kd.sdk.sit.sitbp.service.spi.SInsurCalItemUniCodeResolver;
import kd.sit.sitbp.common.cal.impl.unicode.insurance.SInsurFieldUniCodeResolver;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.SitDateUtil;

public class SInsurBaseFetchItemUniCodeResolver
implements SInsurCalItemUniCodeResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, ILocaleString> getItemNameMap() {
        HashMap<String, ILocaleString> fetchItemNameMap = (HashMap<String, ILocaleString>)GlobalParam.get("fetchItemNameMap");
        if (fetchItemNameMap != null) return fetchItemNameMap;
        Class<SInsurFieldUniCodeResolver> clazz = SInsurFieldUniCodeResolver.class;
        synchronized (SInsurFieldUniCodeResolver.class) {
            DynamicObject[] fetchItems;
            fetchItemNameMap = (Map)GlobalParam.get("fetchItemNameMap");
            if (fetchItemNameMap != null) return fetchItemNameMap;
            fetchItemNameMap = new HashMap<String, ILocaleString>(16);
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_basefetchitem");
            for (DynamicObject fetchItem : fetchItems = helper.query("id,name", new QFilter("1", "=", (Object)1).toArray())) {
                fetchItemNameMap.put(String.valueOf(fetchItem.get("id")), fetchItem.getLocaleString("name"));
            }
            GlobalParam.set("fetchItemNameMap", fetchItemNameMap);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fetchItemNameMap;
        }
    }

    public String getUnicodeName(String unicode) {
        String itemId = this.getItemId(unicode);
        ILocaleString itemLocalString = SInsurBaseFetchItemUniCodeResolver.getItemNameMap().get(itemId);
        if (itemLocalString != null) {
            return itemLocalString.getLocaleValue();
        }
        return unicode;
    }

    private String getItemId(String unicode) {
        Pair pair = SInsurCalItemUniCodeResolver.bizCode((String)unicode);
        String itemId = (String)pair.getValue();
        return itemId;
    }

    public String prefix() {
        return "FI";
    }

    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> itemKeys, Map<String, CalItemVO> uniqueCodeCalItemMap, BaseCalParam param) {
        for (String itemKey : itemKeys) {
            String uniCode = this.uniCode(itemKey);
            CalItemVO calItemVO = new CalItemVO();
            calItemVO.setId(uniCode);
            calItemVO.setName((String)param.getFetchItemNameMap().get(itemKey));
            calItemVO.setDataType(DataTypeEnum.NUM);
            calItemVO.setUniqueCode(uniCode);
            calItemVO.setRoundingMode(RoundingMode.HALF_UP);
            calItemVO.setDataLength(Integer.valueOf(24));
            calItemVO.setScale(Integer.valueOf(6));
            uniqueCodeCalItemMap.put(calItemVO.getUniqueCode(), calItemVO);
        }
    }

    public void fecthData(Map<String, Map<String, Object>> paramIdToParamMap, Map<Long, Map<String, String>> fileUnicodeErrMap, DynamicObjectCollection files, Set<String> fields, Date bsed) {
        HashSet<Long> fetchItemIds = new HashSet<Long>(fields.size());
        for (String field : fields) {
            fetchItemIds.add(Long.valueOf(field));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsbs_sinsbsfetchcfg");
        QFilter filter = new QFilter("basefetchitem", "in", fetchItemIds);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] cfgs = helper.query("basefetchitem,fetchsrc,accumulator,standarditem,querytime", filter.toArray());
        Map<String, Map<String, List<DynamicObject>>> cfgMap = Arrays.stream(cfgs).collect(Collectors.groupingBy(o -> o.getString("fetchsrc"), Collectors.groupingBy(o -> o.getString("querytime"))));
        HashSet<Long> employeIds = new HashSet<Long>(fields.size());
        HashSet<Long> personIndexIds = new HashSet<Long>(fields.size());
        HashMap<Long, List<Long>> personEmpMap = new HashMap<Long, List<Long>>(fields.size());
        for (DynamicObject file : files) {
            long personindexid = file.getLong("personindexid");
            long employeeId = file.getLong("employee.id");
            employeIds.add(employeeId);
            personIndexIds.add(personindexid);
            List employees = personEmpMap.computeIfAbsent(personindexid, o -> new ArrayList(10));
            employees.add(employeeId);
        }
        HashMap<Long, Map<String, Map<String, Map<Long, Object>>>> fetchResult = new HashMap<Long, Map<String, Map<String, Map<Long, Object>>>>(16);
        for (Map.Entry<String, Map<String, List<DynamicObject>>> srcEntry : cfgMap.entrySet()) {
            String src = srcEntry.getKey();
            Map<String, List<DynamicObject>> timeCfgMap = srcEntry.getValue();
            for (Map.Entry<String, List<DynamicObject>> timeEntry : timeCfgMap.entrySet()) {
                String queryTime = timeEntry.getKey();
                Date startdate = bsed;
                Date enddate = bsed;
                switch (queryTime) {
                    case "cy": {
                        startdate = SitDateUtil.firstDayOfYear(bsed);
                        enddate = SitDateUtil.lastDayOfYear(bsed);
                        break;
                    }
                    case "ly": {
                        Date laseYear = SITDateTimeUtils.addYear(bsed, -1);
                        startdate = SitDateUtil.firstDayOfYear(laseYear);
                        enddate = SitDateUtil.lastDayOfYear(laseYear);
                        break;
                    }
                    case "lm": {
                        Date lastMonth = SITDateTimeUtils.addMonth(bsed, -1);
                        startdate = SitDateUtil.firstDayOfMonth(lastMonth);
                        enddate = SitDateUtil.lastDateOfMonth(lastMonth);
                        break;
                    }
                    case "cm": {
                        startdate = SitDateUtil.firstDayOfMonth(bsed);
                        enddate = SitDateUtil.lastDateOfMonth(bsed);
                        break;
                    }
                }
                List<DynamicObject> batchCfgs = timeEntry.getValue();
                switch (src) {
                    case "accumulator": {
                        this.getACCResult(employeIds, fetchResult, src, queryTime, startdate, enddate, batchCfgs, personIndexIds, personEmpMap);
                        break;
                    }
                    case "standarditem": {
                        this.getStandResult(employeIds, fetchResult, src, queryTime, startdate, enddate, batchCfgs);
                        break;
                    }
                }
            }
        }
        for (DynamicObject file : files) {
            long emplyeeId = file.getLong("employee.id");
            long fileId = file.getLong("id");
            Map valueMap = paramIdToParamMap.computeIfAbsent(String.valueOf(fileId), o -> new HashMap(16));
            Map errMap = fileUnicodeErrMap.computeIfAbsent(fileId, o -> new HashMap(16));
            for (DynamicObject cfg : cfgs) {
                Object value;
                Map itemMap;
                Map timeMap;
                long basefetchitemId = cfg.getLong("basefetchitem");
                String fetchsrc = cfg.getString("fetchsrc");
                String querytime = cfg.getString("querytime");
                long itemId = 0L;
                switch (fetchsrc) {
                    case "accumulator": {
                        itemId = cfg.getLong("accumulator.id");
                        break;
                    }
                    case "standarditem": {
                        itemId = cfg.getLong("standarditem.id");
                        break;
                    }
                }
                Map srcMap = (Map)fetchResult.get(emplyeeId);
                if (srcMap == null || (timeMap = (Map)srcMap.get(fetchsrc)) == null || (itemMap = (Map)timeMap.get(querytime)) == null || (value = itemMap.get(itemId)) == null) continue;
                if (value instanceof BigDecimal) {
                    valueMap.put(this.uniCode(String.valueOf(basefetchitemId)), value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                errMap.put(this.uniCode(String.valueOf(basefetchitemId)), (String)value);
            }
        }
    }

    private void getStandResult(Set<Long> employeIds, Map<Long, Map<String, Map<String, Map<Long, Object>>>> fetchResult, String src, String queryTime, Date startdate, Date enddate, List<DynamicObject> batchCfgs) {
        DynamicObjectCollection standarditemResults = this.queryStandResult(employeIds, startdate, enddate, batchCfgs);
        Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> employeeStandardMap = standarditemResults.stream().collect(Collectors.groupingBy(o -> o.getLong("salaryadjfile.employee.id"), Collectors.groupingBy(o -> o.getLong("standarditem.id"), Collectors.groupingBy(o -> o.getLong("salaryadjfile.id")))));
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        QFilter filter = new QFilter("employee", "in", employeIds);
        filter.and("bsed", "<=", (Object)enddate);
        filter.and("bsled", ">=", (Object)startdate);
        filter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        filter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObjectCollection files = fileHelper.queryOriginalCollection("boid,employee.id,isprimary", filter.toArray());
        Set allPrimaryIds = files.stream().filter(o -> o.getBoolean("isprimary")).map(o -> o.getLong("boid")).collect(Collectors.toSet());
        Map employeeNoPrimaryMap = files.stream().filter(o -> !allPrimaryIds.contains(o.getLong("boid"))).collect(Collectors.groupingBy(o -> o.getLong("employee.id"), Collectors.mapping(o -> o.getLong("boid"), Collectors.toSet())));
        for (Long employeId : employeIds) {
            Map<Long, Map<Long, List<DynamicObject>>> itemFileStandardMap = employeeStandardMap.get(employeId);
            if (itemFileStandardMap == null) continue;
            for (Map.Entry<Long, Map<Long, List<DynamicObject>>> itemFileEntry : itemFileStandardMap.entrySet()) {
                Set noPrimaryIds;
                Date bsed;
                List<DynamicObject> standards;
                Map<Long, List<DynamicObject>> fileStandardMap = itemFileEntry.getValue();
                Long standarditemId = itemFileEntry.getKey();
                if (fileStandardMap == null) continue;
                Date latestBsed = null;
                BigDecimal value = null;
                for (Map.Entry<Long, List<DynamicObject>> entry : fileStandardMap.entrySet()) {
                    Long fileId = entry.getKey();
                    if (!allPrimaryIds.contains(fileId) || (standards = entry.getValue()) == null) continue;
                    for (DynamicObject standard : standards) {
                        bsed = standard.getDate("bsed");
                        if (bsed == null || latestBsed != null && !bsed.after(latestBsed)) continue;
                        value = standard.getBigDecimal("amount");
                        latestBsed = bsed;
                    }
                }
                latestBsed = null;
                if (value == null && (noPrimaryIds = employeeNoPrimaryMap.get(employeId)) != null) {
                    if (noPrimaryIds.size() == 1) {
                        Map.Entry<Long, List<DynamicObject>> entry;
                        entry = noPrimaryIds.iterator();
                        while (entry.hasNext()) {
                            Long noPrimaryId = (Long)entry.next();
                            standards = fileStandardMap.get(noPrimaryId);
                            if (standards == null) continue;
                            for (DynamicObject standard : standards) {
                                bsed = standard.getDate("bsed");
                                if (standard.getLong("salaryadjfile.id") != noPrimaryId.longValue() || bsed == null || latestBsed != null && !bsed.after(latestBsed)) continue;
                                value = standard.getBigDecimal("amount");
                                latestBsed = bsed;
                            }
                        }
                    } else if (noPrimaryIds.size() > 1) {
                        Map srcMap = fetchResult.computeIfAbsent(employeId, o -> new HashMap(16));
                        Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                        Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                        itemValueMap.putIfAbsent(standarditemId, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5b58\u5728\u591a\u4efd\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u65e0\u6cd5\u5339\u914d\u552f\u4e00\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u624b\u52a8\u7ef4\u62a4\u8be5\u9669\u79cd\u57fa\u6570\u3002", (String)"SInsurBaseFetchItemUniCodeResolver_0", (String)"sit-sitbp-common", (Object[])new Object[0]));
                    }
                }
                if (value == null) continue;
                Map srcMap = fetchResult.computeIfAbsent(employeId, o -> new HashMap(16));
                Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                itemValueMap.putIfAbsent(standarditemId, value);
            }
        }
    }

    private DynamicObjectCollection queryStandResult(Set<Long> employeIds, Date startdate, Date enddate, List<DynamicObject> batchCfgs) {
        List standarditemIds = batchCfgs.stream().map(o -> o.getLong("standarditem.id")).collect(Collectors.toList());
        QFilter filter = new QFilter("salaryadjfile.employee.id", "in", employeIds);
        filter.and("bsed", "<=", (Object)enddate);
        filter.and("bsled", ">=", (Object)startdate);
        filter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        filter.and("standarditem", "in", standarditemIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_salaryadjrecord");
        return helper.queryOriginalCollection("amount,standarditem.id,bsed,bsled,salaryadjfile.id,salaryadjfile.employee.id", filter.toArray());
    }

    private void getACCResult(Set<Long> employeIds, Map<Long, Map<String, Map<String, Map<Long, Object>>>> fetchResult, String src, String queryTime, Date startdate, Date enddate, List<DynamicObject> batchCfgs, Set<Long> personIndexIds, Map<Long, List<Long>> personEmpMap) {
        List accumulatorIds = batchCfgs.stream().map(o -> o.getLong("accumulator.id")).collect(Collectors.toList());
        QFilter qfilter = new QFilter("personindexid", "in", personIndexIds);
        qfilter.and("startdate", "<=", (Object)enddate);
        qfilter.and("enddate", ">=", (Object)startdate);
        qfilter.and("acc", "in", accumulatorIds);
        HRBaseServiceHelper accHelper = new HRBaseServiceHelper("hsas_accresult");
        DynamicObjectCollection accResults = accHelper.queryOriginalCollection("acc.id,acc.accdimension,resultvalue,startdate,employee.id,personindexid,salaryfile.id,salaryfile.status", qfilter.toArray(), "personindexid,startdate desc");
        Map<String, List<DynamicObject>> dimensionResultsMap = accResults.stream().collect(Collectors.groupingBy(o -> o.getString("acc.accdimension")));
        List<DynamicObject> personDimensionResults = dimensionResultsMap.get("0");
        List<DynamicObject> employeeDimensionResults = dimensionResultsMap.get("1");
        List<Object> fileDimensionResults = dimensionResultsMap.get("2");
        if (personDimensionResults != null) {
            for (DynamicObject accResult : personDimensionResults) {
                long personindexid = accResult.getLong("personindexid");
                List<Long> employeeIds = personEmpMap.get(personindexid);
                if (employeeIds == null) continue;
                for (Long employeeId : employeeIds) {
                    long accItemId = accResult.getLong("acc.id");
                    Map srcMap = fetchResult.computeIfAbsent(employeeId, o -> new HashMap(16));
                    Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                    Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                    itemValueMap.put(accItemId, accResult.getBigDecimal("resultvalue"));
                }
            }
        }
        if (employeeDimensionResults != null) {
            for (DynamicObject accResult : employeeDimensionResults) {
                long employeeId = accResult.getLong("employee.id");
                long accItemId = accResult.getLong("acc.id");
                Map srcMap = fetchResult.computeIfAbsent(employeeId, o -> new HashMap(16));
                Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                itemValueMap.put(accItemId, accResult.getBigDecimal("resultvalue"));
            }
        }
        if (fileDimensionResults != null) {
            fileDimensionResults = fileDimensionResults.stream().filter(o -> SITStringUtils.equals(o.getString("salaryfile.status"), "C")).collect(Collectors.toList());
            Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> employeeAccMap = fileDimensionResults.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id"), Collectors.groupingBy(o -> o.getLong("acc.id"), Collectors.groupingBy(o -> o.getLong("salaryfile.id")))));
            HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hsas_salaryfile");
            QFilter filter = new QFilter("employee", "in", employeIds);
            filter.and("bsed", "<=", (Object)enddate);
            filter.and("bsled", ">=", (Object)startdate);
            filter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
            filter.and("salaryfile.status", "=", (Object)"C");
            filter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
            DynamicObjectCollection files = fileHelper.queryOriginalCollection("boid,employee.id,depemp.isprimary", filter.toArray());
            Set allPrimaryIds = files.stream().filter(o -> o.getBoolean("depemp.isprimary")).map(o -> o.getLong("boid")).collect(Collectors.toSet());
            Map employeeNoPrimaryMap = files.stream().filter(o -> !allPrimaryIds.contains(o.getLong("boid"))).collect(Collectors.groupingBy(o -> o.getLong("employee.id"), Collectors.mapping(o -> o.getLong("boid"), Collectors.toSet())));
            for (Long employeId : employeIds) {
                Map<Long, Map<Long, List<DynamicObject>>> itemFileAccMap = employeeAccMap.get(employeId);
                if (itemFileAccMap == null) continue;
                for (Map.Entry<Long, Map<Long, List<DynamicObject>>> accFileEntry : itemFileAccMap.entrySet()) {
                    Set noPrimaryIds;
                    Date bsed;
                    List<DynamicObject> fileAccResults;
                    Map<Long, List<DynamicObject>> fileAccMap = accFileEntry.getValue();
                    Long accId = accFileEntry.getKey();
                    if (fileAccMap == null) continue;
                    Date latestBsed = null;
                    BigDecimal value = null;
                    for (Map.Entry<Long, List<DynamicObject>> entry : fileAccMap.entrySet()) {
                        Long fileId = entry.getKey();
                        if (!allPrimaryIds.contains(fileId) || (fileAccResults = entry.getValue()) == null) continue;
                        for (DynamicObject fileAccResult : fileAccResults) {
                            bsed = fileAccResult.getDate("startdate");
                            if (bsed == null || latestBsed != null && !bsed.after(latestBsed)) continue;
                            value = fileAccResult.getBigDecimal("resultvalue");
                            latestBsed = bsed;
                        }
                    }
                    latestBsed = null;
                    if (value == null && (noPrimaryIds = employeeNoPrimaryMap.get(employeId)) != null) {
                        if (noPrimaryIds.size() == 1) {
                            Map.Entry<Long, List<DynamicObject>> entry;
                            entry = noPrimaryIds.iterator();
                            while (entry.hasNext()) {
                                Long noPrimaryId = (Long)entry.next();
                                fileAccResults = fileAccMap.get(noPrimaryId);
                                if (fileAccResults == null) continue;
                                for (DynamicObject fileAccResult : fileAccResults) {
                                    bsed = fileAccResult.getDate("startdate");
                                    if (fileAccResult.getLong("salaryfile.id") != noPrimaryId.longValue() || bsed == null || latestBsed != null && !bsed.after(latestBsed)) continue;
                                    value = fileAccResult.getBigDecimal("resultvalue");
                                    latestBsed = bsed;
                                }
                            }
                        } else if (noPrimaryIds.size() > 1) {
                            Map srcMap = fetchResult.computeIfAbsent(employeId, o -> new HashMap(16));
                            Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                            Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                            itemValueMap.put(accId, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5b58\u5728\u591a\u4efd\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u5339\u914d\u552f\u4e00\u7d2f\u52a0\u7ed3\u679c\uff0c\u8bf7\u624b\u52a8\u7ef4\u62a4\u8be5\u9669\u79cd\u57fa\u6570\u3002", (String)"SInsurBaseFetchItemUniCodeResolver_1", (String)"sit-sitbp-common", (Object[])new Object[0]));
                        }
                    }
                    if (value == null) continue;
                    Map srcMap = fetchResult.computeIfAbsent(employeId, o -> new HashMap(16));
                    Map queryTimeMap = srcMap.computeIfAbsent(src, o -> new HashMap(16));
                    Map itemValueMap = queryTimeMap.computeIfAbsent(queryTime, o -> new HashMap(16));
                    itemValueMap.put(accId, value);
                }
            }
        }
    }
}

