/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.impl.unicode.insurance;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.hcsi.common.entity.basecal.BaseCalParam;
import kd.sdk.sit.sitbp.entity.Pair;
import kd.sdk.sit.sitbp.service.spi.SInsurCalItemUniCodeResolver;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.SInsurFormulaCalUtils;

public abstract class SInsurFieldUniCodeResolver
implements SInsurCalItemUniCodeResolver {
    private static final Map<String, Map<String, ILocaleString>> propNameMap = new HashMap<String, Map<String, ILocaleString>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Map<String, ILocaleString>> getPropNameMap() {
        if (propNameMap.size() != 0) return propNameMap;
        Class<SInsurFieldUniCodeResolver> clazz = SInsurFieldUniCodeResolver.class;
        synchronized (SInsurFieldUniCodeResolver.class) {
            if (propNameMap.size() != 0) return propNameMap;
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_siformulacfg");
            DynamicObject cfgDy = helper.loadDynamicObject(new QFilter("number", "=", (Object)"1010_S"));
            DynamicObjectCollection entryentity = cfgDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String parentnodevalue = entry.getString("parentnodevalue");
                String fieldvalue = entry.getString("fieldvalue");
                ILocaleString nodename = entry.getLocaleString("nodename");
                String nodetype = entry.getString("nodetype");
                if (!SITStringUtils.equals(nodetype, "1")) continue;
                Map filedNameMap = propNameMap.computeIfAbsent(parentnodevalue, o -> new HashMap(16));
                filedNameMap.put(fieldvalue, nodename);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return propNameMap;
        }
    }

    public String getUnicodeName(String unicode) {
        ILocaleString localeString;
        Pair pair = SInsurCalItemUniCodeResolver.bizCode((String)unicode);
        String field = (String)pair.getValue();
        int index = field.indexOf(46);
        String fieldName = field.substring(index + 1);
        Map<String, ILocaleString> fileNameMap = SInsurFieldUniCodeResolver.getPropNameMap().get(this.prefix());
        if (fileNameMap != null && (localeString = fileNameMap.get(fieldName)) != null) {
            return localeString.getLocaleValue();
        }
        return unicode;
    }

    public String encode(String bizCode) {
        return bizCode.replace('.', '$');
    }

    public String decode(String bizCode) {
        return bizCode.replace('$', '.');
    }

    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> itemKeys, Map<String, CalItemVO> uniqueCodeCalItemMap, BaseCalParam param) {
        HashMap<String, MainEntityType> typeMap = new HashMap<String, MainEntityType>(16);
        for (String obj : itemKeys) {
            int index = obj.indexOf(46);
            if (index < 0) {
                return;
            }
            String metaTag = obj.substring(0, index);
            String fields = obj.substring(index + 1);
            CalItemVO fileVO = SInsurFormulaCalUtils.getCalItemVO(metaTag, fields, typeMap);
            String uniCode = this.uniCode(obj);
            fileVO.setUniqueCode(uniCode);
            uniqueCodeCalItemMap.put(uniCode, fileVO);
        }
    }

    public Map<String, String> getProps(Set<String> fields) {
        HashMap<String, String> fieldPropMap = new HashMap<String, String>(fields.size());
        for (String field : fields) {
            int index;
            String prop = field.substring((index = field.indexOf(46)) + 1);
            if (this.calItemUnicodeNeedBaseDataConvert(prop)) {
                prop = prop.substring(0, prop.lastIndexOf(46));
            }
            fieldPropMap.put(field, prop);
        }
        return fieldPropMap;
    }

    public boolean calItemUnicodeNeedBaseDataConvert(String prop) {
        return prop != null && prop.indexOf(46) > 0 && !prop.endsWith(".id");
    }
}

