/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.impl.unicode.insurance;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.cal.impl.unicode.insurance.SInsurFieldUniCodeResolver;

public class SInsurPersonBaseInfoUniCodeResolver
extends SInsurFieldUniCodeResolver {
    public String prefix() {
        return "IP";
    }

    public void fecthData(Map<String, Map<String, Object>> paramIdToParamMap, Map<Long, Map<String, String>> errMap, DynamicObjectCollection files, Set<String> fields, Date bsed) {
        Map<String, String> props = this.getProps(fields);
        HashSet<String> queryprops = new HashSet<String>(props.values());
        queryprops.add("person.id");
        queryprops.add("placeofwelfare.id");
        String selectprops = String.join((CharSequence)",", queryprops);
        List personIds = files.stream().map(o -> o.getLong("person.id")).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurperson");
        QFilter boidFilter = new QFilter("person.id", "in", personIds);
        QFilter hisfilter = new QFilter("status", "=", (Object)"C");
        hisfilter.and("bsed", "<=", (Object)bsed);
        hisfilter.and("bsled", ">=", (Object)bsed);
        hisfilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        hisfilter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        QFilter savefilter = new QFilter("status", "=", (Object)"A");
        savefilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        hisfilter.or(savefilter);
        boidFilter.and(hisfilter);
        DynamicObject[] personvArr = helper.query(selectprops, boidFilter.toArray());
        Map<Long, List<DynamicObject>> personMap = Arrays.stream(personvArr).collect(Collectors.groupingBy(o -> o.getLong("person.id")));
        for (DynamicObject file : files) {
            long fileId = file.getLong("id");
            long personId = file.getLong("person.id");
            long placeofwelfareId = file.getLong("welfarepayer.placeofwelfare.id");
            List<DynamicObject> sinsurpersons = personMap.get(personId);
            if (sinsurpersons == null) continue;
            DynamicObject sinsurperson = sinsurpersons.stream().filter(o -> o.getLong("placeofwelfare.id") == placeofwelfareId).findAny().orElse(null);
            Map valueMap = paramIdToParamMap.computeIfAbsent(String.valueOf(fileId), o -> new HashMap(16));
            if (sinsurperson == null) continue;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                Object value = sinsurperson.get(entry.getValue());
                if (value == null) continue;
                String unicode = this.uniCode(entry.getKey());
                valueMap.put(unicode, value);
            }
        }
    }
}

