/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.model;

import java.util.Arrays;
import java.util.LinkedList;
import kd.sit.sitbp.common.cal.api.CalNode;
import kd.sit.sitbp.common.cal.api.CalOperatorNode;
import kd.sit.sitbp.common.cal.api.OperatorMatcher;
import kd.sit.sitbp.common.cal.api.OperatorName;
import kd.sit.sitbp.common.cal.model.node.NumberNode;

public class OpMatcherInfo {
    protected int startIndex;
    protected int endIndex;
    protected OperatorMatcher matcher;
    protected OperatorName operatorName;
    protected LinkedList<CalNode> nodes;
    protected boolean hasLeftNumberNode;

    public OpMatcherInfo refresh(OperatorMatcher matcher, int startIndex, CalNode leftNode, StringBuilder leftChars) {
        this.setMatcher(matcher);
        this.setStartIndex(startIndex);
        boolean isLeftNodeCalOpOrNull = leftNode instanceof CalOperatorNode || leftNode == null;
        this.hasLeftNumberNode = !isLeftNodeCalOpOrNull || leftChars.length() != 0;
        return this;
    }

    public CalNode calNode(char[] chars) {
        if (this.matcher == null) {
            if (this.endIndex <= this.startIndex) {
                return null;
            }
            return new NumberNode(new String(Arrays.copyOfRange(chars, this.startIndex, this.endIndex)));
        }
        return this.matcher.calNode(this, chars);
    }

    public void clear() {
        this.endIndex = 0;
        this.operatorName = null;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public OperatorMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(OperatorMatcher matcher) {
        this.matcher = matcher;
    }

    public OperatorName getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(OperatorName operatorName) {
        this.operatorName = operatorName;
    }

    public LinkedList<CalNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(LinkedList<CalNode> nodes) {
        this.nodes = nodes;
    }

    public boolean isHasLeftNumberNode() {
        return this.hasLeftNumberNode;
    }

    public void setHasLeftNumberNode(boolean hasLeftNumberNode) {
        this.hasLeftNumberNode = hasLeftNumberNode;
    }
}

