/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.cal.model.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.sit.sitbp.common.cal.api.CalNode;
import kd.sit.sitbp.common.cal.api.CalOperator;
import kd.sit.sitbp.common.cal.api.CalOperatorNode;
import kd.sit.sitbp.common.cal.api.OperatorName;
import kd.sit.sitbp.common.util.SitBaseUtil;

public abstract class AbstractOperatorNode<T>
implements CalOperatorNode<T> {
    protected OperatorName operatorEnum;
    protected CalOperator<T> operator;
    protected List<CalNode> leftChildren = new ArrayList<CalNode>();
    protected List<CalNode> rightChildren = new ArrayList<CalNode>();

    protected AbstractOperatorNode(OperatorName operatorEnum) {
        this.operatorEnum = operatorEnum;
        this.operator = operatorEnum.operator();
    }

    @Override
    public T result(Map<?, ?> params) {
        ArrayList leftParams = new ArrayList(this.leftChildren.size());
        ArrayList rightParams = new ArrayList(this.rightChildren.size());
        for (CalNode child : this.leftChildren) {
            SitBaseUtil.plainAdd(leftParams, child.result(params));
        }
        for (CalNode child : this.rightChildren) {
            SitBaseUtil.plainAdd(rightParams, child.result(params));
        }
        return this.operator.operate(leftParams, rightParams, params);
    }

    @Override
    public void ready() {
    }

    @Override
    public void appendRightChild(List<CalNode> nodes) {
        this.rightChildren.addAll(nodes);
    }

    @Override
    public void appendRightChild(CalNode node) {
        this.rightChildren.add(node);
    }

    @Override
    public void replaceRight(CalNode node) {
        if (!this.rightChildren.isEmpty()) {
            this.rightChildren.remove(this.rightChildren.size() - 1);
        }
        this.rightChildren.add(node);
    }

    @Override
    public CalNode rightChild() {
        return this.rightChildren.isEmpty() ? null : this.rightChildren.get(0);
    }

    @Override
    public void appendLeftChild(List<CalNode> nodes) {
        this.leftChildren.addAll(nodes);
    }

    @Override
    public void appendLeftChild(CalNode node) {
        this.leftChildren.add(node);
    }

    @Override
    public void replaceLeft(CalNode node) {
        if (this.leftChildren.isEmpty()) {
            this.leftChildren.add(node);
        } else {
            this.leftChildren.set(0, node);
        }
    }

    @Override
    public CalNode leftChild() {
        return this.leftChildren.isEmpty() ? null : this.leftChildren.get(0);
    }

    @Override
    public int priority() {
        return this.operatorEnum.priority();
    }
}

