/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.util.CollectionUtils;

public class CalRuleEntity
implements Serializable {
    private static final long serialVersionUID = 8150525166164819154L;
    private Long id;
    private String number;
    private Map<String, String> name;
    private Long taxCategoryId;
    private Map<Long, Long> taxItemFormulaMap;

    public LocaleString getNameLocaleString() {
        if (this.name == null) {
            return null;
        }
        return LocaleString.fromMap(this.name);
    }

    public CalRuleEntity initBy(DynamicObject calRuleDy) {
        if (calRuleDy == null) {
            this.setId(0L);
            return this;
        }
        this.setId(calRuleDy.getLong("id"));
        this.setName((Map<String, String>)calRuleDy.getLocaleString("name"));
        this.setNumber(calRuleDy.getString("number"));
        this.taxCategoryId = calRuleDy.getLong("taxcategory.id");
        DynamicObjectCollection calruleitementry = calRuleDy.getDynamicObjectCollection("calruleitementry");
        if (!CollectionUtils.isEmpty((Collection)calruleitementry)) {
            this.taxItemFormulaMap = new LinkedHashMap<Long, Long>(calruleitementry.size());
            for (DynamicObject entryDy : calruleitementry) {
                long taxItemId = entryDy.getLong("taxitem.id");
                long formulaId = entryDy.getLong("formula.id");
                this.taxItemFormulaMap.put(taxItemId, formulaId);
            }
        }
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public Long getTaxCategoryId() {
        return this.taxCategoryId;
    }

    public void setTaxCategoryId(Long taxCategoryId) {
        this.taxCategoryId = taxCategoryId;
    }

    public Map<Long, Long> getTaxItemFormulaMap() {
        return this.taxItemFormulaMap;
    }

    public void setTaxItemFormulaMap(Map<Long, Long> taxItemFormulaMap) {
        this.taxItemFormulaMap = taxItemFormulaMap;
    }
}

