/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;

public class TaxItemEntity
implements Serializable {
    private static final long serialVersionUID = 7622113843788769131L;
    public static final String ENTITY_NAME = "sitbs_taxitem";
    private Long id;
    private String number;
    private String groupNumber;
    private int dataPrecisionScale;
    private long dataRoundId;
    private long datatypeId;
    private int dataLength;
    private Map<String, String> name;
    private List<Long> categories;
    private long caltaxtypeId;
    private String splitAlgo;
    private boolean isIncomeItem;
    private Long taxItemType;
    private String status;
    private String enable;

    public boolean isCategory(Long taxCategoryId) {
        return this.categories != null && this.categories.contains(taxCategoryId);
    }

    public static TaxItemEntity newInstance(DynamicObject taxItemDy) {
        TaxItemEntity result = new TaxItemEntity();
        result.setId(taxItemDy.getLong("id"));
        result.setNumber(taxItemDy.getString("number"));
        result.setName((Map<String, String>)taxItemDy.getLocaleString("name"));
        result.setStatus(taxItemDy.getString("status"));
        result.setEnable(taxItemDy.getString("enable"));
        long dataTypeId = taxItemDy.getLong("datatype.id");
        if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            result.setDataPrecisionScale(taxItemDy.getInt("currency.amtprecision"));
        } else {
            result.setDataPrecisionScale(taxItemDy.getInt("dataprecision.scale"));
        }
        result.setDataRoundId(taxItemDy.getLong("dataround.id"));
        result.setDatatypeId(dataTypeId);
        int dataLength = taxItemDy.getInt("datalength");
        if (dataLength == 0) {
            SitDataTypeEnum enumById = SitDataTypeEnum.getEnumById(dataTypeId);
            dataLength = enumById.getDefLen();
        }
        result.setDataLength(dataLength);
        result.setCaltaxtypeId(taxItemDy.getLong("caltaxtype.id"));
        result.setSplitAlgo(taxItemDy.getString("splitalgo.implclasskey"));
        result.setIncomeItem(taxItemDy.getBoolean("incomeitem"));
        result.setTaxItemType(taxItemDy.getLong("taxitemtype.id"));
        DynamicObjectCollection catObjs = taxItemDy.getDynamicObjectCollection("taxcategories");
        ArrayList<Long> cats = new ArrayList<Long>(catObjs.size());
        for (DynamicObject catObj : catObjs) {
            long catId = catObj.getLong("fbasedataid_id");
            cats.add(catId);
        }
        result.setCategories(cats);
        return result;
    }

    public String formatString() {
        if (!SitDataTypeEnum.isDecimal(this.datatypeId)) {
            return null;
        }
        StringBuilder query = new StringBuilder("0");
        if (this.dataPrecisionScale > 0) {
            query.append('.');
            for (int i = 0; i < this.dataPrecisionScale; ++i) {
                query.append('0');
            }
        }
        return query.toString();
    }

    public LocaleString getNameLocaleString() {
        if (this.name == null) {
            return null;
        }
        return LocaleString.fromMap(this.name);
    }

    public String getDefaultValue() {
        return "0";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public List<Long> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Long> categories) {
        this.categories = categories;
    }

    public long getDatatypeId() {
        return this.datatypeId;
    }

    public void setDatatypeId(long datatypeId) {
        this.datatypeId = datatypeId;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getDataPrecisionScale() {
        return this.dataPrecisionScale;
    }

    public void setDataPrecisionScale(int dataPrecisionScale) {
        this.dataPrecisionScale = dataPrecisionScale;
    }

    public long getDataRoundId() {
        return this.dataRoundId;
    }

    public void setDataRoundId(long dataRoundId) {
        this.dataRoundId = dataRoundId;
    }

    public long getCaltaxtypeId() {
        return this.caltaxtypeId;
    }

    public void setCaltaxtypeId(long caltaxtypeId) {
        this.caltaxtypeId = caltaxtypeId;
    }

    public String getSplitAlgo() {
        return this.splitAlgo;
    }

    public void setSplitAlgo(String splitAlgo) {
        this.splitAlgo = splitAlgo;
    }

    public boolean isIncomeItem() {
        return this.isIncomeItem;
    }

    public void setIncomeItem(boolean incomeItem) {
        this.isIncomeItem = incomeItem;
    }

    public long getTaxItemType() {
        return this.taxItemType;
    }

    public void setTaxItemType(Long taxItemType) {
        this.taxItemType = taxItemType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }
}

