/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.entity;

import java.io.Serializable;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxPeriodEntity
implements Serializable {
    public static final String ENTITY_NUMBER = "sitbs_taxperiod";
    private static final long serialVersionUID = 3961669433542175208L;
    private long id;
    private Date startDate;
    private Date endDate;
    private Date periodDate;
    private String number;
    private DynamicObject dynamicObject;

    public TaxPeriodEntity() {
    }

    public TaxPeriodEntity(DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
        if (dynamicObject == null) {
            return;
        }
        this.id = dynamicObject.getLong("id");
        this.periodDate = dynamicObject.getDate("perioddate");
        this.startDate = dynamicObject.getDate("startdate");
        this.endDate = dynamicObject.getDate("enddate");
        this.number = dynamicObject.getString("number");
    }

    public int yearMonth() {
        return SitDateUtil.toYearMonth(this.periodDate);
    }

    public DynamicObject dynamicObject() {
        return this.dynamicObject;
    }

    public void dynamicObject(DynamicObject dynamicObject) {
        this.dynamicObject = dynamicObject;
    }

    public boolean isCover(Date date) {
        return SitDateUtil.isCover(date, this.startDate, this.endDate);
    }

    public boolean isEquals(Date taxStartDate, Date taxEndDate) {
        return this.startDate.equals(taxStartDate) && this.endDate.equals(taxEndDate);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getPeriodDate() {
        return this.periodDate;
    }

    public void setPeriodDate(Date periodDate) {
        this.periodDate = periodDate;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}

