/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxGroupEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.entity.TaxUnitEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.exchangerate.ExchangeRateInfo;

public class TaxTaskEntity
implements Serializable {
    private static final long serialVersionUID = -8193945266761691057L;
    public static final String ENTITY_NAME = "itc_taxtask";
    private Long id;
    private Long countryId;
    private Long createOrgId;
    private boolean endStatus;
    private String taskStatus;
    private String number;
    private Map<String, String> name;
    private String dataStatus;
    private String taxTaskType;
    private boolean enable;
    private TaxPeriodEntity taxPeriodEntity;
    private Date declareEndDate;
    private List<TaxCategoryEntity> taxCategoryEntityList;
    private List<TaxGroupEntity> taxGroupList;
    private Map<Long, TaxUnitEntity> taxUnitMap;
    private Map<Long, Map<Long, String>> taxItemSplitEntityMapMap;
    private Map<Long, String> netTaxAlgoMap;
    private Map<Long, TaxItemEntity> taxItemMap;
    private Set<Long> accSet;
    private List<Long> rawCalTaskIds;
    private Map<Long, Long> calRuleIdMap;
    private Map<Long, Long> calRuleBoIdMap;
    private Map<Long, Map<Long, Long>> taxCategoryCalFormulaIdMap;
    private Long exrateTableId;
    @JsonIgnore
    private Map<Long, ExchangeRateInfo> exchangeRateInfoMap;
    private Set<Long> fCurrencyId;
    private Date exrateDate;
    private String fromAppId;
    private boolean needDeclare;
    private transient Map<String, DynamicObject> runtimeObjMap;

    public static String cacheKey(Long taskId) {
        return "itc_taxtask_" + taskId;
    }

    public Long getCalRuleId(Long categoryId) {
        return this.calRuleIdMap.get(categoryId);
    }

    public Long getCalRuleBoId(Long categoryId) {
        return this.calRuleBoIdMap.get(categoryId);
    }

    public TaxTaskEntity initRunTimeObj(int size) {
        this.runtimeObjMap = new HashMap<String, DynamicObject>(size);
        return this;
    }

    public Map<Long, String> getTaxItemSplitEntityMap(Long categoryId) {
        if (this.taxItemSplitEntityMapMap == null) {
            this.taxItemSplitEntityMapMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        return this.taxItemSplitEntityMapMap.computeIfAbsent(categoryId, ky -> Maps.newHashMapWithExpectedSize((int)16));
    }

    public void taxTask(DynamicObject taxTask) {
        this.runtimeObjMap.put("taxTask", taxTask);
        DynamicObjectCollection catColl = taxTask.getDynamicObjectCollection("taxtaskcatgentry");
        for (DynamicObject cat : catColl) {
            this.runtimeObjMap.put("CT" + cat.get("taxcategory.id"), cat);
        }
        DynamicObjectCollection unitColl = taxTask.getDynamicObjectCollection("taxtaskunitentry");
        for (DynamicObject unit : unitColl) {
            this.runtimeObjMap.put("UT" + unit.get("taxunit.id"), unit);
        }
    }

    public DynamicObject taxTask() {
        if (this.runtimeObjMap == null) {
            return null;
        }
        return this.runtimeObjMap.get("taxTask");
    }

    public DynamicObject taxPeriod() {
        DynamicObject task = this.runtimeObjMap.get("taxTask");
        if (task == null) {
            return null;
        }
        return task.getDynamicObject("taxperiod");
    }

    public DynamicObject taxCatObj(Long catId) {
        return this.runtimeObjMap.get("CT" + catId);
    }

    public DynamicObject taxUnitObj(Long unitId) {
        return this.runtimeObjMap.get("UT" + unitId);
    }

    public String cacheKey() {
        return "itc_taxtask_" + this.id;
    }

    public boolean isEnd() {
        return this.endStatus;
    }

    public boolean isAvailable() {
        return this.enable && !"D".equals(this.dataStatus) && !"E".equals(this.dataStatus);
    }

    public boolean isMock() {
        return this.getId() == 0L;
    }

    public boolean isDeclared() {
        return TaxTaskStatusEnum.DATA_DECLARED.match(this.taskStatus);
    }

    public boolean isPrepared() {
        return TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.getTaxTaskType()) || TaxTaskStatusEnum.SAD_PREPARED.match(this.taskStatus);
    }

    public boolean isLocalCal() {
        return TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.getTaxTaskType());
    }

    public boolean isSupportCurrency(Long currency) {
        if (currency == null || currency == 0L) {
            return true;
        }
        return this.fCurrencyId.contains(currency);
    }

    public String getBizStatusName() {
        return null;
    }

    public int yearMonth() {
        if (this.taxPeriodEntity == null) {
            return 0;
        }
        return this.taxPeriodEntity.yearMonth();
    }

    public Long[] taxUnitIds() {
        if (this.taxUnitMap == null) {
            return new Long[0];
        }
        return new ArrayList<Long>(this.taxUnitMap.keySet()).toArray(new Long[0]);
    }

    public TaxCategoryEntity getTaxCategory(String key) {
        if (CollectionUtils.isEmpty(this.taxCategoryEntityList)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return this.taxCategoryEntityList.get(0);
        }
        for (TaxCategoryEntity item : this.taxCategoryEntityList) {
            if (!key.equalsIgnoreCase(item.getNumber())) continue;
            return item;
        }
        return null;
    }

    public List<TaxItemEntity> getTaxItemOfGroup(Long groupId) {
        ArrayList<TaxItemEntity> result = new ArrayList<TaxItemEntity>(0);
        HashSet<Long> cats = new HashSet<Long>(this.taxCategoryEntityList.size());
        for (TaxCategoryEntity entity : this.taxCategoryEntityList) {
            if (!groupId.equals(entity.getGroupId())) continue;
            cats.add(entity.getId());
        }
        Map<Long, TaxItemEntity> taxItemMap = this.getTaxItemMap();
        block1: for (Map.Entry<Long, TaxItemEntity> entry : taxItemMap.entrySet()) {
            TaxItemEntity value = entry.getValue();
            for (Long cat : cats) {
                if (!value.isCategory(cat)) continue;
                result.add(value);
                continue block1;
            }
        }
        return result;
    }

    public List<TaxItemEntity> getTaxItemOfCat(Long catId) {
        ArrayList<TaxItemEntity> result = new ArrayList<TaxItemEntity>(0);
        Map<Long, TaxItemEntity> taxItemMap = this.getTaxItemMap();
        for (Map.Entry<Long, TaxItemEntity> entry : taxItemMap.entrySet()) {
            TaxItemEntity value = entry.getValue();
            if (!value.isCategory(catId)) continue;
            result.add(value);
        }
        return result;
    }

    public TaxCategoryEntity getTaxCategory(Long categoryId) {
        if (CollectionUtils.isEmpty(this.taxCategoryEntityList)) {
            return null;
        }
        if (categoryId == null || categoryId.equals(0L)) {
            return this.taxCategoryEntityList.get(0);
        }
        for (TaxCategoryEntity item : this.taxCategoryEntityList) {
            if (!categoryId.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public boolean categoriesDiv(Set<Long> newCategories) {
        if (CollectionUtils.isEmpty(this.calRuleBoIdMap)) {
            return !CollectionUtils.isEmpty(newCategories);
        }
        newCategories.removeAll(this.calRuleBoIdMap.keySet());
        return !newCategories.isEmpty();
    }

    public TaxGroupEntity getTaxGroup(String key) {
        if (CollectionUtils.isEmpty(this.taxGroupList)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            return this.taxGroupList.get(0);
        }
        for (TaxGroupEntity item : this.taxGroupList) {
            if (!key.equalsIgnoreCase(item.getNumber())) continue;
            return item;
        }
        return null;
    }

    public TaxGroupEntity getTaxGroup(Long id) {
        if (CollectionUtils.isEmpty(this.taxGroupList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)id)) {
            return this.taxGroupList.get(0);
        }
        for (TaxGroupEntity item : this.taxGroupList) {
            if (!id.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public TaxTaskEntity initBy(DynamicObject taxTask) {
        DynamicObject taxPeriod;
        DynamicObjectCollection taxTaskCatEnt;
        if (taxTask == null) {
            this.setId(0L);
            return this;
        }
        this.setId(taxTask.getLong("id"));
        this.setEndStatus(taxTask.getBoolean("endstatus"));
        this.setTaxTaskType(taxTask.getString("taxtasktype"));
        this.setNumber(taxTask.getString("number"));
        this.setName((Map<String, String>)taxTask.getLocaleString("name"));
        this.setCreateOrgId(taxTask.getLong("createorg.id"));
        this.setEnable(taxTask.getBoolean("enable"));
        this.setDataStatus(taxTask.getString("status"));
        this.setTaskStatus(taxTask.getString("taskstatus"));
        this.setDeclareEndDate(taxTask.getDate("declareenddate"));
        this.setNeedDeclare(taxTask.getBoolean("isneeddeclare"));
        DynamicObjectCollection taxTaskUnitEnt = taxTask.getDynamicObjectCollection("taxtaskunitentry");
        if (!CollectionUtils.isEmpty((Collection)taxTaskUnitEnt)) {
            this.taxUnitMap = new HashMap<Long, TaxUnitEntity>(taxTaskUnitEnt.size());
            for (DynamicObject obj : taxTaskUnitEnt) {
                TaxUnitEntity taxUnit = TaxUnitEntity.newInstance(obj);
                this.taxUnitMap.put(taxUnit.getId(), taxUnit);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(taxTaskCatEnt = taxTask.getDynamicObjectCollection("taxtaskcatgentry")))) {
            this.taxCategoryEntityList = new ArrayList<TaxCategoryEntity>(taxTaskCatEnt.size());
            this.taxGroupList = new ArrayList<TaxGroupEntity>(3);
            HashSet<String> groupKeys = new HashSet<String>(4);
            this.taxItemSplitEntityMapMap = new HashMap<Long, Map<Long, String>>(taxTaskCatEnt.size());
            this.calRuleIdMap = new HashMap<Long, Long>(taxTaskCatEnt.size());
            this.calRuleBoIdMap = new HashMap<Long, Long>(taxTaskCatEnt.size());
            for (DynamicObject obj : taxTaskCatEnt) {
                TaxCategoryEntity categoryEntity = new TaxCategoryEntity();
                this.taxCategoryEntityList.add(categoryEntity);
                long catId = obj.getLong("taxcategory.id");
                categoryEntity.setId(catId);
                categoryEntity.setNumber(obj.getString("taxcategory.number"));
                categoryEntity.setName((Map<String, String>)obj.getLocaleString("taxcategory.name"));
                categoryEntity.setTaxpayerTypeId(obj.getLong("taxcategory.taxpayertype.id"));
                String groupNumber = obj.getString("taxcategory.group.number");
                categoryEntity.setGroupNumber(groupNumber);
                categoryEntity.setGroupId(obj.getLong("taxcategory.group.id"));
                if (groupKeys.add(groupNumber)) {
                    TaxGroupEntity taxGroup = new TaxGroupEntity();
                    this.taxGroupList.add(taxGroup);
                    taxGroup.setNumber(groupNumber);
                    long groupId = obj.getLong("taxcategory.group.id");
                    taxGroup.setId(groupId);
                    taxGroup.setName((Map<String, String>)obj.getLocaleString("taxcategory.group.name"));
                    taxGroup.setTaxpayerTypeId(obj.getLong("taxcategory.taxpayertype.id"));
                }
                long calRuleId = obj.getLong("calrule.id");
                long calRuleBoId = obj.getLong("calrulebo.id");
                this.calRuleIdMap.put(catId, calRuleId);
                this.calRuleBoIdMap.put(catId, calRuleBoId);
                DynamicObjectCollection itemDetail = obj.getDynamicObjectCollection("taxtaskitemdetail");
                if (CollectionUtils.isEmpty((Collection)itemDetail)) continue;
                HashMap<Long, String> taxItemSplitEntityMap = new HashMap<Long, String>(itemDetail.size());
                this.taxItemSplitEntityMapMap.put(catId, taxItemSplitEntityMap);
                for (DynamicObject item : itemDetail) {
                    long itemId = item.getLong("taxitem.id");
                    taxItemSplitEntityMap.put(itemId, item.getString("splitalgo.implclasskey"));
                }
            }
        }
        if ((taxPeriod = taxTask.getDynamicObject("taxperiod")) != null) {
            TaxPeriodEntity taxPeriodEntityProp = new TaxPeriodEntity(taxPeriod);
            this.setTaxPeriodEntity(taxPeriodEntityProp);
        }
        this.setExrateDate(taxTask.getDate("exratedate"));
        this.setExrateTableId(taxTask.getLong("exratetable.id"));
        DynamicObjectCollection foreignCurrency = taxTask.getDynamicObjectCollection("foreigncurrency");
        HashSet<Long> fCurrencyIds = new HashSet<Long>(foreignCurrency.size());
        for (DynamicObject dy : foreignCurrency) {
            long id = dy.getLong("fbasedataid_id");
            fCurrencyIds.add(id);
        }
        this.setfCurrencyId(fCurrencyIds);
        this.initRunTimeObj(2).taxTask(taxTask);
        return this;
    }

    public TaxTaskEntity lightWeightInitBy(DynamicObject taxTask) {
        DynamicObject taxPeriod;
        if (taxTask == null) {
            this.setId(0L);
            return this;
        }
        this.setId(taxTask.getLong("id"));
        this.setNumber(taxTask.getString("number"));
        this.setName((Map<String, String>)taxTask.getLocaleString("name"));
        this.setTaskStatus(taxTask.getString("taskstatus"));
        this.setEndStatus(taxTask.getBoolean("endstatus"));
        DynamicObjectCollection taxTaskUnitEnt = taxTask.getDynamicObjectCollection("taxtaskunitentry");
        if (!CollectionUtils.isEmpty((Collection)taxTaskUnitEnt)) {
            this.taxUnitMap = new HashMap<Long, TaxUnitEntity>(taxTaskUnitEnt.size());
            for (DynamicObject obj : taxTaskUnitEnt) {
                TaxUnitEntity taxUnit = TaxUnitEntity.newInstance(obj);
                this.taxUnitMap.put(taxUnit.getId(), taxUnit);
            }
        }
        if ((taxPeriod = taxTask.getDynamicObject("taxperiod")) != null) {
            TaxPeriodEntity taxPeriodEntityProp = new TaxPeriodEntity(taxPeriod);
            this.setTaxPeriodEntity(taxPeriodEntityProp);
        }
        this.initRunTimeObj(2).taxTask(taxTask);
        return this;
    }

    public boolean categoryInGroup(String category, String group) {
        TaxCategoryEntity taxCategory = this.getTaxCategory(category);
        return ObjectUtils.nullSafeEquals((Object)taxCategory.getGroupNumber(), (Object)group);
    }

    public TaxItemEntity getTaxItem(Long itemId) {
        if (this.taxItemMap == null) {
            return null;
        }
        return this.taxItemMap.get(itemId);
    }

    public Date getStartDate() {
        if (this.taxPeriodEntity == null) {
            return null;
        }
        return this.taxPeriodEntity.getStartDate();
    }

    public Date getEndDate() {
        if (this.taxPeriodEntity == null) {
            return null;
        }
        return this.taxPeriodEntity.getEndDate();
    }

    public Map<Long, Map<Long, Long>> computeCalFormulaIdMapIfAbsent(int size) {
        if (this.taxCategoryCalFormulaIdMap == null) {
            this.taxCategoryCalFormulaIdMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.taxCategoryCalFormulaIdMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public LocaleString getNameLocalString() {
        if (this.name == null) {
            return new LocaleString(this.number);
        }
        return LocaleString.fromMap(this.name);
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public Long getCountryId() {
        return this.countryId;
    }

    public void setCountryId(Long countryId) {
        this.countryId = countryId;
    }

    public TaxPeriodEntity getTaxPeriodEntity() {
        return this.taxPeriodEntity;
    }

    public void setTaxPeriodEntity(TaxPeriodEntity taxPeriodEntity) {
        this.taxPeriodEntity = taxPeriodEntity;
    }

    public List<TaxCategoryEntity> getTaxCategoryEntityList() {
        return this.taxCategoryEntityList;
    }

    public void setTaxCategoryEntityList(List<TaxCategoryEntity> taxCategoryEntityList) {
        this.taxCategoryEntityList = taxCategoryEntityList;
    }

    public Map<Long, Map<Long, String>> getTaxItemSplitEntityMapMap() {
        return this.taxItemSplitEntityMapMap;
    }

    public void setTaxItemSplitEntityMapMap(Map<Long, Map<Long, String>> taxItemSplitEntityMapMap) {
        this.taxItemSplitEntityMapMap = taxItemSplitEntityMapMap;
    }

    public List<TaxGroupEntity> getTaxGroupList() {
        return this.taxGroupList;
    }

    public void setTaxGroupList(List<TaxGroupEntity> taxGroupList) {
        this.taxGroupList = taxGroupList;
    }

    public Map<Long, TaxUnitEntity> getTaxUnitMap() {
        return this.taxUnitMap;
    }

    public void setTaxUnitMap(Map<Long, TaxUnitEntity> taxUnitMap) {
        this.taxUnitMap = taxUnitMap;
    }

    public boolean isEndStatus() {
        return this.endStatus;
    }

    public void setEndStatus(boolean endStatus) {
        this.endStatus = endStatus;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getDataStatus() {
        return this.dataStatus;
    }

    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }

    public String getTaxTaskType() {
        return this.taxTaskType;
    }

    public void setTaxTaskType(String taxTaskType) {
        this.taxTaskType = taxTaskType;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Date getDeclareEndDate() {
        return this.declareEndDate;
    }

    public void setDeclareEndDate(Date declareEndDate) {
        this.declareEndDate = declareEndDate;
    }

    public Map<Long, String> getNetTaxAlgoMap() {
        return this.netTaxAlgoMap;
    }

    public void setNetTaxAlgoMap(Map<Long, String> netTaxAlgoMap) {
        this.netTaxAlgoMap = netTaxAlgoMap;
    }

    public Map<Long, TaxItemEntity> getTaxItemMap() {
        return this.taxItemMap == null ? Maps.newLinkedHashMap() : this.taxItemMap;
    }

    public Map<Long, Long> getCalRuleIdMap() {
        return this.calRuleIdMap;
    }

    public void setCalRuleIdMap(Map<Long, Long> calRuleIdMap) {
        this.calRuleIdMap = calRuleIdMap;
    }

    public void setTaxItemMap(Map<Long, TaxItemEntity> taxItemMap) {
        this.taxItemMap = taxItemMap;
        if (CollectionUtils.isEmpty(taxItemMap)) {
            return;
        }
        for (Map.Entry<Long, TaxItemEntity> entry : taxItemMap.entrySet()) {
            List<Long> categories;
            Long catId;
            TaxCategoryEntity taxCategory;
            TaxItemEntity value = entry.getValue();
            if (!value.isIncomeItem() || (taxCategory = this.getTaxCategory(catId = (categories = value.getCategories()).get(0))) == null) continue;
            taxCategory.setIncomeItem(value.getName());
        }
    }

    public void addTaxItemMap(Map<Long, TaxItemEntity> taxItemMap) {
        if (CollectionUtils.isEmpty(taxItemMap)) {
            return;
        }
        if (this.taxItemMap == null) {
            this.taxItemMap = taxItemMap;
        } else {
            this.taxItemMap.putAll(taxItemMap);
        }
    }

    public List<Long> getRawCalTaskIds() {
        return this.rawCalTaskIds;
    }

    public void setRawCalTaskIds(List<Long> rawCalTaskIds) {
        this.rawCalTaskIds = rawCalTaskIds;
    }

    public TaxItemEntity[] getTaxItems(DataFilter<TaxItemEntity> filter) {
        if (CollectionUtils.isEmpty(this.taxItemMap)) {
            return new TaxItemEntity[0];
        }
        ArrayList<TaxItemEntity> result = new ArrayList<TaxItemEntity>(this.taxItemMap.size());
        for (Map.Entry<Long, TaxItemEntity> entry : this.taxItemMap.entrySet()) {
            if (!filter.accept(entry.getValue())) continue;
            result.add(entry.getValue());
        }
        return result.toArray(new TaxItemEntity[0]);
    }

    public Set<Long> getAccSet() {
        return this.accSet;
    }

    public void setAccSet(Set<Long> accSet) {
        this.accSet = accSet;
    }

    public Long getExrateTableId() {
        return this.exrateTableId;
    }

    public void setExrateTableId(Long exrateTableId) {
        this.exrateTableId = exrateTableId;
    }

    @JsonIgnore
    public Map<Long, ExchangeRateInfo> getExchangeRateInfoMap() {
        return this.exchangeRateInfoMap;
    }

    @JsonIgnore
    public void setExchangeRateInfoMap(Map<Long, ExchangeRateInfo> exchangeRateInfoMap) {
        this.exchangeRateInfoMap = exchangeRateInfoMap;
    }

    public Set<Long> getfCurrencyId() {
        return this.fCurrencyId;
    }

    public void setfCurrencyId(Set<Long> fCurrencyId) {
        this.fCurrencyId = fCurrencyId;
    }

    public Date getExrateDate() {
        return this.exrateDate;
    }

    public void setExrateDate(Date exrateDate) {
        this.exrateDate = exrateDate;
    }

    public String getFromAppId() {
        return this.fromAppId;
    }

    public void setFromAppId(String fromAppId) {
        this.fromAppId = fromAppId;
    }

    public boolean isNeedDeclare() {
        return this.needDeclare;
    }

    public void setNeedDeclare(boolean needDeclare) {
        this.needDeclare = needDeclare;
    }

    public Map<Long, Map<Long, Long>> getTaxCategoryCalFormulaIdMap() {
        return this.taxCategoryCalFormulaIdMap;
    }

    public void setTaxCategoryCalFormulaIdMap(Map<Long, Map<Long, Long>> taxCategoryCalFormulaIdMap) {
        this.taxCategoryCalFormulaIdMap = taxCategoryCalFormulaIdMap;
    }

    public Long getCreateOrgId() {
        return this.createOrgId;
    }

    public void setCreateOrgId(Long createOrgId) {
        this.createOrgId = createOrgId;
    }

    public Map<Long, Long> getCalRuleBoIdMap() {
        return this.calRuleBoIdMap;
    }

    public void setCalRuleBoIdMap(Map<Long, Long> calRuleBoIdMap) {
        this.calRuleBoIdMap = calRuleBoIdMap;
    }
}

