/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.entity;

import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;

public class TaxUnitEntity
implements Serializable {
    private static final long serialVersionUID = 8427619647901178857L;
    private Long id;
    private String number;
    private Map<String, String> name;
    private String declareStatus;
    private int taxFileNum;

    public static TaxUnitEntity newInstance(DynamicObject obj) {
        TaxUnitEntity result = new TaxUnitEntity();
        if ("hbss_taxunit".equals(obj.getDataEntityType().getName())) {
            result.setId(obj.getLong("id"));
            result.setNumber(obj.getString("number"));
            result.setName((Map<String, String>)obj.getLocaleString("name"));
        } else {
            result.setId(obj.getLong("taxunit.id"));
            result.setNumber(obj.getString("taxunit.number"));
            result.setName((Map<String, String>)obj.getLocaleString("taxunit.name"));
            if (obj.getDataEntityType().getProperties().containsKey((Object)"declarestatus")) {
                result.setDeclareStatus(obj.getString("declarestatus"));
                result.setTaxFileNum(obj.getInt("taxfilenum"));
            }
        }
        return result;
    }

    public String localName() {
        if (this.name == null) {
            return null;
        }
        return LocaleString.fromMap(this.name).toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public String getDeclareStatus() {
        return this.declareStatus;
    }

    public void setDeclareStatus(String declareStatus) {
        this.declareStatus = declareStatus;
    }

    public int getTaxFileNum() {
        return this.taxFileNum;
    }

    public void setTaxFileNum(int taxFileNum) {
        this.taxFileNum = taxFileNum;
    }
}

