/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.enums;

import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public enum CalDataTypeEnum {
    NUMBER(1010L, DataTypeEnum.NUM),
    AMOUNT(1020L, DataTypeEnum.MONEY),
    TEXT(1030L, DataTypeEnum.TEXT),
    INTEGER(1040L, DataTypeEnum.INT),
    DATE(1050L, DataTypeEnum.DATE),
    BOOLEAN(1060L, DataTypeEnum.BOOLEAN);

    private final long id;
    private final DataTypeEnum dataType;

    private CalDataTypeEnum(long id, DataTypeEnum dataType) {
        this.id = id;
        this.dataType = dataType;
    }

    public static DataTypeEnum getEnumById(long id) {
        for (CalDataTypeEnum value : CalDataTypeEnum.values()) {
            if (id != value.id) continue;
            return value.getDataType();
        }
        return DataTypeEnum.TEXT;
    }

    public Object convert(Object obj) {
        return BaseDataConverter.convert(obj, this.dataType.name());
    }

    public long getId() {
        return this.id;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }
}

