/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.enums;

import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public enum SitDataTypeEnum {
    NUMBER(1010L, DataTypeEnum.BIG_DECIMAL, "latestMerge", 24),
    AMOUNT(1020L, DataTypeEnum.BIG_DECIMAL, "sumMerge", 24),
    TEXT(1030L, DataTypeEnum.STRING, "latestMerge", 255),
    INTEGER(1040L, DataTypeEnum.INTEGER, "latestMerge", 13),
    DATE(1050L, DataTypeEnum.DATE, "latestMerge", 30),
    BOOLEAN(1060L, DataTypeEnum.BOOLEAN, "latestMerge", 6);

    private final String defMergeAlgo;
    private final long id;
    private final int defLen;
    private final DataTypeEnum dataType;

    private SitDataTypeEnum(long id, DataTypeEnum dataType, String defMergeAlgo, int defLen) {
        this.id = id;
        this.dataType = dataType;
        this.defMergeAlgo = defMergeAlgo;
        this.defLen = defLen;
    }

    public static SitDataTypeEnum getEnumById(long id) {
        for (SitDataTypeEnum value : SitDataTypeEnum.values()) {
            if (id != value.id) continue;
            return value;
        }
        return TEXT;
    }

    public static boolean isDecimal(long dataTypeId) {
        return SitDataTypeEnum.NUMBER.id == dataTypeId || SitDataTypeEnum.AMOUNT.id == dataTypeId || SitDataTypeEnum.INTEGER.id == dataTypeId;
    }

    public Object convert(Object obj) {
        return BaseDataConverter.convert(obj, this.dataType.name());
    }

    public String getDefMergeAlgo() {
        return this.defMergeAlgo;
    }

    public long getId() {
        return this.id;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public int getDefLen() {
        return this.defLen;
    }
}

