/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.enums;

import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.model.SITI18NParam;

public enum TaxTaskStatusEnum {
    DEFAULT("0", new SITI18NParam("\u521d\u59cb\u5316\u6863\u6848\u5feb\u7167\u6e05\u5355", "TaxTaskStatusEnum_0", "sit-sitbp-common")),
    INITING("05", new SITI18NParam("\u6b63\u5728\u521d\u59cb\u5316\u6863\u6848\u5feb\u7167\u6e05\u5355", "TaxTaskStatusEnum_05", "sit-sitbp-common")),
    INIT_FINISH("10", new SITI18NParam("\u6863\u6848\u5feb\u7167\u6e05\u5355\u521d\u59cb\u5316\u5b8c\u6210", "TaxTaskStatusEnum_10", "sit-sitbp-common")),
    SAD_PREPARED("20", new SITI18NParam("\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u51c6\u5907\u5b8c\u6210", "TaxTaskStatusEnum_20", "sit-sitbp-common")),
    DATA_DECLARED("30", new SITI18NParam("\u6570\u636e\u662f\u5426\u5df2\u7ecf\u62a5\u9001", "TaxTaskStatusEnum_30", "sit-sitbp-common"));

    private final String code;
    private final SITI18NParam i18nParam;

    private TaxTaskStatusEnum(String code, SITI18NParam i18nParam) {
        this.code = code;
        this.i18nParam = i18nParam;
    }

    public boolean match(String taskStatus) {
        return StringUtils.isNotEmpty((CharSequence)taskStatus) && taskStatus.compareTo(this.code) >= 0;
    }

    public String getCode() {
        return this.code;
    }

    public SITI18NParam getI18nParam() {
        return this.i18nParam;
    }

    public String getI18nParamString() {
        return this.i18nParam.loadKDString();
    }

    public boolean isLessThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) < 0;
    }

    public boolean isLessEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) <= 0;
    }

    public boolean isGreaterThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) > 0;
    }

    public boolean isGreaterEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) >= 0;
    }
}

