/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.enums;

import java.math.BigDecimal;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.sit.hcsi.business.extpoint.ITruncationDealExtService;
import kd.sdk.sit.hcsi.business.extpoint.TruncationDealExtService;
import kd.sdk.sit.hcsi.common.events.cal.ItemDataEvent;

public enum TruncationEnum {
    ROUND_UP_TO_MINUTES("0", 2, 4),
    ROUND_UP_TO_CORNERS("1", 1, 4),
    ROUND_UP_TO_YUAN("2", 0, 4),
    SEE_POINTS_INTO_CORNER("3", 1, 0),
    SEE_CORNER_INTO_YUAN("4", 0, 0),
    SEE_CORNER_INTO_YUAN_POINTS_TRUNCATION("5", 0, 0),
    TRUNCATION_TO_POINTS("6", 2, 1),
    TRUNCATION_TO_CORNER("7", 1, 1),
    TRUNCATION_TO_YUAN("8", 0, 1),
    ROUND_UP_TO_TEN("9", 0, 4),
    ROUND_CEILING_TO_FEN("10", 2, 2);

    private String code;
    private int scale;
    private int roundMethod;

    private TruncationEnum(String code, int scale, int roundMethod) {
        this.code = code;
        this.scale = scale;
        this.roundMethod = roundMethod;
    }

    public String getCode() {
        return this.code;
    }

    public int getScale() {
        return this.scale;
    }

    public int getRoundMethod() {
        return this.roundMethod;
    }

    public static TruncationEnum getByCode(String code) {
        for (TruncationEnum truncationEnum : TruncationEnum.values()) {
            if (!truncationEnum.getCode().equals(code)) continue;
            return truncationEnum;
        }
        return ROUND_UP_TO_MINUTES;
    }

    public static BigDecimal getBigDecimalValue(BigDecimal value, String truncationCode) {
        if (value == null) {
            return null;
        }
        TruncationEnum truncation = null;
        for (TruncationEnum truncationEnum : TruncationEnum.values()) {
            if (!truncationEnum.getCode().equals(truncationCode)) continue;
            truncation = truncationEnum;
        }
        if (truncation == null) {
            return TruncationEnum.invokeDataTruncationDeal(value, truncationCode);
        }
        if (ROUND_UP_TO_TEN == truncation) {
            value = value.setScale(truncation.getScale(), 1);
            return value.divide(new BigDecimal("10")).setScale(truncation.getScale(), truncation.getRoundMethod()).multiply(new BigDecimal("10"));
        }
        switch (truncation) {
            case SEE_CORNER_INTO_YUAN_POINTS_TRUNCATION: {
                value = value.setScale(1, 1);
                break;
            }
            case SEE_POINTS_INTO_CORNER: 
            case SEE_CORNER_INTO_YUAN: {
                value = value.setScale(2, 1);
                break;
            }
        }
        return value.setScale(truncation.getScale(), truncation.getRoundMethod());
    }

    private static BigDecimal invokeDataTruncationDeal(BigDecimal value, String truncationCode) {
        ItemDataEvent event = new ItemDataEvent(value, truncationCode);
        TruncationDealExtService truncationDealExtService = new TruncationDealExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)truncationDealExtService, ITruncationDealExtService.class, (String)"kd.sdk.sit.hcsi.business.extpoint.ITruncationDealExtService#dataTruncationDeal", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.dataTruncationDeal(event);
            return null;
        });
        return event.getResultValue();
    }
}

