/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kd.sit.sitbp.common.model.SITI18NParam;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public enum YesOrNoEnum {
    YES("1", new SITI18NParam("\u662f", "YesOrNo_1", "sit-sitbp-common")),
    NO("0", new SITI18NParam("\u5426", "YesOrNo_0", "sit-sitbp-common")),
    OTHER("x", new SITI18NParam("", "YesOrNo_x", "sit-sitbp-common"));

    private static final Map<Object, Boolean> BOOLEAN_MAP;
    private final String code;
    private final SITI18NParam i18nParam;

    private YesOrNoEnum(String code, SITI18NParam i18nParam) {
        this.code = code;
        this.i18nParam = i18nParam;
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        return BOOLEAN_MAP.containsKey(obj);
    }

    public static Boolean toBoolean(Object obj) {
        return BOOLEAN_MAP.get(obj);
    }

    public String getCode() {
        return this.code;
    }

    public SITI18NParam getI18nParam() {
        return this.i18nParam;
    }

    public static String getI18nNameByCode(String code) {
        if (YesOrNoEnum.YES.code.equals(code)) {
            return YesOrNoEnum.YES.i18nParam.loadKDString();
        }
        if (YesOrNoEnum.NO.code.equals(code)) {
            return YesOrNoEnum.NO.i18nParam.loadKDString();
        }
        return YesOrNoEnum.OTHER.i18nParam.loadKDString();
    }

    public static boolean isYes(String code) {
        return BaseDataConverter.convert(code, Boolean.class, Boolean.FALSE);
    }

    static {
        BOOLEAN_MAP = ImmutableMap.builder().put((Object)"false", (Object)Boolean.FALSE).put((Object)"N", (Object)Boolean.FALSE).put((Object)"0", (Object)Boolean.FALSE).put((Object)0, (Object)Boolean.FALSE).put((Object)"true", (Object)Boolean.TRUE).put((Object)"Y", (Object)Boolean.TRUE).put((Object)"1", (Object)Boolean.TRUE).put((Object)1, (Object)Boolean.TRUE).build();
    }
}

