/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.model.DefaultBizMessage;

public class ApiParam<T>
implements Serializable {
    private static final long serialVersionUID = -3391441088253716396L;
    private boolean success = true;
    private int status = 200;
    private List<String> message;
    private String srcType;
    private String operateKey;
    private String srcKey;
    private Long operator;
    private Long country;
    private String appId;
    private String langCode;
    private Map<String, Object> fixParams;
    private Map<String, Object> extraParams;
    @JsonIgnore
    private transient boolean changed;
    @JsonIgnore
    private transient Map<String, Object> tempParams;
    @JsonIgnore
    private transient Map<String, BizMessage> bizFailMsg;
    @JsonIgnore
    private transient Map<String, BizMessage> bizWarnMsg;
    @JsonIgnore
    private transient Map<String, T> bizDataMap;

    public ApiParam() {
        this(16);
    }

    public ApiParam(int size) {
        this.fixParams = new HashMap<String, Object>(size);
        this.extraParams = new HashMap<String, Object>(size);
        this.tempParams = new HashMap<String, Object>(size);
    }

    public Map<String, Object> toMap(boolean withData) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("success", this.success);
        if (!CollectionUtils.isEmpty(this.message)) {
            if (this.message.size() == 1) {
                result.put("message", this.message.get(0));
            } else {
                StringBuilder query = new StringBuilder();
                for (String str : this.message) {
                    query.append(str).append(',');
                }
                query.deleteCharAt(query.length() - 1);
                result.put("message", query.toString());
            }
        }
        result.put("status", this.status);
        if (withData && this.success) {
            result.put("data", this.resultData());
        }
        return result;
    }

    public void logStart(String point) {
    }

    public void logEnd(String point) {
    }

    public void logEnd(String point, String log) {
    }

    public void logError(String error, Throwable ex) {
    }

    public void logInfo(String info) {
    }

    public void requestFail(String message) {
        this.requestFail(message, 400);
    }

    public void requestFail(String message, int status) {
        this.success = false;
        if (this.message == null) {
            this.message = Lists.newArrayListWithCapacity((int)10);
        }
        this.message.add(message);
        this.status = Math.max(status, this.status);
        if (this.bizDataMap != null) {
            this.bizFailByDataKeys(new DefaultBizMessage(status, message), this.bizDataMap.keySet());
        }
    }

    public void addFixParam(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) && value instanceof Map) {
            Map map = (Map)value;
            map.putAll(this.fixParams);
            this.fixParams = map;
        } else {
            this.fixParams.put(key, value);
        }
    }

    public T bizDataOf(String srcDataKey) {
        return this.bizDataMap.get(srcDataKey);
    }

    public void addBizData(String dataKey, T data) {
        this.bizDataMap = this.bizDataMap == null ? Maps.newHashMapWithExpectedSize((int)16) : this.bizDataMap;
        this.bizDataMap.put(dataKey, data);
    }

    public Map<String, T> computeBizDataIfAbsent(int size) {
        this.bizDataMap = this.bizDataMap == null ? Maps.newHashMapWithExpectedSize((int)size) : this.bizDataMap;
        return this.bizDataMap;
    }

    public T computeBizDataIfAbsent(String dataKey, Function<String, T> function) {
        this.bizDataMap = this.bizDataMap == null ? Maps.newHashMapWithExpectedSize((int)16) : this.bizDataMap;
        return this.bizDataMap.computeIfAbsent(dataKey, function);
    }

    public <R> R computeTempParamIfAbsent(String dataKey, Function<String, R> function) {
        this.tempParams = this.tempParams == null ? Maps.newHashMapWithExpectedSize((int)8) : this.tempParams;
        return (R)this.tempParams.computeIfAbsent(dataKey, function);
    }

    public void computeBizMsgIfAbsent(int size) {
        if (this.bizFailMsg == null) {
            this.bizFailMsg = Maps.newHashMapWithExpectedSize((int)size);
        }
        if (this.bizWarnMsg == null) {
            this.bizWarnMsg = Maps.newHashMapWithExpectedSize((int)size);
        }
    }

    public void bizFailByDataKeys(BizMessage message, Collection<String> dataKeys) {
        this.computeBizMsgIfAbsent(dataKeys.size());
        dataKeys.forEach(ele -> this.doBizFailByDataKey(message, (String)ele));
    }

    public void doBizFailByDataKey(BizMessage message, String dataKey) {
        if (message.isError()) {
            if (this.bizWarnMsg != null) {
                this.bizWarnMsg.remove(dataKey);
            }
            if (this.bizFailMsg == null) {
                this.bizFailMsg = Maps.newHashMapWithExpectedSize((int)16);
            }
            this.bizFailMsg.putIfAbsent(dataKey, message);
        } else {
            if (this.bizFailMsg != null && this.bizFailMsg.containsKey(dataKey)) {
                return;
            }
            if (this.bizWarnMsg == null) {
                this.bizWarnMsg = Maps.newHashMapWithExpectedSize((int)16);
            }
            this.bizWarnMsg.putIfAbsent(dataKey, message);
        }
    }

    public boolean isBizFail(String dataKey) {
        return this.bizFailMsg != null && this.bizFailMsg.containsKey(dataKey);
    }

    public boolean isBizWarn(String dataKey) {
        return this.bizWarnMsg != null && this.bizWarnMsg.containsKey(dataKey);
    }

    public BizMessage bizMessage(String dataKey) {
        BizMessage result;
        BizMessage bizMessage = result = this.bizFailMsg == null ? null : this.bizFailMsg.get(dataKey);
        if (result != null) {
            return result;
        }
        return this.bizWarnMsg == null ? null : this.bizWarnMsg.get(dataKey);
    }

    public <R> R getFixParam(String key) {
        return (R)this.fixParams.get(key);
    }

    public <R> R removeFixParam(String paramName) {
        return (R)this.fixParams.remove(paramName);
    }

    public void addExtraParam(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) && value instanceof Map) {
            Map map = (Map)value;
            map.putAll(this.extraParams);
            this.extraParams = map;
        } else {
            this.extraParams.put(key, value);
        }
    }

    public <R> R removeExtraParam(String paramName) {
        return (R)this.extraParams.remove(paramName);
    }

    public <R> R getExtraParam(String key) {
        return (R)this.extraParams.get(key);
    }

    public void addTempParam(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) && value instanceof Map) {
            Map map = (Map)value;
            map.putAll(this.tempParams);
            this.tempParams = map;
        } else {
            this.tempParams.put(key, value);
        }
    }

    public <R> R getTempParam(String key) {
        return (R)this.tempParams.get(key);
    }

    public <R> R removeTempParam(String paramName) {
        return (R)this.tempParams.remove(paramName);
    }

    public void clearBizData() {
        this.changed = false;
        if (this.bizDataMap != null) {
            this.bizDataMap.clear();
        }
        if (this.bizFailMsg != null) {
            this.bizFailMsg.clear();
        }
        if (this.bizWarnMsg != null) {
            this.bizWarnMsg.clear();
        }
    }

    @JsonIgnore
    public Map<String, T> bizData() {
        return this.bizDataMap;
    }

    @JsonIgnore
    public Object resultData() {
        return this.bizData();
    }

    @JsonIgnore
    public void changed() {
        this.changed = true;
    }

    @JsonIgnore
    public boolean isChanged() {
        return this.changed;
    }

    @JsonIgnore
    public Map<String, BizMessage> bizFailMsg() {
        return this.bizFailMsg;
    }

    @JsonIgnore
    public void bizFailMsg(Map<String, BizMessage> bizFailMsg) {
        this.bizFailMsg = bizFailMsg;
    }

    @JsonIgnore
    public Map<String, BizMessage> bizWarnMsg() {
        return this.bizWarnMsg;
    }

    @JsonIgnore
    public void bizWarnMsg(Map<String, BizMessage> bizWarnMsg) {
        this.bizWarnMsg = bizWarnMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<String> getMessage() {
        return this.message;
    }

    public void setMessage(List<String> message) {
        this.message = message;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public void setSrcType(String srcType) {
        this.srcType = srcType;
    }

    public String getOperateKey() {
        return this.operateKey;
    }

    public void setOperateKey(String operateKey) {
        this.operateKey = operateKey;
    }

    public String getSrcKey() {
        return this.srcKey;
    }

    public void setSrcKey(String srcKey) {
        this.srcKey = srcKey;
    }

    public Long getOperator() {
        return this.operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public Long getCountry() {
        return this.country;
    }

    public void setCountry(Long country) {
        this.country = country;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public Map<String, Object> getFixParams() {
        return this.fixParams;
    }

    public void setFixParams(Map<String, Object> fixParams) {
        this.fixParams = fixParams;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }
}

