/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.sit.sitbp.common.api.BizHandler;
import kd.sit.sitbp.common.model.ApiParam;
import kd.sit.sitbp.common.model.BaseParamAdapter;
import kd.sit.sitbp.common.model.ParamConfig;

public abstract class CacheParamAdapter<R, S, T extends ApiParam<R>>
extends BaseParamAdapter<R, S, T> {
    private static final Log LOGGER = LogFactory.getLog(CacheParamAdapter.class);

    @Override
    public T adapt(ParamConfig<T> paramConfig, S rawParam, BizHandler<R, S, T> handler) {
        T context;
        String cacheKey = this.cacheKey(rawParam);
        String lockKey = "DL_" + cacheKey;
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            context = super.adapt(paramConfig, rawParam, handler);
            if (((ApiParam)context).isChanged() && !StringUtils.isEmpty((Object)cacheKey)) {
                String json = SerializationUtils.toJsonString(context);
                LOGGER.debug("By Quinn: {0}", (Object)json);
                this.cache().put(cacheKey, (Object)json);
            }
        }
        return context;
    }

    @Override
    public T getParamContext(S rawParam, BizHandler<R, S, T> handler) {
        String cacheKey = this.cacheKey(rawParam);
        if (StringUtils.isEmpty((Object)cacheKey)) {
            T context = handler.newParam(rawParam);
            ((ApiParam)context).changed();
            return context;
        }
        String cacheStr = (String)this.cache().get(cacheKey, String.class);
        if (!StringUtils.isEmpty((Object)cacheStr)) {
            LOGGER.info("By Quinn: {}", (Object)cacheStr);
            Class<T> clazz = handler.paramClass();
            try {
                ApiParam context = (ApiParam)SerializationUtils.fromJsonString((String)cacheStr, clazz);
                context.clearBizData();
                handler.recoveryFromCache(context, rawParam);
                return (T)context;
            }
            catch (Exception e) {
                LOGGER.error("By Quinn calContext SerializationUtils.fromJsonString", (Throwable)e);
            }
        }
        T context = handler.newParam(rawParam);
        ((ApiParam)context).changed();
        return context;
    }

    protected abstract IAppCache cache();

    protected abstract String cacheKey(S var1);
}

