/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EffectLogger {
    private final Log log;
    private final String sense;
    private final String threadKey;
    private final Map<String, Long> startTimeOfPoint = Maps.newHashMapWithExpectedSize((int)16);

    public EffectLogger(String sense, String threadKey) {
        this.sense = sense;
        this.threadKey = threadKey;
        this.log = LogFactory.getLog(EffectLogger.class);
    }

    public EffectLogger(String sense, String threadKey, Log log) {
        this.sense = sense;
        this.threadKey = threadKey;
        this.log = log == null ? LogFactory.getLog(EffectLogger.class) : log;
    }

    public void log(String message) {
        this.log.info(MessageFormat.format("{0} start at {1} in {2}", message, this.threadKey, this.sense));
    }

    public void error(String message, Throwable ex) {
        this.log.error(MessageFormat.format("{0} start at {1} in {2}", message, this.threadKey, this.sense), ex);
    }

    public void start(String point) {
        long start = System.currentTimeMillis();
        this.startTimeOfPoint.putIfAbsent(point, start);
        this.log.info(MessageFormat.format("{0} start at {1} in {2} @ {3}", point, this.threadKey, this.sense, start));
    }

    public void end(String point) {
        Long start = this.startTimeOfPoint.remove(point);
        long end = System.currentTimeMillis();
        long spend = start != null ? end - start : 0L;
        this.log.info(MessageFormat.format("{0} end at {1} in {2} @ {3}, spend {4}", point, this.threadKey, this.sense, end, spend));
    }

    public void end(String point, String log) {
        this.log(log);
        this.end(point);
    }
}

