/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.enums.ResultStatusEnum;

public class LogInfo {
    private int leave;
    private String message;
    private String position;

    public static LogInfo of(String message, ResultStatusEnum level) {
        LogInfo info = new LogInfo();
        info.setLeave(level.getCode());
        info.setMessage(message);
        return info.ofPosition(Thread.currentThread().getStackTrace(), 1, 3);
    }

    public static LogInfo of(Throwable ex) {
        return LogInfo.of(ex, null);
    }

    public static LogInfo of(Throwable ex, String message) {
        LogInfo info = new LogInfo();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = ex.getMessage();
        }
        info.setLeave(ResultStatusEnum.ERROR.getCode());
        info.setMessage(ex.getClass().getSimpleName() + ":" + message);
        return info.ofPosition(ex.getStackTrace(), 0, 3);
    }

    public LogInfo ofPosition(StackTraceElement[] stackTrace, int start, int end) {
        end = end > stackTrace.length ? stackTrace.length : end;
        StringBuilder query = new StringBuilder();
        for (int i = start; i < end; ++i) {
            query.append(stackTrace[i].getClassName()).append('.').append(stackTrace[i].getMethodName()).append(':').append(stackTrace[i].getLineNumber()).append('\n');
        }
        this.setPosition(query.toString());
        return this;
    }

    public String ofMessage(int length) {
        if (StringUtils.isEmpty((CharSequence)this.message) || this.message.length() < length) {
            return this.message;
        }
        return this.message.substring(0, length);
    }

    public int getLeave() {
        return this.leave;
    }

    public void setLeave(int leave) {
        this.leave = leave;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
}

