/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sit.sitbp.common.api.Converter;
import kd.sit.sitbp.common.model.ApiParam;
import kd.sit.sitbp.common.model.ParamConfig;

public class MapConverter
implements Converter<Map> {
    private static final MapConverter INSTANCE = new MapConverter();

    public static MapConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public Map convert(Object parentValue, Object raw, ParamConfig config) {
        if (parentValue == null && StringUtils.isEmpty((Object)config.getName())) {
            return null;
        }
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    @Override
    public Object getByProp(Map raw, String prop) {
        return raw == null ? null : raw.remove(prop);
    }

    @Override
    public void addData(ApiParam apiParam, Map parentValue, String name, Object raw, boolean isPersist) {
        if (parentValue == null) {
            if (isPersist) {
                apiParam.addFixParam(name, raw);
            } else {
                apiParam.addTempParam(name, raw);
            }
        } else {
            parentValue.put(name, raw);
        }
    }

    @Override
    public void paramFail(ApiParam apiParam, ParamConfig config, Map parentValue, String message) {
        if (parentValue == null) {
            apiParam.requestFail(message);
        } else {
            parentValue.put("success", Boolean.FALSE);
            parentValue.putIfAbsent("message", message);
        }
    }

    @Override
    public boolean isEmpty(Map raw) {
        return CollectionUtils.isEmpty((Map)raw);
    }
}

