/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertiesQueryInfo
implements Serializable {
    private static final long serialVersionUID = -6613101916719046510L;
    private boolean all = true;
    private String entityName;
    private Map<String, List<String>> specialMap = new HashMap<String, List<String>>(8);

    public PropertiesQueryInfo() {
    }

    public PropertiesQueryInfo(String entityName) {
        this.entityName = entityName;
    }

    public static PropertiesQueryInfo special(String entityName, String ... props) {
        PropertiesQueryInfo info = new PropertiesQueryInfo(entityName);
        info.all = false;
        for (String prop : props) {
            info.specialMap.put(prop, null);
        }
        return info;
    }

    public static PropertiesQueryInfo special(String entityName, Collection<String> props) {
        PropertiesQueryInfo info = new PropertiesQueryInfo(entityName);
        info.all = false;
        for (String prop : props) {
            info.specialMap.put(prop, null);
        }
        return info;
    }

    public PropertiesQueryInfo ignoreProp(String ... props) {
        for (String prop : props) {
            this.specialMap.put(prop, Collections.emptyList());
        }
        return this;
    }

    public PropertiesQueryInfo subProp(String prop, String ... subProps) {
        List collect = Stream.of(subProps).filter(Objects::nonNull).collect(Collectors.toList());
        this.specialMap.put(prop, collect);
        return this;
    }

    public PropertiesQueryInfo addSubProp(String prop, String ... subProps) {
        List collect = Stream.of(subProps).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> props = this.specialMap.get(prop);
        if (props == null || Collections.emptyList().equals(props)) {
            this.specialMap.put(prop, collect);
        } else {
            props.addAll(collect);
        }
        return this;
    }

    public List<String> popSubProps(String prop) {
        return this.specialMap.remove(prop);
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Map<String, List<String>> getSpecialMap() {
        return this.specialMap;
    }

    public void setSpecialMap(Map<String, List<String>> specialMap) {
        this.specialMap = specialMap;
    }

    public boolean isSubPropsEmpty() {
        return this.specialMap.isEmpty();
    }
}

