/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.entity.CalRuleEntity;
import kd.sit.sitbp.common.entity.CurrencyEntity;
import kd.sit.sitbp.common.entity.TaxCalFormulaEntity;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.TaxUnitEntity;
import kd.sit.sitbp.common.entity.accumulator.AccumulatorInfo;
import kd.sit.sitbp.common.enums.CalFailTypeEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.model.DefaultBizMessage;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.model.TaxDataBaseContext;
import kd.sit.sitbp.common.model.TaxDataWrapper;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxCalContext
extends TaxDataBaseContext<TaxCalUnit> {
    private static final long serialVersionUID = 8552785024793585045L;
    private String calTaskNumber;
    private String calTaskName;
    private Long rawTaskId;
    private CurrencyEntity currency;
    private CurrencyEntity rawCurrency;
    private boolean mergeRawData;
    private boolean cancelOp;
    private boolean validate;
    private boolean terminated;
    private Map<Long, TaxTaskEntity> taskEntityMap;
    private Map<Long, TaxUnitEntity> taxUnitMap;
    private Map<Long, TaxCategoryEntity> categoryEntityMap;
    private Map<Long, TaxItemEntity> itemEntityMap;
    private Map<Long, CalRuleEntity> calRuleEntityMap;
    @JsonIgnore
    private transient Map<Long, TaxCalFormulaEntity> formulaEntityMap;
    private Map<Long, AccumulatorInfo> accInfoMap;
    private Set<Long> newCategories;
    private Map<Long, Long> taxTaskOfTaxUnitMap;
    private Map<Long, DefaultBizMessage> taxTaskFailMsg;
    private Map<Long, DefaultBizMessage> taxUnitFailMsg;
    private Map<Long, DefaultBizMessage> formulaFailMsg;
    @JsonIgnore
    private transient Map<Long, String> dataKeyOfTaxFile;
    @JsonIgnore
    private transient Map<String, Long> taxFileOfDataKey;
    @JsonIgnore
    private transient Map<Long, List<String>> dataKeyOfTaskMap;

    public boolean isTerminated() {
        if (this.terminated) {
            return true;
        }
        String terminateCacheKey = this.getOperateKey() + "cancelcalTerminate";
        IAppCache appCache = AppCache.get((String)"sitcs");
        String result = (String)appCache.get(terminateCacheKey, String.class);
        this.logInfo("By Quinn judge terminated key " + terminateCacheKey + ":" + result);
        this.terminated = !StringUtils.isEmpty((Object)result);
        return this.terminated;
    }

    @Override
    public Map<String, Object> toMap(boolean withData) {
        Map<String, Object> result = super.toMap(withData);
        if (!this.isCancelOp() && this.currency != null) {
            result.put("currency", this.currency.getId());
        }
        return result;
    }

    @Override
    public Object resultData() {
        this.taxTaskMsgRecover();
        Map bizData = this.bizData();
        ArrayList data = Lists.newArrayListWithCapacity((int)bizData.size());
        for (Map.Entry entry : bizData.entrySet()) {
            Map<Long, Map<Long, DynamicObject>> itemData;
            HashMap item = Maps.newHashMapWithExpectedSize((int)16);
            data.add(item);
            String dataKey = entry.getKey();
            item.put("dataKey", dataKey);
            TaxCalUnit calUnit = (TaxCalUnit)entry.getValue();
            Boolean isLocalCal = (Boolean)calUnit.getExtraParam("isLocalCal");
            boolean isLocal = isLocalCal != null && isLocalCal != false;
            boolean success = !this.isBizFail(dataKey);
            item.put("success", success);
            BizMessage message = this.bizMessage(dataKey);
            if (message != null) {
                int status = message.getStatus();
                if (!isLocal && success) {
                    if (status >= 300) {
                        status -= 200;
                    } else if (status >= 200) {
                        status -= 100;
                    }
                }
                item.put("status", status);
                item.put("message", message.getMessage());
            } else {
                item.put("status", isLocal ? 200 : 100);
            }
            if (this.isCancelOp()) continue;
            item.put("taxStatus", calUnit.getExtraParam("taxStatus"));
            item.put("isNeedDeclare", calUnit.getExtraParam("isNeedDeclare"));
            item.put("isLocalCal", isLocalCal);
            item.put("bizStatus", calUnit.getExtraParam("bizStatus"));
            item.put("prepareStatus", calUnit.getExtraParam("prepareStatus"));
            item.put("declareStatus", calUnit.getExtraParam("declareStatus"));
            if (!success) continue;
            TaxDataWrapper wrapper = calUnit.currentRawData();
            if (wrapper == null || (itemData = wrapper.getItemData()) == null) {
                item.put("items", Lists.newArrayList());
                continue;
            }
            ArrayList items = Lists.newArrayListWithCapacity((int)(itemData.size() * 10));
            item.put("items", items);
            for (Map.Entry<Long, Map<Long, DynamicObject>> catEntry : itemData.entrySet()) {
                Long catId = catEntry.getKey();
                Map<Long, DynamicObject> value = catEntry.getValue();
                for (Map.Entry<Long, DynamicObject> itemEntry : value.entrySet()) {
                    DynamicObject itemObj = itemEntry.getValue();
                    String dataDirect = itemObj.getString("datadirect");
                    if (!CalTaxTypeEnum.fromTaxByCode(dataDirect)) continue;
                    LinkedHashMap itemMap = Maps.newLinkedHashMapWithExpectedSize((int)8);
                    items.add(itemMap);
                    itemMap.put("taxCategory", catId);
                    itemMap.put("taxItem", itemEntry.getKey());
                    itemMap.put("itemValue", itemObj.getString("calvalue"));
                }
            }
        }
        return data;
    }

    public BizMessage validateCatAndItem(Long taxCategoryId, Long taxItemId) {
        TaxItemEntity taxItem;
        if (this.categoryEntityMap == null || !this.categoryEntityMap.containsKey(taxCategoryId)) {
            return CalFailTypeEnum.CATEGORY_NOT_EXIST.of(ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"TaxCalContext_1", (String)"sit-sitbp-common", (Object[])new Object[0]));
        }
        if (this.itemEntityMap == null || (taxItem = this.itemEntityMap.get(taxItemId)) == null) {
            return CalFailTypeEnum.ITEM_NOT_EXIST.of(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"TaxCalContext_2", (String)"sit-sitbp-common", (Object[])new Object[0]));
        }
        if (!taxItem.isCategory(taxCategoryId)) {
            return CalFailTypeEnum.ITEM_NOT_MATCH_CATEGORY.of(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u4e0d\u5339\u914d\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxCalContext_3", (String)"sit-sitbp-common", (Object[])new Object[0]));
        }
        return null;
    }

    public void addTaxUnitMap(Map<Long, TaxUnitEntity> taxUnitMap) {
        if (this.taxUnitMap == null) {
            this.taxUnitMap = Maps.newHashMap(taxUnitMap);
        } else {
            this.taxUnitMap.putAll(taxUnitMap);
        }
    }

    public void addItemMap(Map<Long, TaxItemEntity> itemMap) {
        if (this.itemEntityMap == null) {
            this.itemEntityMap = Maps.newHashMap(itemMap);
        } else {
            this.itemEntityMap.putAll(itemMap);
        }
    }

    public void addCategoryMap(Map<Long, TaxCategoryEntity> categoryMap) {
        if (this.categoryEntityMap == null) {
            this.categoryEntityMap = Maps.newHashMap(categoryMap);
        } else {
            this.categoryEntityMap.putAll(categoryMap);
        }
    }

    public Set<Long> newCategoriesOfThisBatch() {
        Set categoriesOfThisBatch = (Set)this.getTempParam("taxCategoryIds");
        if (CollectionUtils.isEmpty((Collection)categoriesOfThisBatch)) {
            return categoriesOfThisBatch;
        }
        if (!CollectionUtils.isEmpty(this.categoryEntityMap)) {
            categoriesOfThisBatch.removeAll(this.categoryEntityMap.keySet());
        }
        return categoriesOfThisBatch;
    }

    public int yearMonth() {
        if (this.getTaxPeriod() == null) {
            return SitDateUtil.toYearMonth(this.getPayDate());
        }
        return this.getTaxPeriod().yearMonth();
    }

    public Map<String, Long> computeTaxFileOfDataKeyIfAbsent(int size) {
        if (this.taxFileOfDataKey == null) {
            this.taxFileOfDataKey = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.taxFileOfDataKey;
    }

    public Map<Long, String> computeDataKeyOfTaxFileIfAbsent(int size) {
        if (this.dataKeyOfTaxFile == null) {
            this.dataKeyOfTaxFile = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.dataKeyOfTaxFile;
    }

    public Map<Long, Long> computeTaxTaskOfUnitIfAbsent(int size) {
        if (this.taxTaskOfTaxUnitMap == null) {
            this.taxTaskOfTaxUnitMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.taxTaskOfTaxUnitMap;
    }

    public Map<Long, TaxItemEntity> computeItemEntityMapIfAbsent(int size) {
        if (this.itemEntityMap == null) {
            this.itemEntityMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.itemEntityMap;
    }

    public Map<Long, TaxCalFormulaEntity> computeTaxItemFormulaIfAbsent(int size) {
        if (this.formulaEntityMap == null) {
            this.formulaEntityMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.formulaEntityMap;
    }

    public Map<Long, CalRuleEntity> computeCalRuleIfAbsent(int size) {
        if (this.calRuleEntityMap == null) {
            this.calRuleEntityMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.calRuleEntityMap;
    }

    public Map<Long, TaxTaskEntity> computeTaxTaskIfAbsent(int size) {
        if (this.taskEntityMap == null) {
            this.taskEntityMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.taskEntityMap;
    }

    public Map<Long, Long> computeTaxTaskOfTaxUnitIfAbsent(int size) {
        if (this.taxTaskOfTaxUnitMap == null) {
            this.taxTaskOfTaxUnitMap = Maps.newHashMapWithExpectedSize((int)size);
        }
        return this.taxTaskOfTaxUnitMap;
    }

    public void generateTaxCalUnitMap(Map<Long, List<String>> srcDataKeyOfUnit, Map<String, Map<String, Object>> dataOfDataKey) {
        this.dataKeyOfTaskMap = this.dataKeyOfTaskMap == null ? Maps.newHashMapWithExpectedSize((int)this.taskEntityMap.size()) : this.dataKeyOfTaskMap;
        this.dataKeyOfTaxFile = this.dataKeyOfTaxFile == null ? Maps.newHashMapWithExpectedSize((int)dataOfDataKey.size()) : this.dataKeyOfTaxFile;
        this.taxFileOfDataKey = this.taxFileOfDataKey == null ? Maps.newHashMapWithExpectedSize((int)dataOfDataKey.size()) : this.taxFileOfDataKey;
        Map bizDataMap = this.computeBizDataIfAbsent(dataOfDataKey.size());
        for (Map.Entry<Long, List<String>> entry : srcDataKeyOfUnit.entrySet()) {
            Long taxUnitId = entry.getKey();
            List<String> srcDataKeys = entry.getValue();
            for (String srcDataKey : srcDataKeys) {
                TaxCalUnit calUnit = new TaxCalUnit();
                bizDataMap.put(srcDataKey, calUnit);
                Map<String, Object> calRecord = dataOfDataKey.get(srcDataKey);
                Long taxFileId = (Long)calRecord.get("taxFileId");
                this.dataKeyOfTaxFile.put(taxFileId, srcDataKey);
                this.taxFileOfDataKey.put(srcDataKey, taxFileId);
                calUnit.setSrcData(calRecord);
                calUnit.setTaxFileId(taxFileId);
                calUnit.setTaxUnitId(taxUnitId);
                calUnit.setSrcDataKey(srcDataKey);
                Set taxCategoryIds = (Set)calRecord.get("taxCategoryIds");
                calUnit.addCatIds(taxCategoryIds);
            }
            Long taxTaskId = this.taxTaskOfTaxUnitMap.get(taxUnitId);
            if (taxTaskId == null) {
                taxTaskId = 0L;
                CalFailTypeEnum.FailInstance instance = CalFailTypeEnum.TAX_TASK_NOT_EXISTS.of(ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d\u5bf9\u5e94\u7684\u4e2a\u7a0e\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"TaxCalContext_0", (String)"sit-sitbp-common", (Object[])new Object[0]));
                this.bizFailByDataKeys(instance, srcDataKeys);
                this.taxTaskFail(DefaultBizMessage.from(instance), 0L);
            }
            List srcDataKeyOfTask = this.dataKeyOfTaskMap.computeIfAbsent(taxTaskId, ky -> Lists.newArrayListWithExpectedSize((int)srcDataKeys.size()));
            srcDataKeyOfTask.addAll(srcDataKeys);
            BizMessage failMsg = this.taxUnitFailMsg(taxUnitId);
            if (failMsg != null) {
                this.bizFailByDataKeys(failMsg, srcDataKeys);
            }
            if ((failMsg = this.taxTaskFailMsg(taxTaskId)) == null) continue;
            this.bizFailByDataKeys(failMsg, srcDataKeys);
        }
    }

    public void formulaFail(BizMessage message, Long formulaId) {
        if (this.formulaFailMsg == null) {
            this.formulaFailMsg = Maps.newHashMapWithExpectedSize((int)32);
        }
        DefaultBizMessage from = DefaultBizMessage.from(message);
        this.formulaFailMsg.put(formulaId, from);
    }

    public void taxTaskFail(BizMessage message, Long taskTaskId) {
        List<String> srcDataKeys;
        if (this.taxTaskFailMsg == null) {
            this.taxTaskFailMsg = Maps.newHashMapWithExpectedSize((int)8);
        }
        DefaultBizMessage from = DefaultBizMessage.from(message);
        this.taxTaskFailMsg.put(taskTaskId, from);
        if (this.dataKeyOfTaskMap != null && !CollectionUtils.isEmpty(srcDataKeys = this.dataKeyOfTaskMap.get(taskTaskId))) {
            this.bizFailByDataKeys(from, srcDataKeys);
        }
    }

    public void taxTaskMsgRecover() {
        if (CollectionUtils.isEmpty(this.taxTaskFailMsg)) {
            return;
        }
        for (Map.Entry<Long, DefaultBizMessage> entry : this.taxTaskFailMsg.entrySet()) {
            List<String> srcDataKeys = this.dataKeyOfTaskMap.get(entry.getKey());
            if (CollectionUtils.isEmpty(srcDataKeys)) continue;
            this.bizFailByDataKeys(entry.getValue(), srcDataKeys);
        }
    }

    public void taxUnitFail(BizMessage message, Set<Long> taxUnitSet) {
        if (this.taxUnitFailMsg == null) {
            this.taxUnitFailMsg = Maps.newHashMapWithExpectedSize((int)taxUnitSet.size());
        }
        DefaultBizMessage from = DefaultBizMessage.from(message);
        taxUnitSet.forEach(ele -> this.taxUnitFailMsg.put((Long)ele, from));
    }

    public void taxUnitFail(BizMessage message, Long taxUnitId) {
        if (this.taxUnitFailMsg == null) {
            this.taxUnitFailMsg = Maps.newHashMapWithExpectedSize((int)16);
        }
        DefaultBizMessage from = DefaultBizMessage.from(message);
        this.taxUnitFailMsg.put(taxUnitId, from);
    }

    public void bizFailByDataKeys(CalFailTypeEnum message, Collection<String> srcDataKeys, String desc) {
        this.computeBizMsgIfAbsent(srcDataKeys.size());
        srcDataKeys.forEach(ele -> this.doBizFailByDataKey((String)ele, message, desc));
    }

    public void bizFailByFileIds(BizMessage message, Collection<Long> taxFileIds) {
        this.computeBizMsgIfAbsent(taxFileIds.size());
        taxFileIds.forEach(ele -> this.doBizFailByDataKey(message, this.getDataKey((Long)ele)));
    }

    public void calUnitFailByFileId(BizMessage message, Long taxFileId) {
        this.calUnitFailByDataKey(message, this.getDataKey(taxFileId));
    }

    public void calUnitFailByDataKey(BizMessage message, String srcDataKey) {
        this.computeBizMsgIfAbsent(16);
        this.doBizFailByDataKey(message, srcDataKey);
    }

    public void doBizFailByDataKey(String srcDataKey, CalFailTypeEnum message, String desc) {
        this.doBizFailByDataKey(message.of(desc), srcDataKey);
    }

    public TaxCalUnit calUnitOfIFiled(Long taxFileId) {
        if (this.dataKeyOfTaxFile == null) {
            return null;
        }
        String srcDataKey = this.dataKeyOfTaxFile.get(taxFileId);
        if (StringUtils.isEmpty((Object)srcDataKey)) {
            return null;
        }
        return (TaxCalUnit)this.bizDataOf(srcDataKey);
    }

    public BizMessage taxTaskFailMsg(Long taxTaskId) {
        return this.taxTaskFailMsg == null ? null : (BizMessage)this.taxTaskFailMsg.get(taxTaskId);
    }

    public BizMessage taxUnitFailMsg(Long taxUnitId) {
        return this.taxUnitFailMsg == null ? null : (BizMessage)this.taxUnitFailMsg.get(taxUnitId);
    }

    public TaxUnitEntity taxUnitEntity(Long taxUnitId) {
        return this.taxUnitMap == null ? null : this.taxUnitMap.get(taxUnitId);
    }

    public boolean isTaxUnitLoaded(Long taxUnitId) {
        return this.taxUnitEntity(taxUnitId) != null || this.taxUnitFailMsg(taxUnitId) != null;
    }

    public boolean isNeedRateExchange() {
        return this.currency != null && this.rawCurrency != null && !ObjectUtils.nullSafeEquals((Object)this.currency.getId(), (Object)this.rawCurrency.getId());
    }

    public TaxTaskEntity getTaskById(Long taxTaskId) {
        return this.taskEntityMap == null ? null : this.taskEntityMap.get(taxTaskId);
    }

    public Map<String, TaxCalUnit> bizDataOf(List<String> srcDataKeys) {
        HashMap result = Maps.newHashMap(this.bizData());
        result.keySet().retainAll(srcDataKeys);
        return result;
    }

    public CalRuleEntity getCalRuleEntity(Long calRuleId) {
        return this.calRuleEntityMap.get(calRuleId);
    }

    public TaxCalFormulaEntity getFormulaEntity(Long formulaId) {
        return this.formulaEntityMap.get(formulaId);
    }

    public String getDataKey(Long taxFileId) {
        return this.dataKeyOfTaxFile.get(taxFileId);
    }

    public Map<Long, List<String>> dataKeyOfTaskMap() {
        if (CollectionUtils.isEmpty(this.dataKeyOfTaskMap) && this.bizData() != null) {
            return Maps.asMap((Set)Sets.newHashSet((Object[])new Long[]{0L}), ky -> Lists.newArrayList(this.bizData().keySet()));
        }
        return this.dataKeyOfTaskMap;
    }

    public void dataKeyOfTaskMap(Map<Long, List<String>> dataTaskMap) {
        this.dataKeyOfTaskMap = dataTaskMap;
    }

    public Set<Long> taxFileIds() {
        return this.dataKeyOfTaxFile == null ? Sets.newHashSet() : this.dataKeyOfTaxFile.keySet();
    }

    public Set<Long> taxFileIdsOf(Collection<String> srcDataKeys) {
        if (CollectionUtils.isEmpty(this.taxFileOfDataKey)) {
            return Sets.newHashSet();
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)srcDataKeys.size());
        for (String srcDataKey : srcDataKeys) {
            Long taxFileId = this.taxFileOfDataKey.get(srcDataKey);
            if (taxFileId == null) continue;
            result.add(taxFileId);
        }
        return result;
    }

    public Map<Long, TaxCalUnit> taxCalUnitOfFile(Map<String, TaxCalUnit> calUnitMap) {
        if (CollectionUtils.isEmpty(this.taxFileOfDataKey) || CollectionUtils.isEmpty(calUnitMap)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)calUnitMap.size());
        for (Map.Entry<String, TaxCalUnit> entry : calUnitMap.entrySet()) {
            Long taxFileId = this.taxFileOfDataKey.get(entry.getKey());
            if (taxFileId == null) continue;
            result.put(taxFileId, entry.getValue());
        }
        return result;
    }

    public void addNewTaxCategories(Collection<Long> newTaxCategories) {
        if (this.newCategories == null) {
            this.newCategories = Sets.newHashSet(newTaxCategories);
        } else {
            this.newCategories.addAll(newTaxCategories);
        }
    }

    public String taxUnitNames(Long ... taxUnits) {
        StringBuilder sb = new StringBuilder();
        String splitChar = TaxCalContext.getMultiLangDelimiter();
        for (Long taxUnitId : taxUnits) {
            TaxUnitEntity taxUnit = this.taxUnitMap == null ? null : this.taxUnitMap.get(taxUnitId);
            sb.append(taxUnit == null ? taxUnitId : taxUnit.localName()).append(splitChar);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - splitChar.length(), sb.length());
        }
        return sb.toString();
    }

    public String taxCategoryNames(Long ... catIds) {
        StringBuilder sb = new StringBuilder();
        String splitChar = TaxCalContext.getMultiLangDelimiter();
        for (Long catId : catIds) {
            TaxCategoryEntity cat = this.categoryEntityMap == null ? null : this.categoryEntityMap.get(catId);
            sb.append(cat == null ? catId : cat.getNameLocaleString()).append(splitChar);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - splitChar.length(), sb.length());
        }
        return sb.toString();
    }

    public String taxItemNames(Long ... itemIds) {
        StringBuilder sb = new StringBuilder();
        String splitChar = TaxCalContext.getMultiLangDelimiter();
        for (Long itemId : itemIds) {
            TaxItemEntity item = this.itemEntityMap == null ? null : this.itemEntityMap.get(itemId);
            sb.append(item == null ? itemId : item.getNameLocaleString()).append(splitChar);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - splitChar.length(), sb.length());
        }
        return sb.toString();
    }

    public Map<Long, TaxItemEntity> itemMapOf(Long taxCategoryId) {
        if (this.itemEntityMap == null) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap res = Maps.newHashMapWithExpectedSize((int)this.itemEntityMap.size());
        for (Map.Entry<Long, TaxItemEntity> entry : this.itemEntityMap.entrySet()) {
            if (!entry.getValue().isCategory(taxCategoryId)) continue;
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public boolean calItemUnicodeNeedBaseDataConvert(String prop) {
        return prop != null && prop.indexOf(46) > 0 && !prop.endsWith(".id");
    }

    @Override
    public void clearBizData() {
        super.clearBizData();
        this.setValidate(false);
    }

    private static String getMultiLangDelimiter() {
        Lang lang = Lang.get();
        String comma = Lang.zh_CN == lang || Lang.zh_TW == lang ? "\uff0c" : ",";
        return comma;
    }

    public String getCalTaskNumber() {
        return this.calTaskNumber;
    }

    public void setCalTaskNumber(String calTaskNumber) {
        this.calTaskNumber = calTaskNumber;
    }

    public String getCalTaskName() {
        return this.calTaskName;
    }

    public void setCalTaskName(String calTaskName) {
        this.calTaskName = calTaskName;
    }

    public Long getRawTaskId() {
        return this.rawTaskId;
    }

    public void setRawTaskId(Long rawTaskId) {
        this.rawTaskId = rawTaskId;
    }

    public CurrencyEntity getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEntity currency) {
        this.currency = currency;
    }

    public CurrencyEntity getRawCurrency() {
        return this.rawCurrency;
    }

    public void setRawCurrency(CurrencyEntity rawCurrency) {
        this.rawCurrency = rawCurrency;
    }

    public boolean isMergeRawData() {
        return this.mergeRawData;
    }

    public void setMergeRawData(boolean mergeRawData) {
        this.mergeRawData = mergeRawData;
    }

    public boolean isCancelOp() {
        return this.cancelOp;
    }

    public void setCancelOp(boolean cancelOp) {
        this.cancelOp = cancelOp;
    }

    public Map<Long, Long> getTaxTaskOfTaxUnitMap() {
        return this.taxTaskOfTaxUnitMap;
    }

    public void setTaxTaskOfTaxUnitMap(Map<Long, Long> taxTaskOfTaxUnitMap) {
        this.taxTaskOfTaxUnitMap = taxTaskOfTaxUnitMap;
    }

    public Map<Long, TaxTaskEntity> getTaskEntityMap() {
        return this.taskEntityMap;
    }

    public void setTaskEntityMap(Map<Long, TaxTaskEntity> taskEntityMap) {
        this.taskEntityMap = taskEntityMap;
    }

    public Map<Long, TaxCategoryEntity> getCategoryEntityMap() {
        return this.categoryEntityMap;
    }

    public void setCategoryEntityMap(Map<Long, TaxCategoryEntity> categoryEntityMap) {
        this.categoryEntityMap = categoryEntityMap;
    }

    public Map<Long, DefaultBizMessage> getTaxTaskFailMsg() {
        return this.taxTaskFailMsg;
    }

    public void setTaxTaskFailMsg(Map<Long, DefaultBizMessage> taxTaskFailMsg) {
        this.taxTaskFailMsg = taxTaskFailMsg;
    }

    public Map<Long, DefaultBizMessage> getTaxUnitFailMsg() {
        return this.taxUnitFailMsg;
    }

    public void setTaxUnitFailMsg(Map<Long, DefaultBizMessage> taxUnitFailMsg) {
        this.taxUnitFailMsg = taxUnitFailMsg;
    }

    public Map<Long, TaxItemEntity> getItemEntityMap() {
        return this.itemEntityMap;
    }

    public void setItemEntityMap(Map<Long, TaxItemEntity> itemEntityMap) {
        this.itemEntityMap = itemEntityMap;
    }

    public Map<Long, CalRuleEntity> getCalRuleEntityMap() {
        return this.calRuleEntityMap;
    }

    public void setCalRuleEntityMap(Map<Long, CalRuleEntity> calRuleEntityMap) {
        this.calRuleEntityMap = calRuleEntityMap;
    }

    public Map<Long, TaxCalFormulaEntity> formulaEntityMap() {
        return this.formulaEntityMap;
    }

    @JsonIgnore
    public Map<Long, TaxCalFormulaEntity> getFormulaEntityMap() {
        return this.formulaEntityMap;
    }

    public Map<Long, AccumulatorInfo> getAccInfoMap() {
        return this.accInfoMap;
    }

    public void setAccInfoMap(Map<Long, AccumulatorInfo> accInfoMap) {
        this.accInfoMap = accInfoMap;
    }

    public Set<Long> getNewCategories() {
        return this.newCategories;
    }

    public void setNewCategories(Set<Long> newCategories) {
        this.newCategories = newCategories;
    }

    public Map<Long, TaxUnitEntity> getTaxUnitMap() {
        return this.taxUnitMap;
    }

    public void setTaxUnitMap(Map<Long, TaxUnitEntity> taxUnitMap) {
        this.taxUnitMap = taxUnitMap;
    }

    public Map<Long, DefaultBizMessage> getFormulaFailMsg() {
        return this.formulaFailMsg;
    }

    public void setFormulaFailMsg(Map<Long, DefaultBizMessage> formulaFailMsg) {
        this.formulaFailMsg = formulaFailMsg;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

