/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.TaxDataWrapper;

public class TaxCalUnit
implements Serializable {
    private static final long serialVersionUID = 686748458800042600L;
    private long taxFileId;
    private long taxUnitId;
    private String srcDataKey;
    private Set<Long> catIds;
    private transient Map<String, Object> srcData;
    private transient Map<String, Object> extraParam;
    private transient TaxDataWrapper taxData;
    private transient LinkedHashMap<String, TaxDataWrapper> taxRawDataMap;
    private transient Map<Long, DynamicObject> prepareData;

    public boolean fileVersionConfirmed() {
        DynamicObject basicData;
        if (this.taxData == null || (basicData = this.taxData.getBasicData()) == null) {
            return false;
        }
        if (!"0".equals(basicData.getString("changetype")) && YesOrNoEnum.isYes(basicData.getString("declarestatus"))) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.taxRawDataMap)) {
            return false;
        }
        for (Map.Entry<String, TaxDataWrapper> entry : this.taxRawDataMap.entrySet()) {
            DynamicObject data = entry.getValue().getBasicData();
            if ("E".equals(data.getString("status")) || entry.getKey().equals(this.srcDataKey)) continue;
            return true;
        }
        return false;
    }

    public TaxDataWrapper currentRawData() {
        return this.taxRawDataMap == null ? null : this.taxRawDataMap.get(this.srcDataKey);
    }

    public String srcRefNum() {
        if (CollectionUtils.isEmpty(this.taxRawDataMap)) {
            return "0";
        }
        int count = 0;
        for (Map.Entry<String, TaxDataWrapper> entry : this.taxRawDataMap.entrySet()) {
            if ("E".equals(entry.getValue().getBasicProp("status")) || ++count <= 1) continue;
            return "2";
        }
        return count + "";
    }

    public List<DynamicObject> getEffectRawData(Long taxCatId) {
        if (CollectionUtils.isEmpty(this.taxRawDataMap)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)this.taxRawDataMap.size());
        for (Map.Entry<String, TaxDataWrapper> entry : this.taxRawDataMap.entrySet()) {
            DynamicObject category;
            if ("E".equals(entry.getValue().getBasicProp("status")) || (category = entry.getValue().getCategory(taxCatId)) == null || "E".equals(category.getString("status"))) continue;
            result.add(category);
        }
        return result;
    }

    public boolean isCurrentLatest() {
        if (CollectionUtils.isEmpty(this.taxRawDataMap)) {
            return true;
        }
        for (Map.Entry<String, TaxDataWrapper> entry : this.taxRawDataMap.entrySet()) {
            if (entry.getKey().equals(this.srcDataKey)) {
                return true;
            }
            if (!entry.getValue().effect()) continue;
            return false;
        }
        return true;
    }

    public TaxDataWrapper setTaxDataBasic(DynamicObject taxDataBasicObj) {
        taxDataBasicObj.set("srcrefnum", (Object)"0");
        if (this.taxData != null) {
            this.taxData.setBasicData(taxDataBasicObj);
        } else {
            this.taxData = new TaxDataWrapper(taxDataBasicObj);
        }
        this.setExtraParam("declareStatus", taxDataBasicObj.getString("declareStatus"));
        this.setExtraParam("prepareStatus", taxDataBasicObj.getString("prepareStatus"));
        return this.taxData;
    }

    public boolean addTaxData(DynamicObject taxDataObj) {
        if (this.taxData == null) {
            return false;
        }
        this.taxData.addCategoryData(taxDataObj);
        return true;
    }

    public Map<String, TaxDataWrapper> computeTaxRawDataMapIfAbsent(int size) {
        if (this.taxRawDataMap == null) {
            this.taxRawDataMap = Maps.newLinkedHashMapWithExpectedSize((int)size);
        }
        return this.taxRawDataMap;
    }

    public TaxDataWrapper addTaxRawDataBasic(DynamicObject taxRawDataBasicObj) {
        if (this.taxRawDataMap == null) {
            this.taxRawDataMap = Maps.newLinkedHashMapWithExpectedSize((int)8);
        }
        String dataKey = taxRawDataBasicObj.getString("rawdatakey");
        TaxDataWrapper result = new TaxDataWrapper(taxRawDataBasicObj);
        this.taxRawDataMap.put(dataKey, result);
        return result;
    }

    public boolean addTaxRawData(DynamicObject taxRawDataObj) {
        if (this.taxRawDataMap == null) {
            return false;
        }
        String dataKey = taxRawDataObj.getString("taxdatabasic.rawdatakey");
        TaxDataWrapper wrapper = this.taxRawDataMap.get(dataKey);
        if (wrapper == null) {
            return false;
        }
        wrapper.addCategoryData(taxRawDataObj);
        if (!"E".equals(taxRawDataObj.get("status")) && !ObjectUtils.nullSafeEquals((Object)dataKey, (Object)this.srcDataKey) && "10".compareTo(taxRawDataObj.getString("bizstatus")) <= 0) {
            this.taxData.setBasicProp("srcrefnum", "1");
        }
        return true;
    }

    public void addPrepareData(DynamicObject data) {
        this.addPrepareData(data.getLong("taxcategory.id"), data);
    }

    public void addPrepareData(Long catId, DynamicObject data) {
        this.prepareData = this.prepareData == null ? Maps.newHashMapWithExpectedSize((int)8) : this.prepareData;
        this.prepareData.put(catId, data);
    }

    public void addCatIds(Long ... catIds) {
        if (catIds == null || catIds.length == 0) {
            return;
        }
        this.catIds = this.catIds == null ? Sets.newHashSetWithExpectedSize((int)16) : this.catIds;
        for (Long catId : catIds) {
            this.catIds.add(catId);
        }
    }

    public void addCatIds(Collection<Long> catIds) {
        if (CollectionUtils.isEmpty(catIds)) {
            return;
        }
        this.catIds = this.catIds == null ? Sets.newHashSetWithExpectedSize((int)16) : this.catIds;
        this.catIds.addAll(catIds);
    }

    public long getIdFromBasic(String key) {
        return this.taxData == null ? 0L : this.taxData.getIdFromBasic(key);
    }

    public DynamicObject getPrepareData(Long catId) {
        return this.prepareData == null ? null : this.prepareData.get(catId);
    }

    public TaxDataWrapper getTaxRawDataBasic(String dataKey) {
        if (this.taxRawDataMap == null) {
            return null;
        }
        return this.taxRawDataMap.get(dataKey);
    }

    public void setExtraParam(String key, Object value) {
        if (this.extraParam == null) {
            this.extraParam = Maps.newHashMapWithExpectedSize((int)16);
        }
        this.extraParam.put(key, value);
    }

    public TaxDataWrapper getRawData(String srcDataKey) {
        return this.taxRawDataMap == null ? null : this.taxRawDataMap.get(srcDataKey);
    }

    public <T> T getSrcData(String key) {
        return (T)(this.srcData == null ? null : this.srcData.get(key));
    }

    public <T> T getExtraParam(String key) {
        return (T)(this.extraParam == null ? null : this.extraParam.get(key));
    }

    public long getTaxFileId() {
        return this.taxFileId;
    }

    public void setTaxFileId(long taxFileId) {
        this.taxFileId = taxFileId;
    }

    public long getTaxUnitId() {
        return this.taxUnitId;
    }

    public void setTaxUnitId(long taxUnitId) {
        this.taxUnitId = taxUnitId;
    }

    public String getSrcDataKey() {
        return this.srcDataKey;
    }

    public void setSrcDataKey(String srcDataKey) {
        this.srcDataKey = srcDataKey;
    }

    public Map<String, Object> getSrcData() {
        return this.srcData;
    }

    public void setSrcData(Map<String, Object> srcData) {
        this.srcData = srcData;
    }

    public TaxDataWrapper getTaxData() {
        return this.taxData;
    }

    public void setTaxData(TaxDataWrapper taxData) {
        this.taxData = taxData;
    }

    public Map<String, TaxDataWrapper> getTaxRawDataMap() {
        if (this.taxRawDataMap == null) {
            this.taxRawDataMap = Maps.newLinkedHashMap();
        }
        return this.taxRawDataMap;
    }

    public void setTaxRawDataMap(Map<String, TaxDataWrapper> taxRawDataMap) {
        if (taxRawDataMap == null) {
            this.taxRawDataMap = Maps.newLinkedHashMap();
        } else if (taxRawDataMap instanceof LinkedHashMap) {
            this.taxRawDataMap = (LinkedHashMap)taxRawDataMap;
        } else {
            ArrayList list = Lists.newArrayList(taxRawDataMap.values());
            list.sort((o1, o2) -> ((Date)o2.getBasicProp("createtime")).compareTo((Date)o1.getBasicProp("createtime")));
            this.taxRawDataMap = Maps.newLinkedHashMap(taxRawDataMap);
        }
    }

    public Set<Long> getCatIds() {
        return this.catIds;
    }

    public void setCatIds(Set<Long> catIds) {
        this.catIds = catIds;
    }
}

