/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.api.QueryMedia;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxDataBaseContext;

public class TaxDataGetContext
extends TaxDataBaseContext<Map<String, Object>> {
    private static final long serialVersionUID = 8552785024793585045L;
    private String queryMediaName;
    private boolean returnList = false;
    private PropertiesQueryInfo queryInfo;
    private Set<String> srcDataKeyList;
    private transient QueryMedia<Map<String, Object>, TaxDataGetContext> queryMedia;

    public TaxDataGetContext() {
    }

    public TaxDataGetContext(QueryMedia<Map<String, Object>, TaxDataGetContext> queryMedia) {
        this.queryMedia = queryMedia;
    }

    @Override
    public Object resultData() {
        if (!CollectionUtils.isEmpty(this.bizData())) {
            this.srcDataKeyList.removeAll(this.bizData().keySet());
        } else if (this.bizData() == null) {
            this.computeBizDataIfAbsent(this.srcDataKeyList.size());
        }
        if (!CollectionUtils.isEmpty(this.srcDataKeyList)) {
            BizMessage bizMessage = this.queryMedia.messageNotHint();
            for (String srcDataKey : this.srcDataKeyList) {
                HashMap item = Maps.newHashMapWithExpectedSize((int)8);
                this.bizData().put(srcDataKey, item);
                item.put("success", !bizMessage.isError());
                item.put("status", bizMessage.getStatus());
                item.put("message", bizMessage.getMessage());
            }
        }
        if (this.returnList && this.bizData() != null) {
            return Lists.newArrayList(this.bizData().values());
        }
        return this.bizData();
    }

    public PropertiesQueryInfo query(String entitySuffix, String ... props) {
        this.queryInfo = PropertiesQueryInfo.special(this.getAppId() + "_" + entitySuffix, props);
        return this.queryInfo;
    }

    public void dealUnHintData() {
        this.queryMedia.dealUnHintData(this);
    }

    public List<QFilter> filters() {
        return this.queryMedia.getFilters(this);
    }

    public String orderBy() {
        return this.queryMedia.getOrderBy(this);
    }

    public void accept(DynamicObject media) {
        this.queryMedia.accept(media, this);
    }

    public void returnList() {
        this.returnList = true;
    }

    public void queryMedia(QueryMedia queryMedia) {
        this.queryMedia = queryMedia;
    }

    public String getQueryMediaName() {
        return this.queryMediaName;
    }

    public void setQueryMediaName(String queryMediaName) {
        this.queryMediaName = queryMediaName;
    }

    public PropertiesQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(PropertiesQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public Set<String> getSrcDataKeyList() {
        return this.srcDataKeyList;
    }

    public void setSrcDataKeyList(Collection<String> srcDataKeyList) {
        this.srcDataKeyList = srcDataKeyList == null ? null : (srcDataKeyList instanceof Set ? (Set)srcDataKeyList : Sets.newHashSet(srcDataKeyList));
    }

    public boolean isReturnList() {
        return this.returnList;
    }

    public void setReturnList(boolean returnList) {
        this.returnList = returnList;
    }
}

