/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.sit.sitbp.common.api.KeyGenerator;

public class TaxDataSrcGroup<K, T> {
    private T taxData;
    private Map<K, T> srcDataMap;
    private Map<String, Object> extraParams;
    private KeyGenerator<K, T> keyGenerator;

    public TaxDataSrcGroup() {
    }

    public TaxDataSrcGroup(T taxData, KeyGenerator<K, T> keyGenerator) {
        this.taxData = taxData;
        this.keyGenerator = keyGenerator;
        this.extraParams = new HashMap<String, Object>(8);
        this.srcDataMap = new LinkedHashMap<K, T>(8);
    }

    public TaxDataSrcGroup(T taxData, List<T> taxSrcData, KeyGenerator<K, T> keyGenerator) {
        this.taxData = taxData;
        this.keyGenerator = keyGenerator;
        this.extraParams = new HashMap<String, Object>(8);
        this.srcDataMap = new LinkedHashMap<K, T>(taxSrcData.size());
        for (T srcData : taxSrcData) {
            this.srcDataMap.put(keyGenerator.genKey(srcData), srcData);
        }
    }

    public void addTaxSrcData(T srcData) {
        this.srcDataMap.put(this.keyGenerator.genKey(srcData), srcData);
    }

    public T computeIfAbsent(K key, Function<? super K, ? extends T> mappingFunction) {
        return this.srcDataMap.computeIfAbsent((K)key, (Function<? super K, T>)mappingFunction);
    }

    public T getSrcData(K key) {
        return this.srcDataMap.get(key);
    }

    public <P> P getExtraParam(String key) {
        return (P)this.extraParams.get(key);
    }

    public void setExtraParam(String key, Object value) {
        this.extraParams.put(key, value);
    }

    public T getTaxData() {
        return this.taxData;
    }

    public void setTaxData(T taxData) {
        this.taxData = taxData;
    }

    public Map<K, T> getSrcDataMap() {
        return this.srcDataMap;
    }

    public void setSrcDataMap(Map<K, T> srcDataMap) {
        this.srcDataMap = srcDataMap;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }
}

