/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataWrapper {
    private DynamicObject basicData;
    private Map<Long, DynamicObject> categoryData;
    private Map<Long, Map<Long, DynamicObject>> itemData;
    private Map<String, Object> extraParams;

    public TaxDataWrapper(DynamicObject basicData, List<DynamicObject> categoryData) {
        this.basicData = basicData;
        this.extraParams = new HashMap<String, Object>(16);
        if (categoryData != null) {
            this.categoryData = new HashMap<Long, DynamicObject>(categoryData.size());
            this.itemData = new HashMap<Long, Map<Long, DynamicObject>>(categoryData.size() * 4);
            for (DynamicObject taxSrcData : categoryData) {
                this.addCategoryData(taxSrcData);
            }
        } else {
            this.categoryData = new HashMap<Long, DynamicObject>(4);
            this.itemData = new HashMap<Long, Map<Long, DynamicObject>>(16);
        }
    }

    public TaxDataWrapper(DynamicObject basicObject) {
        this.basicData = basicObject;
        this.categoryData = new HashMap<Long, DynamicObject>(4);
        this.itemData = new HashMap<Long, Map<Long, DynamicObject>>(16);
        this.extraParams = new HashMap<String, Object>(16);
    }

    public void clearCategoryAtFirst(Long categoryId) {
        DynamicObject object = this.categoryData.get(categoryId);
        if (object != null) {
            DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
            entryEntity.clear();
        }
        this.itemData.remove(categoryId);
    }

    public void clearItems() {
        if (this.basicData.getDataEntityType().getProperties().containsKey((Object)"srcrefnum")) {
            this.basicData.set("srcrefnum", (Object)"0");
        }
        for (Map.Entry<Long, DynamicObject> entry : this.categoryData.entrySet()) {
            DynamicObject value = entry.getValue();
            value.set("status", (Object)"E");
            DynamicObjectCollection entryEntity = value.getDynamicObjectCollection("entryentity");
            entryEntity.clear();
        }
        this.itemData.clear();
    }

    public String getMaxStatus() {
        if (CollectionUtils.isEmpty(this.categoryData)) {
            return null;
        }
        String status = "";
        for (DynamicObject cat : this.categoryData.values()) {
            if (cat.getString("bizstatus") == null || status.compareTo(cat.getString("bizstatus")) >= 0) continue;
            status = cat.getString("bizstatus");
        }
        return status;
    }

    public boolean effect() {
        if (this.basicData == null || CollectionUtils.isEmpty(this.categoryData)) {
            return false;
        }
        String maxStatus = this.getMaxStatus();
        return maxStatus != null && "10".compareTo(maxStatus) < 0;
    }

    public DynamicObject getBasicData() {
        return this.basicData;
    }

    public static String itemKey(Long itemId, Long categoryId) {
        return itemId + "_" + categoryId;
    }

    public DynamicObject getCategory(Long taxCategoryId) {
        return this.categoryData.get(taxCategoryId);
    }

    public Map<Long, DynamicObject> getCategoryData() {
        return this.categoryData;
    }

    public DynamicObject getItem(Long taxItemId, Long taxCategoryId) {
        taxCategoryId = taxCategoryId == null ? Long.valueOf(0L) : taxCategoryId;
        taxItemId = taxItemId == null ? Long.valueOf(0L) : taxItemId;
        Map<Long, DynamicObject> itemMap = this.itemData.get(taxCategoryId);
        return itemMap == null ? null : itemMap.get(taxItemId);
    }

    public void addItem(DynamicObject item, Long taxCategoryId, Long taxItemId) {
        taxCategoryId = taxCategoryId == null ? Long.valueOf(0L) : taxCategoryId;
        taxItemId = taxItemId == null ? Long.valueOf(0L) : taxItemId;
        Map itemMap = this.itemData.computeIfAbsent(taxCategoryId, key -> new HashMap(16));
        itemMap.put(taxItemId, item);
    }

    public void addItem(DynamicObject item, Long taxCategoryId) {
        Object taxItem = item.get("taxitem");
        Long itemId = taxItem instanceof DynamicObject ? Long.valueOf(((DynamicObject)taxItem).getLong("id")) : BaseDataConverter.convert(taxItem, Long.class);
        this.addItem(item, taxCategoryId, itemId);
    }

    public DynamicObject getOrAddItem(Long itemId, Long catId) {
        DynamicObject item = this.getItem(itemId, catId);
        if (item == null) {
            DynamicObject object = this.categoryData.get(catId);
            if (object == null) {
                return null;
            }
            DynamicObjectCollection entry = object.getDynamicObjectCollection("entryentity");
            item = entry.addNew();
            item.set("entryyearmonth", object.get("yearmonth"));
            item.set("taxitem", (Object)itemId);
        }
        this.addItem(item, catId, itemId);
        return item;
    }

    public Map<Long, Map<Long, DynamicObject>> getItemData() {
        return this.itemData;
    }

    public Map<Long, DynamicObject> getItemData(Long taxCategoryId) {
        return this.itemData.get(taxCategoryId);
    }

    public final void addCategoryData(DynamicObject taxData) {
        DynamicObjectCollection entryEntity;
        Object taxCategory = taxData.get("taxcategory");
        Long catId = taxCategory instanceof DynamicObject ? Long.valueOf(((DynamicObject)taxCategory).getLong("id")) : BaseDataConverter.convert(taxCategory, Long.class);
        this.categoryData.put(catId, taxData);
        if (taxData.getDataEntityType().getProperties().get((Object)"entryentity") != null && !CollectionUtils.isEmpty((Collection)(entryEntity = taxData.getDynamicObjectCollection("entryentity")))) {
            for (DynamicObject entry : entryEntity) {
                this.addItem(entry, catId);
            }
        }
    }

    public Object getBasicProp(String prop) {
        return this.basicData.get(prop);
    }

    public long getIdFromBasic(String prop) {
        if (this.basicData == null) {
            return 0L;
        }
        Object res = this.basicData.get(prop = this.propMapping(prop));
        if (res == null) {
            return 0L;
        }
        if (res instanceof DynamicObject) {
            return ((DynamicObject)res).getLong("id");
        }
        return BaseDataConverter.convert(res, Long.class);
    }

    private String propMapping(String prop) {
        int index = prop.indexOf(95);
        if (index > 0) {
            prop = prop.substring(index + 1);
        }
        if ("person".equals(prop)) {
            return "taxperson";
        }
        return prop;
    }

    public void setBasicProp(String prop, Object value) {
        this.basicData.set(prop, value);
    }

    public void setBasicData(DynamicObject basicData) {
        this.basicData = basicData;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }

    public <P> P getExtraParam(String key) {
        return (P)this.extraParams.get(key);
    }

    public void setExtraParam(String key, Object value) {
        this.extraParams.put(key, value);
    }
}

