/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.model.EffectLogger;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileInfoServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(TaxFileInfoService.class);
    private static final Map<String, Map<String, TaxFileInfoService>> TAX_FILE_INFO_SERVICES_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, TaxFileInfoService> TAX_FILE_INFO_SERVICE_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, Map<String, Pair<String, String>>> PROP_MAPPING = Maps.newHashMapWithExpectedSize((int)16);

    public static void openTaxFile(DynamicObject taxFile, DataEditStatusEnum status, IFormView parentView, long referFileId) {
        SITPageCache pageCache = new SITPageCache(parentView);
        Long basicId = pageCache.get("taxDataBasicForOpenTaxFile" + taxFile.getLong("id"), Long.class);
        Map result = null != basicId && basicId > 0L ? (Map)SITMServiceUtils.invokeSITService("iit", "IndividualTaxFileService", "taxFilePreviewFormParameterByVid", taxFile.getLong("taxregion.id"), taxFile.getLong("id"), status.getCode(), basicId, parentView.getPageId()) : (Map)SITMServiceUtils.invokeSITService("iit", "IndividualTaxFileService", "taxFilePreviewFormParameter", taxFile.getLong("taxregion.id"), taxFile.getLong("id"), status.getCode(), referFileId, parentView.getPageId());
        boolean success = BaseDataConverter.convert(result.get("success"), Boolean.class, Boolean.FALSE);
        if (!success) {
            parentView.showErrorNotification(BaseDataConverter.toString(result.get("message")));
            return;
        }
        parentView.showForm((FormShowParameter)result.get("data"));
    }

    public static Map<String, Object> loadTaxFileKeyInfo(Map<String, Object> relateIds, DynamicObject taxFile, int status) {
        HashMap relateFileKeyInfo = Maps.newHashMapWithExpectedSize((int)32);
        Map<String, TaxFileInfoService> taxFileInfoServices = TAX_FILE_INFO_SERVICES_MAP.get(((BasedataEntityType)taxFile.getDataEntityType()).getAppId());
        if (!CollectionUtils.isEmpty(taxFileInfoServices)) {
            for (Map.Entry<String, TaxFileInfoService> entry : taxFileInfoServices.entrySet()) {
                TaxFileInfoService taxFileInfoService = entry.getValue();
                String entityNumber = taxFileInfoService.entityNumber();
                if (status == DataEditStatusEnum.WRITE.getCode() && relateIds.containsKey(taxFileInfoService.entityNumber())) {
                    relateFileKeyInfo.put(entityNumber + ".editStatus", DataEditStatusEnum.CAN_WRITE.getCode());
                    continue;
                }
                relateFileKeyInfo.put(entityNumber + ".editStatus", status);
                Map<String, Object> keyInfoByFileBoId = taxFileInfoService.findKeyInfoByFileBoId(taxFile);
                if (CollectionUtils.isEmpty(keyInfoByFileBoId)) continue;
                for (Map.Entry<String, Object> valueEntry : keyInfoByFileBoId.entrySet()) {
                    relateFileKeyInfo.put(taxFileInfoService.fullPropKey(valueEntry.getKey()), valueEntry.getValue());
                    if (!"id".equals(valueEntry.getKey())) continue;
                    relateIds.put(entityNumber, valueEntry.getValue());
                }
            }
        }
        relateFileKeyInfo.put("relateIds", relateIds);
        return relateFileKeyInfo;
    }

    public static Map<String, Object> loadTaxFileKeyInfoByVid(Map<String, Object> relateIds, DynamicObject taxFile, int status) {
        HashMap relateFileKeyInfo = Maps.newHashMapWithExpectedSize((int)32);
        Map<String, TaxFileInfoService> taxFileInfoServices = TAX_FILE_INFO_SERVICES_MAP.get(((BasedataEntityType)taxFile.getDataEntityType()).getAppId());
        if (!CollectionUtils.isEmpty(taxFileInfoServices)) {
            for (Map.Entry<String, TaxFileInfoService> entry : taxFileInfoServices.entrySet()) {
                TaxFileInfoService taxFileInfoService = entry.getValue();
                String entityNumber = taxFileInfoService.entityNumber();
                relateFileKeyInfo.put(entityNumber + ".editStatus", status);
                Object id = relateIds.get(entityNumber);
                if (null == id || (Long)id <= 0L || "iit_person".equals(entityNumber)) continue;
                HashSet<String> props = new HashSet<String>(taxFileInfoService.propMappings().values());
                Map<String, Object> keyInfoByFile = taxFileInfoService.findMapByVid((Long)id, props);
                if (CollectionUtils.isEmpty(keyInfoByFile)) continue;
                for (Map.Entry<String, Object> valueEntry : keyInfoByFile.entrySet()) {
                    relateFileKeyInfo.put(taxFileInfoService.fullPropKey(valueEntry.getKey()), valueEntry.getValue());
                }
            }
        }
        relateFileKeyInfo.put("relateIds", relateIds);
        return relateFileKeyInfo;
    }

    public static Map<String, Map<Long, Map<String, Object>>> findPropOfTaxFile(String appId, Map<String, Set<Long>> idGroup, Map<String, Set<String>> propGroup) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)idGroup.size());
        Map<String, TaxFileInfoService> infoServiceMap = TAX_FILE_INFO_SERVICES_MAP.get(appId);
        for (Map.Entry<String, Set<String>> entry : propGroup.entrySet()) {
            TaxFileInfoService infoService = TAX_FILE_INFO_SERVICE_MAP.get(entry.getKey());
            TaxFileInfoService taxFileInfoService = infoService = infoService == null ? infoServiceMap.get(entry.getKey()) : infoService;
            if (infoService == null) continue;
            Set<Long> vIds = idGroup.get(entry.getKey());
            entry.getValue().add("id");
            Map<Long, Map<String, Object>> res = infoService.findInfoByVidSet(vIds, entry.getValue());
            result.put(entry.getKey(), res);
        }
        return result;
    }

    public static Map<Long, Map<String, Object>> findPropOfTaxFileResultByFile(String appId, Map<String, Set<Long>> idGroup, Map<String, Map<String, String>> propGroup) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)idGroup.size());
        Map<String, TaxFileInfoService> infoServiceMap = TAX_FILE_INFO_SERVICES_MAP.get(appId);
        for (Map.Entry<String, Map<String, String>> entry : propGroup.entrySet()) {
            TaxFileInfoService infoService = TAX_FILE_INFO_SERVICE_MAP.get(entry.getKey());
            TaxFileInfoService taxFileInfoService = infoService = infoService == null ? infoServiceMap.get(entry.getKey()) : infoService;
            if (infoService == null) continue;
            Set<Long> vIds = idGroup.get(entry.getKey());
            entry.getValue().put(entry.getKey() + ".id", "id");
            Map<Long, Map<String, Object>> res = infoService.findInfoByVidSetResultByFile(vIds, Sets.newHashSet(entry.getValue().values()));
            for (Map.Entry<Long, Map<String, Object>> resEntry : res.entrySet()) {
                Map map = result.computeIfAbsent(resEntry.getKey(), ky -> Maps.newHashMapWithExpectedSize((int)32));
                map.putAll(resEntry.getValue());
            }
        }
        return result;
    }

    public static void decorateFormShowParameter(FormShowParameter formShowParameter, DynamicObject taxFile, Map<String, Object> relateFileKeyInfo) {
        Iterator<Map.Entry<String, Object>> iterator = relateFileKeyInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            if (!next.getKey().endsWith(".editStatus")) continue;
            formShowParameter.setCustomParam(next.getKey(), next.getValue());
            iterator.remove();
        }
        formShowParameter.setCustomParam("relateFileIds", relateFileKeyInfo.get("relateIds"));
        formShowParameter.setCustomParam("status", taxFile.get("status"));
    }

    public static void validateSubInfo(Map<Long, DynamicObject> taxFileMap, TaxFileOpContext taxFileOpContext) {
        Map<String, Map<Long, DynamicObject>> extraInfo;
        HashMap taxFileMapOld;
        EffectLogger effectLogger = new EffectLogger("taxfile import", "TaxFileInfoServiceFactory", LOGGER);
        effectLogger.start("TaxFileInfoServiceFactory validateSubInfo");
        DynamicObject value = (DynamicObject)taxFileMap.entrySet().iterator().next().getValue();
        BasedataEntityType mainEntityType = (BasedataEntityType)value.getDataEntityType();
        Map<String, TaxFileInfoService> taxFileInfoServices = TAX_FILE_INFO_SERVICES_MAP.get(mainEntityType.getAppId());
        if (CollectionUtils.isEmpty(taxFileInfoServices)) {
            return;
        }
        if ("save".equals(taxFileOpContext.getOpKey())) {
            taxFileMapOld = Maps.newHashMap((Map)taxFileMap);
            for (Map.Entry<Object, Object> entry : taxFileMap.entrySet()) {
                if (((DynamicObject)entry.getValue()).getDataEntityState().getFromDatabase()) continue;
                taxFileMapOld.remove(entry.getKey());
            }
        } else {
            taxFileMapOld = taxFileMap;
        }
        if (!CollectionUtils.isEmpty((Map)taxFileMapOld)) {
            for (Map.Entry<Object, Object> entry : taxFileInfoServices.entrySet()) {
                Object[] infoArr;
                HashMap taxFileTemp;
                TaxFileInfoService infoService = (TaxFileInfoService)entry.getValue();
                Map<Long, DynamicObject> info = taxFileOpContext.getInfo(infoService.entityNumber());
                if (!CollectionUtils.isEmpty(info)) {
                    taxFileTemp = Maps.newHashMap((Map)taxFileMapOld);
                    taxFileTemp.keySet().removeAll(info.keySet());
                } else {
                    taxFileTemp = taxFileMapOld;
                }
                if (ArrayUtils.isEmpty((Object[])(infoArr = infoService.findInfo(taxFileTemp, taxFileOpContext)))) continue;
                if (infoService.isSubInfo()) {
                    taxFileOpContext.addExtraInfo((DynamicObject[])infoArr, infoService::getFileId);
                    continue;
                }
                Map<Long, List<Long>> subIdToFile = infoService.subIdToFile(taxFileTemp.values());
                HashMap fileToSub = Maps.newHashMapWithExpectedSize((int)taxFileTemp.size());
                for (Object object : infoArr) {
                    long id = object.getLong("id");
                    List<Long> taxFileIds = subIdToFile.get(id);
                    if (CollectionUtils.isEmpty(taxFileIds)) continue;
                    for (Long taxFileId : taxFileIds) {
                        fileToSub.put(taxFileId, object);
                    }
                }
                taxFileOpContext.addExtraInfo(infoService.entityNumber(), fileToSub);
            }
        }
        if ((extraInfo = taxFileOpContext.getExtraInfo()) == null) {
            return;
        }
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : extraInfo.entrySet()) {
            TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entry.getKey());
            if (infoService == null) continue;
            infoService.gatherInfoFrom(taxFileOpContext, taxFileMap.values().toArray(new DynamicObject[0]), entry.getValue());
        }
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : extraInfo.entrySet()) {
            String entityCode = entry.getKey();
            TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entityCode);
            effectLogger.log("TaxFileInfoServiceFactory validateSubInfo validate start EntityNumber:" + entityCode);
            if (infoService == null) continue;
            Map<Long, DynamicObject> extraMap = entry.getValue();
            effectLogger.start("TaxFileInfoServiceFactory validateSubInfo validate EntityNumber:" + entityCode);
            OperationResult result = infoService.validate(extraMap, taxFileMap, taxFileOpContext);
            effectLogger.end("TaxFileInfoServiceFactory validateSubInfo validate EntityNumber:" + entityCode);
            List validateInfo = result.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)validateInfo)) continue;
            HashMap errorMsgMap = Maps.newHashMapWithExpectedSize((int)validateInfo.size());
            for (IOperateInfo iOperateInfo : validateInfo) {
                StringBuilder msg = errorMsgMap.computeIfAbsent((Long)iOperateInfo.getPkValue(), ky -> new StringBuilder());
                msg.append(iOperateInfo.getMessage());
            }
            for (Map.Entry entry2 : errorMsgMap.entrySet()) {
                Object object;
                object = extraMap.get(taxFileOpContext.getFileId(entityCode, (Long)entry2.getKey()));
                taxFileOpContext.taxFileFail(infoService.getFileId((DynamicObject)object), ((StringBuilder)entry2.getValue()).toString());
                LOGGER.info("by cyh validateSubInfo {}  error msg {}", (Object)entityCode, entry2.getValue());
            }
        }
        effectLogger.end("TaxFileInfoServiceFactory validateSubInfo");
    }

    public static void invokeSubInfoOp(DynamicObject[] taxFiles, TaxFileOpContext taxFileOpContext) {
        EffectLogger effectLogger = new EffectLogger("taxfile import", "TaxFileInfoServiceFactory", LOGGER);
        effectLogger.start("TaxFileInfoServiceFactory invokeSubInfoOp");
        if (ArrayUtils.isEmpty((Object[])taxFiles)) {
            return;
        }
        Map<String, Map<Long, DynamicObject>> extraInfo = taxFileOpContext.getExtraInfo();
        if (extraInfo == null) {
            return;
        }
        String mainEntity = taxFiles[0].getDataEntityType().getName();
        Map<Long, DynamicObject> remove = extraInfo.remove(mainEntity);
        if (CollectionUtils.isEmpty(extraInfo)) {
            return;
        }
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : extraInfo.entrySet()) {
            String entityCode = entry.getKey();
            TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entityCode);
            effectLogger.log("TaxFileInfoServiceFactory invokeSubInfoOp start entityCode\uff1a" + entityCode);
            if (infoService == null || CollectionUtils.isEmpty(entry.getValue())) continue;
            int size = entry.getValue().size();
            effectLogger.start("TaxFileInfoServiceFactory invokeSubInfoOp operate entityCode\uff1a" + entityCode + " size = " + size);
            OperationResult result = infoService.operate(entry.getValue(), taxFiles, taxFileOpContext);
            effectLogger.end("TaxFileInfoServiceFactory invokeSubInfoOp operate entityCode\uff1a" + entityCode + " size = " + size);
            List validateInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : validateInfo) {
                LOGGER.info("TaxFileInfoServiceFactory invokeSubInfoOp operate result :{} entityCode:{}", (Object)info.getMessage(), (Object)entityCode);
            }
        }
        if (remove != null) {
            extraInfo.put(mainEntity, remove);
        }
        effectLogger.end("TaxFileInfoServiceFactory invokeSubInfoOp");
    }

    public static BaseResult<?> abandonTaxFiles(List<DynamicObject> taxFiles) {
        return TaxFileInfoServiceFactory.doExecute(taxFiles, TaxFileInfoService::abandonByFiles);
    }

    public static BaseResult<?> deleteTaxFiles(List<DynamicObject> taxFiles) {
        return TaxFileInfoServiceFactory.doExecute(taxFiles, TaxFileInfoService::deleteByFiles);
    }

    public static TaxFileInfoService byEntityNumber(String entityNumber) {
        return TAX_FILE_INFO_SERVICE_MAP.get(entityNumber);
    }

    public static Map<String, Map<String, String>> propGroup(Set<String> props, String appId) {
        Map<String, Pair<String, String>> pairMap = PROP_MAPPING.get(appId);
        if (CollectionUtils.isEmpty(pairMap)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (String prop : props) {
            String second;
            String first;
            int index = prop.indexOf(46);
            if (index > 0) {
                first = prop.substring(0, index);
                second = prop.substring(index);
            } else {
                first = prop;
                second = "";
            }
            Pair<String, String> pair = pairMap.get(first);
            Map propSet = result.computeIfAbsent(pair.getValue(), ky -> new HashMap(16));
            propSet.put(prop, pair.getKey() + second);
        }
        return result;
    }

    static <R> BaseResult<R> doExecute(List<DynamicObject> files, BiFunction<TaxFileInfoService, Map<Long, DynamicObject>, BaseResult<R>> bizFunc) {
        if (CollectionUtils.isEmpty(files)) {
            return BaseResult.success(null);
        }
        Map<String, TaxFileInfoService> taxFileInfoServices = TAX_FILE_INFO_SERVICES_MAP.get(((BasedataEntityType)files.get(0).getDataEntityType()).getAppId());
        if (CollectionUtils.isEmpty(taxFileInfoServices)) {
            return BaseResult.success(null);
        }
        Map<Long, DynamicObject> taxFileMap = files.stream().collect(Collectors.toMap(ele -> ele.getLong("id"), ele -> ele, (k1, k2) -> k1));
        for (Map.Entry<String, TaxFileInfoService> entry : taxFileInfoServices.entrySet()) {
            BaseResult<R> res = bizFunc.apply(entry.getValue(), taxFileMap);
            if (res.isSuccess()) continue;
            return res;
        }
        return BaseResult.success(null);
    }

    public static Map<String, Map<Long, Long>> findLatestVersionByFileBoIdsAndDate(String appId, List<Long> taxFileBoids, Date start, Date end) {
        HashMap versionResult = Maps.newHashMapWithExpectedSize((int)32);
        Map<String, TaxFileInfoService> taxFileInfoServices = TAX_FILE_INFO_SERVICES_MAP.get(appId);
        if (!CollectionUtils.isEmpty(taxFileInfoServices)) {
            for (Map.Entry<String, TaxFileInfoService> entry : taxFileInfoServices.entrySet()) {
                TaxFileInfoService taxFileInfoService = entry.getValue();
                String entityNumber = taxFileInfoService.entityNumber();
                Map<Long, Long> versionMap = taxFileInfoService.findLatestVersionByFileBoIdsAndDate(taxFileBoids, start, end);
                if (CollectionUtils.isEmpty(versionMap)) continue;
                versionResult.put(entityNumber, versionMap);
            }
        }
        return versionResult;
    }

    public static void updateDeclareStatus(String entityNumber, List<DynamicObject> list) {
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entityNumber);
        if (infoService == null || CollectionUtils.isEmpty(list)) {
            return;
        }
    }

    public static Map<Long, DynamicObject> getRelatedInfo(Set<Long> taxFileBoIds, Map<Long, Date> taxFileBoIdAndBsed, String entityNumber, String relateEntityNumber) {
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entityNumber);
        if (infoService == null || CollectionUtils.isEmpty(taxFileBoIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<String, Set<String>> relateEntityNumberMap = infoService.relatedEntityNumber();
        if (CollectionUtils.isEmpty(relateEntityNumberMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Set<String> props = relateEntityNumberMap.get(relateEntityNumber);
        if (CollectionUtils.isEmpty(props)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        TaxFileInfoService relateService = TaxFileInfoServiceFactory.byEntityNumber(relateEntityNumber);
        if (relateService == null) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return relateService.getRelatedInfo(taxFileBoIds, taxFileBoIdAndBsed, props);
    }

    public static Map<Long, DynamicObject> getRelatedInfo(Set<Long> taxFileBoIds, Map<Long, Date> taxFileBoIdAndBsed, String entityNumber, Set<String> props) {
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber(entityNumber);
        if (infoService == null || CollectionUtils.isEmpty(taxFileBoIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return infoService.getRelatedInfo(taxFileBoIds, taxFileBoIdAndBsed, props);
    }

    static {
        ServiceLoader<TaxFileInfoService> load = ServiceLoader.load(TaxFileInfoService.class);
        ArrayList list = new ArrayList(10);
        load.forEach(list::add);
        Collections.sort(list, Comparator.comparingInt(TaxFileInfoService::priority));
        for (TaxFileInfoService next : list) {
            String entityNumber = next.entityNumber();
            TAX_FILE_INFO_SERVICE_MAP.put(entityNumber, next);
            String appId = next.supportAppId();
            Map serviceMap = TAX_FILE_INFO_SERVICES_MAP.computeIfAbsent(appId, key -> new LinkedHashMap(16));
            serviceMap.put(next.generaName(), next);
            Map propMap = PROP_MAPPING.computeIfAbsent(appId, key -> new HashMap(16));
            Map<String, String> mappings = next.propMappings();
            if (CollectionUtils.isEmpty(mappings)) continue;
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                propMap.computeIfAbsent(entry.getKey(), ky -> new Pair(entry.getValue(), entityNumber));
            }
        }
    }
}

