/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.ToLongFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import org.apache.commons.lang.ObjectUtils;

public class TaxFileOpContext {
    private String opKey;
    private Map<String, Map<Long, DynamicObject>> extraInfo;
    private Map<String, Map<Long, Long>> idMapping;
    private Map<Long, Map<String, Object>> keyInfo;
    private Map<Long, String> errorMsg;
    private Map<DynamicObject, Long> idFillMap;
    private Map<String, String> optionParas;
    private Map<String, Set<Long>> keyChange;

    public boolean isFailed(Long taxFileId) {
        return this.errorMsg != null && this.errorMsg.containsKey(taxFileId);
    }

    public boolean isBizKeyChanged(Long taxFileId) {
        return this.keyChange != null && this.keyChange.size() != 0 && this.keyChange.entrySet().iterator().next().getValue().contains(taxFileId);
    }

    public void taxFileFail(Long taxFileId, String message) {
        if (this.errorMsg == null) {
            this.errorMsg = Maps.newHashMapWithExpectedSize((int)16);
        }
        this.errorMsg.put(taxFileId, message);
        if (this.extraInfo == null) {
            return;
        }
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : this.extraInfo.entrySet()) {
            Map<Long, DynamicObject> value = entry.getValue();
            if (value == null) continue;
            value.remove(taxFileId);
        }
    }

    public void addExtraInfo(DynamicObject[] extraInfos) {
        this.addExtraInfo(extraInfos, (DynamicObject info) -> info.getLong("taxfile.id"));
    }

    public void addExtraInfo(DynamicObject[] extraInfos, ToLongFunction<DynamicObject> fileIdFun) {
        if (ArrayUtils.isEmpty((Object[])extraInfos)) {
            return;
        }
        if (this.extraInfo == null) {
            this.extraInfo = Maps.newHashMapWithExpectedSize((int)16);
            this.idMapping = Maps.newHashMapWithExpectedSize((int)16);
        }
        String name = extraInfos[0].getDataEntityType().getName();
        Map infoMap = this.extraInfo.computeIfAbsent(name, ky -> Maps.newHashMapWithExpectedSize((int)extraInfos.length));
        Map idMap = this.idMapping.computeIfAbsent(name, ky -> Maps.newHashMapWithExpectedSize((int)extraInfos.length));
        for (DynamicObject info : extraInfos) {
            infoMap.put(fileIdFun.applyAsLong(info), info);
            idMap.put(info.getLong("id"), fileIdFun.applyAsLong(info));
        }
    }

    public void addExtraInfo(String extraKey, Map<Long, DynamicObject> extraInfos) {
        if (CollectionUtils.isEmpty(extraInfos)) {
            return;
        }
        if (this.extraInfo == null) {
            this.extraInfo = Maps.newHashMapWithExpectedSize((int)16);
            this.idMapping = Maps.newHashMapWithExpectedSize((int)16);
        }
        Map map = this.extraInfo.computeIfAbsent(extraKey, ky -> Maps.newHashMapWithExpectedSize((int)extraInfos.size()));
        map.putAll(extraInfos);
        Map idMap = this.idMapping.computeIfAbsent(extraKey, ky -> Maps.newHashMapWithExpectedSize((int)extraInfos.size()));
        for (Map.Entry<Long, DynamicObject> entry : extraInfos.entrySet()) {
            DynamicObject info = entry.getValue();
            idMap.put(info.getLong("id"), entry.getKey());
        }
    }

    public void fillId(DynamicObject taxFile, Long fileId) {
        if (this.idFillMap == null) {
            this.idFillMap = Maps.newHashMapWithExpectedSize((int)8);
        }
        this.idFillMap.put(taxFile, fileId);
        taxFile.set("id", (Object)fileId);
    }

    public void reMappingFileId() {
        if (CollectionUtils.isEmpty(this.idFillMap)) {
            return;
        }
        for (Map.Entry<DynamicObject, Long> entry : this.idFillMap.entrySet()) {
            Object remove;
            long newFileId = entry.getKey().getLong("id");
            Long oldFileId = entry.getValue();
            if (!ObjectUtils.notEqual((Object)newFileId, (Object)oldFileId)) continue;
            if (this.extraInfo != null) {
                for (Map.Entry<String, Map<Long, DynamicObject>> mapEntry : this.extraInfo.entrySet()) {
                    Map<Long, DynamicObject> value = mapEntry.getValue();
                    DynamicObject suInfo = value.remove(oldFileId);
                    TaxFileInfoServiceFactory.byEntityNumber(mapEntry.getKey()).setFile(suInfo, entry.getKey());
                    value.put(newFileId, suInfo);
                    Map<Long, Long> subInfoIdToFileMap = this.idMapping.get(mapEntry.getKey());
                    subInfoIdToFileMap.put(suInfo.getLong("id"), newFileId);
                }
            }
            if (this.errorMsg != null && (remove = this.errorMsg.remove(oldFileId)) != null) {
                this.errorMsg.put(newFileId, (String)remove);
            }
            if (this.keyInfo == null || (remove = this.keyInfo.remove(oldFileId)) == null) continue;
            this.keyInfo.put(newFileId, (Map<String, Object>)remove);
        }
    }

    public Map<Long, DynamicObject> getInfo(String entityName) {
        if (this.extraInfo == null) {
            return null;
        }
        return this.extraInfo.get(entityName);
    }

    public boolean hasExtraInfo(String entityName, Long taxFileId) {
        if (this.extraInfo == null) {
            return false;
        }
        Map<Long, DynamicObject> info = this.extraInfo.get(entityName);
        if (info == null) {
            return false;
        }
        return info.containsKey(taxFileId);
    }

    public Map<Long, DynamicObject> computeIfAbsent(String entityName, int length) {
        if (this.extraInfo == null) {
            this.extraInfo = Maps.newHashMapWithExpectedSize((int)16);
        }
        return this.extraInfo.computeIfAbsent(entityName, ky -> Maps.newHashMapWithExpectedSize((int)length));
    }

    public Map<Long, Map<String, Object>> computeKeyInfoIfAbsent(int length) {
        if (this.keyInfo == null) {
            this.keyInfo = Maps.newHashMapWithExpectedSize((int)length);
        }
        return this.keyInfo;
    }

    public Map<String, Object> computeKeyInfoOfTaxFileIfAbsent(long taxFileId) {
        return this.computeKeyInfoIfAbsent(16).computeIfAbsent(taxFileId, ky -> Maps.newHashMapWithExpectedSize((int)16));
    }

    public Long getFileId(String entityName, Long subInfoId) {
        if (this.idMapping == null) {
            return null;
        }
        Map<Long, Long> map = this.idMapping.get(entityName);
        return map == null ? null : map.get(subInfoId);
    }

    public String getOptionPara(String key) {
        if (this.optionParas == null) {
            return null;
        }
        return this.optionParas.get(key);
    }

    public void putOptionPara(String key, String value) {
        if (this.optionParas == null) {
            this.optionParas = Maps.newHashMapWithExpectedSize((int)16);
        }
        this.optionParas.put(key, value);
    }

    public Map<String, Map<Long, DynamicObject>> getExtraInfo() {
        return this.extraInfo;
    }

    public Map<Long, String> getErrorMsg() {
        return this.errorMsg;
    }

    public String getOpKey() {
        return this.opKey;
    }

    public void setOpKey(String opKey) {
        this.opKey = opKey;
    }

    public Map<String, Set<Long>> getKeyChange() {
        return this.keyChange;
    }

    public void setKeyChange(Map<String, Set<Long>> keyChange) {
        this.keyChange = keyChange;
    }
}

