/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.entity.CalRuleEntity;
import kd.sit.sitbp.common.entity.CurrencyEntity;
import kd.sit.sitbp.common.entity.TaxCalFormulaEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.accumulator.AccumulatorInfo;
import kd.sit.sitbp.common.model.ApiParam;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.IntStringKeyValue;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.StringMapKeyValue;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxRawDataBatch
extends ApiParam {
    private static final long serialVersionUID = -3391441088253716285L;
    private String calTaskNumber;
    private String calTaskName;
    private Long rawTaskId;
    private int totalBatch;
    private CurrencyEntity currency;
    private CurrencyEntity rawCurrency;
    private BigDecimal currencyRateFromRaw;
    private Date payDate;
    private boolean lockTask = true;
    private Map<Long, Long> taxTaskOfTaxUnitMap;
    private Map<Long, TaxTaskEntity> taskEntityMap;
    private Map<Long, TaxItemEntity> itemEntityMap;
    private Map<Long, CalRuleEntity> calRuleEntityMap;
    private Map<Long, TaxCalFormulaEntity> taxItemFormulaMap;
    private Map<Long, AccumulatorInfo> accInfoMap;
    private Map<Long, String> dataKeyOfTaxFile;
    private Set<Long> newCategories;
    private Map<Long, StringMapKeyValue> taxUnitMap;

    public TaxRawDataBatch() {
        this(16);
    }

    public TaxRawDataBatch(int size) {
        super(size);
    }

    public TaxCalFormulaEntity getFormula(Long formulaId) {
        return this.taxItemFormulaMap.get(formulaId);
    }

    public boolean isCurrencyNeedCovert() {
        return !ObjectUtils.nullSafeEquals((Object)this.currency.getId(), (Object)this.rawCurrency.getId());
    }

    public void taskFail(TaxTaskEntity taskEntity, String message, int status) {
        BaseResult<TaxTaskEntity> result = this.isTaskSuccess(taskEntity.getId());
        if (!result.isSuccess() || result.getData() == null) {
            return;
        }
        taskEntity.getTaxUnitMap().forEach((key, value) -> {
            String taxUnitId = BaseDataConverter.toString(key);
            String taxUnitName = value.localName();
        });
    }

    public Long getTaskIdByUnitId(long taxUnitId) {
        return this.taxTaskOfTaxUnitMap.get(taxUnitId);
    }

    public TaxTaskEntity getTaskById(Long key) {
        return this.taskEntityMap.get(key);
    }

    public BaseResult<TaxTaskEntity> isTaskSuccess(Long taskId) {
        TaxTaskEntity taskEntity = this.taskEntityMap.get(taskId);
        if (taskEntity == null) {
            return BaseResult.fail(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e2a\u7a0e\u4efb\u52a1", (String)"TaxRawDataBatch_0", (String)"sit-sitbp-common", (Object[])new Object[0]));
        }
        Map<String, BizMessage> failBizKeys = this.bizFailMsg();
        if (failBizKeys.isEmpty()) {
            return BaseResult.success(taskEntity);
        }
        IntStringKeyValue message = (IntStringKeyValue)((Object)failBizKeys.get(this.taskBizKey(taskId)));
        if (message == null) {
            return BaseResult.success(taskEntity);
        }
        BaseResult fail = BaseResult.fail((String)message.getValue());
        return fail.ofStatus((Integer)message.getKey());
    }

    public BaseResult<TaxTaskEntity> taskIfUnitSuccess(Long taxUnitId) {
        TaxTaskEntity taskEntity;
        Long taxTaskId = this.taxTaskOfTaxUnitMap.get(taxUnitId);
        if (taxTaskId == null || (taskEntity = this.taskEntityMap.get(taxTaskId)) == null) {
            return BaseResult.fail(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e2a\u7a0e\u4efb\u52a1", (String)"TaxRawDataBatch_0", (String)"sit-sitbp-common", (Object[])new Object[0]));
        }
        Map<String, BizMessage> failBizKeys = this.bizFailMsg();
        IntStringKeyValue message = (IntStringKeyValue)((Object)failBizKeys.get(this.taskBizKey(taxTaskId)));
        if (message == null) {
            return BaseResult.success(taskEntity);
        }
        BaseResult fail = BaseResult.fail((String)message.getValue());
        return fail.ofStatus((Integer)message.getKey()).ofData(taskEntity);
    }

    public CalRuleEntity getCalRuleEntity(Long ruleId) {
        return this.calRuleEntityMap == null ? null : this.calRuleEntityMap.get(ruleId);
    }

    public String getDataKey(Long taxFileId) {
        if (this.dataKeyOfTaxFile == null) {
            return null;
        }
        return this.dataKeyOfTaxFile.get(taxFileId);
    }

    private String taskBizKey(Long taskId) {
        return "TK" + taskId;
    }

    public synchronized void addNewCat(Collection<Long> cats) {
        if (this.newCategories == null) {
            this.newCategories = Sets.newHashSetWithExpectedSize((int)cats.size());
        }
        this.newCategories.addAll(cats);
    }

    public int yearMonth() {
        return SitDateUtil.toYearMonth(this.payDate);
    }

    public String taxUnitName(Long taxUnitId) {
        StringMapKeyValue keyValue;
        if (this.taxUnitMap == null || (keyValue = this.taxUnitMap.get(taxUnitId)) == null) {
            return taxUnitId + "";
        }
        return keyValue.getValueInLocal().toString();
    }

    public String getCalTaskNumber() {
        return this.calTaskNumber;
    }

    public void setCalTaskNumber(String calTaskNumber) {
        this.calTaskNumber = calTaskNumber;
    }

    public String getCalTaskName() {
        return this.calTaskName;
    }

    public void setCalTaskName(String calTaskName) {
        this.calTaskName = calTaskName;
    }

    public Long getRawTaskId() {
        return this.rawTaskId;
    }

    public void setRawTaskId(Long rawTaskId) {
        this.rawTaskId = rawTaskId;
    }

    public int getTotalBatch() {
        return this.totalBatch;
    }

    public void setTotalBatch(int totalBatch) {
        this.totalBatch = totalBatch;
    }

    public CurrencyEntity getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEntity currency) {
        this.currency = currency;
    }

    public CurrencyEntity getRawCurrency() {
        return this.rawCurrency;
    }

    public void setRawCurrency(CurrencyEntity rawCurrency) {
        this.rawCurrency = rawCurrency;
    }

    public BigDecimal getCurrencyRateFromRaw() {
        return this.currencyRateFromRaw;
    }

    public void setCurrencyRateFromRaw(BigDecimal currencyRateFromRaw) {
        this.currencyRateFromRaw = currencyRateFromRaw;
    }

    public Date getPayDate() {
        return this.payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public Map<Long, Long> getTaxTaskOfTaxUnitMap() {
        return this.taxTaskOfTaxUnitMap;
    }

    public void setTaxTaskOfTaxUnitMap(Map<Long, Long> taxTaskOfTaxUnitMap) {
        this.taxTaskOfTaxUnitMap = taxTaskOfTaxUnitMap;
    }

    public Map<Long, TaxTaskEntity> getTaskEntityMap() {
        return this.taskEntityMap;
    }

    public void setTaskEntityMap(Map<Long, TaxTaskEntity> taskEntityMap) {
        this.taskEntityMap = taskEntityMap;
    }

    public Map<Long, TaxItemEntity> getItemEntityMap() {
        return this.itemEntityMap;
    }

    public void setItemEntityMap(Map<Long, TaxItemEntity> itemEntityMap) {
        this.itemEntityMap = itemEntityMap;
    }

    public Map<Long, CalRuleEntity> getCalRuleEntityMap() {
        return this.calRuleEntityMap;
    }

    public void setCalRuleEntityMap(Map<Long, CalRuleEntity> calRuleEntityMap) {
        this.calRuleEntityMap = calRuleEntityMap;
    }

    public Map<Long, TaxCalFormulaEntity> getTaxItemFormulaMap() {
        return this.taxItemFormulaMap == null ? (this.taxItemFormulaMap = Maps.newHashMap()) : this.taxItemFormulaMap;
    }

    public void setTaxItemFormulaMap(Map<Long, TaxCalFormulaEntity> taxItemFormulaMap) {
        this.taxItemFormulaMap = taxItemFormulaMap;
    }

    public Map<Long, AccumulatorInfo> getAccInfoMap() {
        return this.accInfoMap;
    }

    public void setAccInfoMap(Map<Long, AccumulatorInfo> accInfoMap) {
        this.accInfoMap = accInfoMap;
    }

    public Map<Long, String> getDataKeyOfTaxFile() {
        return this.dataKeyOfTaxFile;
    }

    public void setDataKeyOfTaxFile(Map<Long, String> dataKeyOfTaxFile) {
        this.dataKeyOfTaxFile = dataKeyOfTaxFile;
    }

    public synchronized void setNewCategories(Set<Long> newCategories) {
        this.newCategories = newCategories;
    }

    public synchronized Set<Long> getNewCategories() {
        return this.newCategories;
    }

    public boolean isLockTask() {
        return this.lockTask;
    }

    public void setLockTask(boolean lockTask) {
        this.lockTask = lockTask;
    }

    public Map<Long, StringMapKeyValue> getTaxUnitMap() {
        return this.taxUnitMap;
    }

    public void setTaxUnitMap(Map<Long, StringMapKeyValue> taxUnitMap) {
        this.taxUnitMap = taxUnitMap;
    }
}

