/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.model.algo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.model.algo.SplitInfo;

public class TaxDataDynObjWrapper {
    private DynamicObject data;
    private Map<Long, DynamicObject> entryMap;
    private String netTaxAlgo;
    private SplitInfo splitInfo;

    public TaxDataDynObjWrapper(DynamicObject data) {
        this.data = data;
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
        this.entryMap = new HashMap<Long, DynamicObject>(entrys.size());
        if (!CollectionUtils.isEmpty((Collection)entrys)) {
            for (DynamicObject obj : entrys) {
                Object taxItem = obj.get("taxitem");
                if (taxItem instanceof DynamicObject) {
                    this.entryMap.put(((DynamicObject)taxItem).getLong("id"), obj);
                    continue;
                }
                this.entryMap.put((Long)taxItem, obj);
            }
        }
    }

    public DynamicObject getData() {
        return this.data;
    }

    public void setData(DynamicObject data) {
        this.data = data;
    }

    public Map<Long, DynamicObject> getEntryMap() {
        return this.entryMap;
    }

    public void setEntryMap(Map<Long, DynamicObject> entryMap) {
        this.entryMap = entryMap;
    }

    public DynamicObject getEntry(Long taxItemId) {
        return this.entryMap.get(taxItemId);
    }

    public DynamicObject addNewEntry(String fieldName, Long value) {
        DynamicObjectCollection srcDataItems = this.data.getDynamicObjectCollection("entryentity");
        DynamicObject entry = srcDataItems.addNew();
        entry.set(fieldName, (Object)value);
        this.entryMap.put(value, entry);
        return entry;
    }

    public String getNetTaxAlgo() {
        return this.netTaxAlgo;
    }

    public void setNetTaxAlgo(String netTaxAlgo) {
        this.netTaxAlgo = netTaxAlgo;
    }

    public SplitInfo getSplitInfo() {
        return this.splitInfo;
    }

    public void setSplitInfo(SplitInfo splitInfo) {
        this.splitInfo = splitInfo;
    }
}

