/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.stream;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;

public class StreamUtil {
    private static final Log LOGGER = LogFactory.getLog(StreamUtil.class);

    private StreamUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(String fileName, InputStream inStream) {
        String string;
        try {
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inStream, 10000);
        }
        catch (Exception e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely(inStream);
                throw throwable;
            }
            StreamUtil.closeSafely(inStream);
            return string2;
        }
        StreamUtil.closeSafely(inStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeFile(String fileName, InputStream inStream) {
        String string;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"taxDataInGuide", (String)fileName);
            FileItem item = new FileItem(fileName, pathParam, inStream);
            String path = fileService.upload(item);
            string = UrlService.getAttachmentFullUrl((String)path);
        }
        catch (Exception e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely(inStream);
                throw throwable;
            }
            StreamUtil.closeSafely(inStream);
            return string2;
        }
        StreamUtil.closeSafely(inStream);
        return string;
    }

    public static void closeSafely(OutputStream ... oses) {
        if (oses != null) {
            for (OutputStream os : oses) {
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeSafely(InputStream ... ins) {
        if (ins != null) {
            for (InputStream in : ins) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeSafely(OutputStream os, InputStream in) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

