/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataRefCheckUtil {
    private BaseDataRefCheckUtil() {
    }

    public static Map<ExtendedDataEntity, String> getErrDataEntityAndMsgMap(ExtendedDataEntity[] dataEntities, String errInfo) {
        HashMap<ExtendedDataEntity, String> errDataEntityAndMsgMap = new HashMap<ExtendedDataEntity, String>(dataEntities.length);
        List pkIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType();
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        HashMap<Long, Set> pkIdAndRefEntityKeyMap = new HashMap<Long, Set>(16);
        HashMap<String, String> refEntityKeyAndNameMap = new HashMap<String, String>(16);
        for (Long pkId : pkIds) {
            List allRefsForCurrBaseData = checker.getAllRefs(basedataEntityType, (Object)pkId);
            for (BaseDataRefenceKey refenceKey : allRefsForCurrBaseData) {
                String refEntityKey = refenceKey.getRefEntityKey();
                if (HRStringUtils.isEmpty((String)refEntityKey)) continue;
                Set currRefEntityNameSet = pkIdAndRefEntityKeyMap.computeIfAbsent(Long.valueOf(String.valueOf(pkId)), key -> new LinkedHashSet(16));
                String refEntityName = (String)refEntityKeyAndNameMap.get(refEntityKey);
                if (refEntityName == null) {
                    MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refEntityKey);
                    refEntityName = refMainType.getDisplayName().toString();
                    refEntityKeyAndNameMap.put(refEntityKey, refEntityName);
                }
                currRefEntityNameSet.add(refEntityName);
            }
        }
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            Object pkId = dataEntity2.getDataEntity().get("id");
            Set currRefEntityNameSet = (Set)pkIdAndRefEntityKeyMap.get(pkId);
            if (CollectionUtils.isEmpty((Collection)currRefEntityNameSet)) continue;
            StringJoiner refEntityNames = new StringJoiner(",");
            currRefEntityNameSet.forEach(refEntityNames::add);
            errDataEntityAndMsgMap.put(dataEntity2, MessageFormat.format(errInfo, refEntityNames.toString()));
        }
        return errDataEntityAndMsgMap;
    }
}

