/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.sit.sitbp.common.enums.ResultStatusEnum;

public class BaseResult<T> {
    public static final String PROP_SUCCESS = "success";
    public static final String PROP_STATUS = "status";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_DATA = "data";
    private boolean success;
    private int status;
    private String message;
    private T data;

    public BaseResult(boolean success, T data, String message) {
        this.success = success;
        this.data = data;
        this.message = message;
    }

    public static <T, P> BaseResult<T> fromPrev(BaseResult<P> prev) {
        BaseResult<Object> result = new BaseResult<Object>(prev.isSuccess(), null, prev.getMessage());
        return result.ofStatus(prev.getStatus());
    }

    public static <T> BaseResult<T> fromException(Exception ex) {
        BaseResult<Object> result = new BaseResult<Object>(false, null, ex.getMessage());
        result.ofStatus(ResultStatusEnum.ERROR.getCode());
        return result;
    }

    public static Map<String, Object> packageResult(boolean success, int status, String message, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(PROP_SUCCESS, success);
        result.put(PROP_STATUS, status);
        result.put(PROP_MESSAGE, message);
        if (data != null) {
            result.put(PROP_DATA, JSON.toJSON((Object)data));
        }
        return result;
    }

    public Map<String, Object> toMap(boolean withData) {
        return BaseResult.packageResult(this.isSuccess(), this.getStatus(), this.getMessage(), withData ? this.getData() : null);
    }

    public Map<String, Object> toMap(ObjToMap<T> objToMap) {
        return BaseResult.packageResult(this.isSuccess(), this.getStatus(), this.getMessage(), objToMap == null ? null : objToMap.toMap(this.getData()));
    }

    public static <T> BaseResult<T> success(T data) {
        return new BaseResult<T>(true, data, null).ofStatus(ResultStatusEnum.DEBUG.getCode());
    }

    public static <T> BaseResult<T> fail(String message) {
        BaseResult<Object> objectBaseResult = new BaseResult<Object>(false, null, message);
        return objectBaseResult.ofStatus(ResultStatusEnum.ERROR.getCode());
    }

    public BaseResult<T> ofStatus(int status) {
        this.setStatus(status);
        return this;
    }

    public BaseResult<T> ofMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public boolean isFailForUnKnown() {
        return this.status < ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isEqualSuccess() {
        return this.status < ResultStatusEnum.INFO.getCode() && this.status >= ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isContinue() {
        return this.status < ResultStatusEnum.ERROR.getCode();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public BaseResult<T> ofData(T data) {
        this.data = data;
        return this;
    }

    public static interface ObjToMap<T> {
        public Object toMap(T var1);
    }
}

