/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.ResultItem;

public class BatchResult<T>
implements Serializable {
    private static final long serialVersionUID = -4031727822068420129L;
    public static final int DATA_CASE_NONE = 0;
    public static final int DATA_CASE_SUCCESS = 1;
    public static final int DATA_CASE_FAIL = 2;
    public static final int DATA_CASE_ALL = 3;
    private boolean success;
    private int status;
    private String message;
    private List<T> successResult;
    private List<ResultItem<T>> failResult;

    public BatchResult(boolean success, List<T> dataList) {
        this.success = success;
        if (success) {
            this.successResult = dataList == null ? new ArrayList(0) : dataList;
            this.failResult = new ArrayList<ResultItem<T>>(0);
            this.status = ResultStatusEnum.INFO.getCode();
        } else {
            this.failResult = dataList == null ? new ArrayList(0) : ResultItem.wrap(dataList, "");
            this.successResult = new ArrayList<T>(0);
        }
    }

    public BatchResult(List<T> successResult, List<T> failResult) {
        this.success = true;
        this.successResult = successResult == null ? new ArrayList() : successResult;
        this.failResult = failResult == null ? new ArrayList() : ResultItem.wrap(failResult, "");
    }

    public void addFailItem(T ele, String message) {
        this.addFailItem(ele, message, ResultStatusEnum.ERROR.getCode());
    }

    public void addFailItem(T ele, String message, int status) {
        this.failResult.add(new ResultItem<T>(ele, message, status));
        if (status > this.status) {
            this.status = status;
        }
    }

    public void addFailItem(T ele, StatusInfo status, Object ... params) {
        this.failResult.add(new ResultItem<T>(ele, status.loadKDString(params), status.getStatus()));
        if (status.getStatus() > this.status) {
            this.status = status.getStatus();
        }
    }

    public BatchResult<T> ofFailResult(List<T> failResult, String message) {
        this.failResult = ResultItem.wrap(failResult, message);
        return this;
    }

    public static <T> BatchResult<T> fromBaseResult(BaseResult<?> baseResult) {
        BatchResult<T> result = new BatchResult<T>(baseResult.isSuccess(), null);
        result.setMessage(baseResult.getMessage());
        result.setStatus(baseResult.getStatus());
        return result.addBaseResult(baseResult);
    }

    public BatchResult<T> addBaseResult(BaseResult<?> baseResult) {
        ArrayList list = null;
        Object data = baseResult.getData();
        if (data instanceof List) {
            list = (ArrayList)data;
        } else if (data instanceof Collection) {
            list = new ArrayList((Collection)data);
        } else if (data != null) {
            list = new ArrayList(1);
            list.add(data);
        }
        if (list != null) {
            if (baseResult.isSuccess()) {
                this.addSuccessResult(list);
            } else {
                this.addFailResult(list, baseResult.getMessage(), baseResult.getStatus());
            }
        }
        return this;
    }

    public BatchResult<T> addSuccessResult(T ele) {
        this.successResult.add(ele);
        return this;
    }

    public BatchResult<T> addSuccessResult(List<T> list) {
        this.successResult.addAll(list);
        return this;
    }

    public BatchResult<T> addFailResult(List<T> list, String message, int status) {
        for (T ele : list) {
            this.failResult.add(new ResultItem<T>(ele, message, status));
        }
        return this;
    }

    public void successItemToFail(T ele, String message) {
        boolean remove = this.successResult.remove(ele);
        if (remove) {
            this.addFailItem(ele, message);
        }
    }

    public void successItemToFail(T ele, int status, String message) {
        boolean remove = this.successResult.remove(ele);
        if (remove) {
            this.addFailItem(ele, message, status);
        }
    }

    public void successItemToFail(T ele, StatusInfo statusInfo) {
        boolean remove = this.successResult.remove(ele);
        if (remove) {
            this.addFailItem(ele, statusInfo.getMessage(), statusInfo.getStatus());
        }
    }

    public void successItemToFail(T ele, StatusInfo statusInfo, Object[] params) {
        boolean remove = this.successResult.remove(ele);
        if (remove) {
            this.addFailItem(ele, statusInfo.loadKDString(params), statusInfo.getStatus());
        }
    }

    public BatchResult<T> successToFail(String message, boolean messageToItem) {
        this.setSuccess(false);
        for (T ele : this.successResult) {
            this.addFailItem(ele, messageToItem ? message : null);
        }
        this.successResult.clear();
        return this;
    }

    public Map<String, Object> toMap(boolean withData) {
        ObjToMap<Object> objToMap = null;
        if (withData) {
            objToMap = ele -> (Map)JSON.toJSON((Object)ele);
        }
        return this.toMap(objToMap, 3, false);
    }

    public Map<String, Object> toMap(boolean withData, boolean convertRes) {
        ObjToMap<Object> objToMap = null;
        if (withData) {
            objToMap = ele -> (Map)JSON.toJSON((Object)ele);
        }
        return this.toMap(objToMap, 3, convertRes);
    }

    public Map<String, Object> toMap(ObjToMap<T> objToMap, int dataCase, boolean convertRes) {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        res.put("success", convertRes ? this.isContinue() : this.success);
        res.put("status", this.status);
        res.put("message", this.message);
        if (objToMap != null) {
            Map<String, Object> map;
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(this.successResult.size() + this.failResult.size());
            if ((dataCase | 1) > 0 && !CollectionUtils.isEmpty(this.successResult)) {
                for (T t : this.successResult) {
                    map = objToMap.toMap(t);
                    map.put("success", Boolean.TRUE);
                    data.add(map);
                }
            }
            if ((dataCase | 2) > 0 && !CollectionUtils.isEmpty(this.failResult)) {
                for (ResultItem resultItem : this.failResult) {
                    map = objToMap.toMap(resultItem.getData());
                    if (convertRes) {
                        map.put("success", resultItem.getStatus() < ResultStatusEnum.ERROR.getCode());
                    } else {
                        map.put("success", Boolean.FALSE);
                    }
                    if (!StringUtils.isEmpty((Object)resultItem.getMessage())) {
                        map.put("message", resultItem.getMessage());
                    }
                    map.put("status", resultItem.getStatus());
                    data.add(map);
                }
            }
            res.put("data", data);
        }
        return res;
    }

    public Map<Integer, List<T>> failDataGroupByStatus() {
        HashMap<Integer, List<T>> result = new HashMap<Integer, List<T>>(8);
        for (ResultItem<T> item : this.failResult) {
            List ts = result.computeIfAbsent(item.getStatus(), ky -> new ArrayList());
            ts.add(item.getData());
        }
        return result;
    }

    public Map<String, List<T>> failDataGroupByMsg() {
        HashMap<String, List<T>> result = new HashMap<String, List<T>>(8);
        for (ResultItem<T> item : this.failResult) {
            List ts = result.computeIfAbsent(item.getMessage(), ky -> new ArrayList());
            ts.add(item.getData());
        }
        return result;
    }

    public boolean isFailForUnKnown() {
        return this.status < ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isEqualSuccess() {
        return this.status < ResultStatusEnum.INFO.getCode() && this.status >= ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isContinue() {
        return this.success || this.status < ResultStatusEnum.ERROR.getCode();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public BatchResult<T> ofSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public BatchResult<T> ofStatus(int status) {
        this.setStatus(status);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BatchResult<T> ofMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<T> getSuccessResult() {
        return this.successResult;
    }

    public void setSuccessResult(List<T> successResult) {
        this.successResult = successResult;
    }

    public List<T> getFailResult() {
        return ResultItem.unwrap(this.failResult);
    }

    public List<ResultItem<T>> getFailResultOriginal() {
        return this.failResult;
    }

    public void setFailResult(List<T> failResult) {
        this.failResult = ResultItem.wrap(failResult, "");
    }

    public List<T> successResult() {
        ArrayList<T> result = new ArrayList<T>(this.successResult);
        for (ResultItem<T> item : this.failResult) {
            if (ResultStatusEnum.ERROR.getCode() <= item.getStatus()) continue;
            result.add(item.getData());
        }
        return result;
    }

    public List<T> failResult() {
        ArrayList<T> result = new ArrayList<T>(this.failResult.size());
        for (ResultItem<T> item : this.failResult) {
            if (ResultStatusEnum.ERROR.getCode() > item.getStatus()) continue;
            result.add(item.getData());
        }
        return result;
    }

    public void merge(BatchResult<T> result) {
        if (!result.isSuccess()) {
            this.setSuccess(false);
        }
        if (result.getStatus() > this.getStatus()) {
            this.setStatus(result.getStatus());
        }
        if (StringUtils.isEmpty((Object)result.getMessage())) {
            this.message = this.message == null ? result.getMessage() : this.message + result.getMessage();
        }
        this.getSuccessResult().addAll(result.getSuccessResult());
        this.getFailResultOriginal().addAll(result.getFailResultOriginal());
    }

    public String messageFromRight(int length) {
        if (!StringUtils.isEmpty((Object)this.message)) {
            if (this.message.length() > length) {
                return this.message.substring(this.message.length() - length);
            }
            return this.message;
        }
        for (ResultItem<T> item : this.failResult) {
            if (StringUtils.isEmpty((Object)item.getMessage())) continue;
            return item.getMessage();
        }
        return null;
    }

    public static interface ObjToMap<T> {
        public Map<String, Object> toMap(T var1);
    }
}

