/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.api.BizService;

public class BizServiceFactory {
    private static final Map<String, BizService> SERVICE_MAP_OF_NAME = new HashMap<String, BizService>();
    private static final Map<Class<? extends BizService>, Map<String, BizService>> SERVICE_MAP_OF_CLASS = new ConcurrentHashMap<Class<? extends BizService>, Map<String, BizService>>();

    public static <T extends BizService> T lookup(Class<T> clazz) {
        Map<String, BizService> serviceMap = SERVICE_MAP_OF_CLASS.get(clazz);
        if (CollectionUtils.isEmpty(serviceMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"BizServiceFactory_1", (String)"sit-sitcs-business", (Object[])new Object[]{clazz}));
        }
        if (serviceMap.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u627e\u5230{1}\u4e2a\uff0c\u8bf7\u6307\u5b9a\u540d\u79f0", (String)"BizServiceFactory_2", (String)"sit-sitcs-business", (Object[])new Object[]{clazz, serviceMap.size()}));
        }
        return (T)serviceMap.entrySet().iterator().next().getValue();
    }

    public static <T> T lookup(String serviceName) {
        BizService bizService = SERVICE_MAP_OF_NAME.get(serviceName);
        if (bizService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"BizServiceFactory_0", (String)"sit-sitcs-business", (Object[])new Object[]{serviceName}));
        }
        return (T)bizService;
    }

    private static List<Class<? extends BizService>> bizServiceClassListOf(BizService bizService) {
        ArrayList<Class<? extends BizService>> result = new ArrayList<Class<? extends BizService>>(4);
        BizServiceFactory.collectBizService(bizService.getClass().getGenericInterfaces(), result);
        return result;
    }

    private static void collectBizService(Type[] genericInterfaces, List<Class<? extends BizService>> result) {
        if (ArrayUtils.isEmpty((Object[])genericInterfaces)) {
            return;
        }
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof Class) || genericInterface == BizService.class) continue;
            Class clazz = (Class)genericInterface;
            if (BizService.class.isAssignableFrom(clazz)) {
                result.add(clazz);
            }
            BizServiceFactory.collectBizService(clazz.getGenericInterfaces(), result);
        }
    }

    static {
        ServiceLoader<BizService> services = ServiceLoader.load(BizService.class);
        for (BizService next : services) {
            SERVICE_MAP_OF_NAME.put(next.name(), next);
            List<Class<? extends BizService>> classes = BizServiceFactory.bizServiceClassListOf(next);
            if (CollectionUtils.isEmpty(classes)) continue;
            for (Class<? extends BizService> clazz : classes) {
                Map serviceMap = SERVICE_MAP_OF_CLASS.computeIfAbsent(clazz, key -> new ConcurrentHashMap());
                serviceMap.put(next.name(), next);
            }
        }
    }
}

