/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.common.model.DimValueResult;
import kd.sit.sitbp.common.entity.TaxCalItemEntity;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import org.apache.commons.collections.CollectionUtils;

public class FormulaCalUtils {
    private static Log logger = LogFactory.getLog(FormulaCalUtils.class);
    private static String ENTITYNUMBER = "bos_org,bd_admindivision,bd_bebank";
    private static String ITC_TAXFILE = "itc_taxfile";

    public static TaxCalItemEntity getCalDataType(String metaTag, String fields, Long country, String appId) {
        TaxCalItemEntity taxCalItemEntity = new TaxCalItemEntity();
        FormulaCalUtils.assembleCalVO(metaTag, fields, taxCalItemEntity, false, country, appId);
        return taxCalItemEntity;
    }

    public static CalItemVO getCalItemVO(String metaTag, String fields, Map<String, MainEntityType> typeMap) {
        return FormulaCalUtils.assembleCalVO(metaTag, fields, typeMap, false);
    }

    private static CalItemVO assembleCalVO(String metaTag, String fields, Map<String, MainEntityType> typeMap, boolean isBasedataType) {
        MainEntityType mainEntityType = typeMap.computeIfAbsent(metaTag, key -> MetadataServiceHelper.getDataEntityType((String)metaTag));
        int index = fields.indexOf(46);
        if (index < 0) {
            Object property = mainEntityType.getAllFields().get(fields);
            CalItemVO calItemVO = new CalItemVO();
            if (property instanceof BasedataProp) {
                calItemVO.setDataType(DataTypeEnum.BASE);
            } else if (property instanceof TextProp) {
                calItemVO.setName(((TextProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.TEXT);
                calItemVO.setDataLength(Integer.valueOf(((TextProp)property).getMaxLenth()));
                if (isBasedataType) {
                    calItemVO.setDataType(DataTypeEnum.BASE);
                }
            } else if (property instanceof IntegerProp) {
                calItemVO.setName(((IntegerProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((IntegerProp)property).getScale()));
            } else if (property instanceof BigIntProp) {
                calItemVO.setName(((BigIntProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((BigIntProp)property).getScale()));
            } else if (property instanceof DecimalProp) {
                calItemVO.setName(((DecimalProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.NUM);
                calItemVO.setScale(Integer.valueOf(((DecimalProp)property).getScale()));
            } else if (property instanceof DateTimeProp) {
                calItemVO.setName(((DateTimeProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.DATE);
            } else if (property instanceof BooleanProp) {
                calItemVO.setName(((BooleanProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.BOOLEAN);
            } else if (property instanceof ComboProp) {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            } else {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            }
            return calItemVO;
        }
        Object property = mainEntityType.getAllFields().get(fields.substring(0, index));
        if (property instanceof BasedataProp) {
            return FormulaCalUtils.assembleCalVO(((BasedataProp)property).getBaseEntityId(), fields.substring(index + 1), typeMap, true);
        }
        return new CalItemVO();
    }

    private static void assembleCalVO(String metaTag, String fields, TaxCalItemEntity taxCalItemEntity, boolean isBasedataType, Long country, String appId) {
        String[] str = fields.split("[.]");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)metaTag);
        Object property = mainEntityType.getAllFields().get(str[0]);
        if (str.length == 1) {
            CalItemVO calItemVO = new CalItemVO();
            if (property instanceof BasedataProp) {
                calItemVO.setDataType(DataTypeEnum.BASE);
                taxCalItemEntity.setItemType(CalItemTypeEnum.BASE_DATA);
                taxCalItemEntity.setEntityNumber(((BasedataProp)property).getBaseEntityId());
                taxCalItemEntity.setPropertyField("name");
            } else if (property instanceof TextProp) {
                calItemVO.setName(((TextProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.TEXT);
                calItemVO.setDataLength(Integer.valueOf(((TextProp)property).getMaxLenth()));
                if (isBasedataType) {
                    calItemVO.setDataType(DataTypeEnum.BASE);
                    taxCalItemEntity.setItemType(CalItemTypeEnum.BASE_DATA);
                    taxCalItemEntity.setEntityNumber(mainEntityType.getName());
                    taxCalItemEntity.setPropertyField(fields);
                    FormulaCalUtils.getCountryQfilter(taxCalItemEntity, mainEntityType.getName(), country, appId);
                }
            } else if (property instanceof IntegerProp) {
                calItemVO.setName(((IntegerProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((IntegerProp)property).getScale()));
            } else if (property instanceof BigIntProp) {
                calItemVO.setName(((BigIntProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((BigIntProp)property).getScale()));
            } else if (property instanceof DecimalProp) {
                calItemVO.setName(((DecimalProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.NUM);
                calItemVO.setScale(Integer.valueOf(((DecimalProp)property).getScale()));
            } else if (property instanceof DateTimeProp) {
                calItemVO.setName(((DateTimeProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.DATE);
            } else if (property instanceof BooleanProp) {
                calItemVO.setName(((BooleanProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.BOOLEAN);
            } else if (property instanceof ComboProp) {
                calItemVO.setDataType(DataTypeEnum.TEXT);
                taxCalItemEntity.setItemType(CalItemTypeEnum.ENUM);
                taxCalItemEntity.setEntityNumber(mainEntityType.getName());
                taxCalItemEntity.setPropertyField(fields);
            } else {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            }
            taxCalItemEntity.setCalItemVO(calItemVO);
        } else if (property instanceof BasedataProp) {
            FormulaCalUtils.assembleCalVO(((BasedataProp)property).getBaseEntityId(), fields.substring(str[0].length() + 1, fields.length()), taxCalItemEntity, true, country, appId);
        }
    }

    private static void getCountryQfilter(TaxCalItemEntity taxCalItemEntity, String entityNumber, Long country, String appId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        if (ENTITYNUMBER.contains(entityNumber)) {
            qFilter.and("country", "=", (Object)country);
        } else if ("bd_country".equals(entityNumber)) {
            qFilter.and("id", "=", (Object)country);
        } else if ("hbss_taxunit".equals(entityNumber)) {
            qFilter.and("admindivision.country", "=", (Object)country);
        }
        filterList.add(qFilter);
        if (entityNumber.equals("hbss_taxunit")) {
            Set<Long> set = FormulaCalUtils.getTaxUnitSetByPermItem("17/+CT1QBPNP");
            logger.info("FormulaCalUtils.getTaxUnitSetByPermItem set : {} ", set);
            if (!CollectionUtils.isEmpty(set)) {
                filterList.add(new QFilter("id", "in", set));
            }
        } else if (entityNumber.equals("hbss_empgroup")) {
            Set<Long> set = FormulaCalUtils.getEmpgrpSetByPermItem("17/+CT1QBPNP");
            logger.info("FormulaCalUtils.getEmpgrpSetByPermItem set : {} ", set);
            if (!CollectionUtils.isEmpty(set)) {
                filterList.add(new QFilter("id", "in", set));
            }
        } else if (entityNumber.equals("bos_org")) {
            HasPermOrgResult permOrgs = FormulaCalUtils.getPermOrgs("17/+CT1QBPNP");
            logger.info("FormulaCalUtils.getCountryQfilter.permOrgs.hasAllOrgPerm: {} - {}", (Object)permOrgs.hasAllOrgPerm(), (Object)permOrgs.getHasPermOrgs());
            if (!permOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrgs.getHasPermOrgs())) {
                filterList.add(new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
        }
        logger.info("FormulaCalUtils.allCountryQfilter: {} ", filterList);
        taxCalItemEntity.setqFilters(filterList.toArray(new QFilter[0]));
    }

    public static HasPermOrgResult getPermOrgs(String appId) {
        logger.info("SITPermissionServiceHelper.getPermOrgs:  {} - {}", (Object)appId, (Object)RequestContext.get().getCurrUserId());
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"30", (String)appId, (String)ITC_TAXFILE, (String)"47156aff000000ac");
    }

    public static Set<Long> getEmpgrpSetByPermItem(String appId) {
        logger.info("SITPermissionServiceHelper.getEmpgrpSetByPermItem: {} - {} ", (Object)appId, (Object)RequestContext.get().getCurrUserId());
        DimValueResult dimValueResult = (DimValueResult)SITMServiceUtils.invokeHRMPService("hrcs", "IHRCSBizDataPermissionService", "getEntityDimValue", RequestContext.get().getCurrUserId(), appId, ITC_TAXFILE, "47156aff000000ac", "empgroup");
        return FormulaCalUtils.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getTaxUnitSetByPermItem(String appId) {
        logger.info("SITPermissionServiceHelper.getTaxUnitSetByPermItem: {} - {} ", (Object)appId, (Object)RequestContext.get().getCurrUserId());
        DimValueResult dimValueResult = (DimValueResult)SITMServiceUtils.invokeHRMPService("hrcs", "IHRCSBizDataPermissionService", "getEntityDimValue", RequestContext.get().getCurrUserId(), appId, ITC_TAXFILE, "47156aff000000ac", "taxunit");
        return FormulaCalUtils.getSetFromDimValue(dimValueResult);
    }

    private static Set<Long> getSetFromDimValue(DimValueResult dimValueResult) {
        if (dimValueResult != null) {
            if (dimValueResult.isAll()) {
                return null;
            }
            Set dimValueIds = dimValueResult.getDimValueIds();
            if (dimValueIds == null || dimValueIds.isEmpty()) {
                return new HashSet<Long>();
            }
            return dimValueIds.stream().map(ele -> Long.parseLong(ele.trim())).collect(Collectors.toSet());
        }
        logger.error("FormulaCalUtils  call IHRCSBizDataPermissionService.getEntityDimValue API error!");
        return new HashSet<Long>();
    }
}

