/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.math.BigDecimal;
import kd.bos.exception.KDBizException;

public final class NumberUtil {
    private NumberUtil() {
    }

    public static boolean isNumber(String str) {
        boolean firstChar;
        if (str == null || str.length() == 0) {
            return false;
        }
        char[] array = str.trim().toCharArray();
        boolean bl = firstChar = array[0] <= '9' && array[0] >= '0' || array[0] == '+' || array[0] == '-' || array[0] == '.';
        if (!firstChar) {
            return false;
        }
        int dotCount = 0;
        int eCount = 0;
        for (int index = 1; index < array.length; ++index) {
            char ch = array[index];
            if (ch <= '9' && ch >= '0') continue;
            if (ch == '.') {
                if (dotCount > 0 || eCount > 0) {
                    return false;
                }
                ++dotCount;
                continue;
            }
            if (ch != 'E' && ch != 'e') continue;
            if (eCount > 0 || index == array.length - 1) {
                return false;
            }
            ++eCount;
        }
        return true;
    }

    public static boolean isNotDigit(String str) {
        boolean firstChar;
        if (str == null || str.length() == 0) {
            return true;
        }
        char[] array = str.toCharArray();
        boolean bl = firstChar = array[0] <= '9' && array[0] >= '0' || array[0] == '+' || array[0] == '-';
        if (!firstChar) {
            return true;
        }
        for (int index = 1; index < array.length; ++index) {
            char ch = array[index];
            if (ch <= '9' && ch >= '0') continue;
            return true;
        }
        return false;
    }

    public static boolean isBigDecimal(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        if (obj instanceof String) {
            return NumberUtil.isNumber((String)obj);
        }
        return false;
    }

    public static boolean isDouble(Object obj) {
        if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof String) {
            String str = ((String)obj).trim();
            if (!NumberUtil.isNumber(str)) {
                return false;
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) >= 0 && bigDecimal.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0;
        }
        return false;
    }

    public static boolean isLong(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof String) {
            String str = ((String)obj).trim();
            if (NumberUtil.isNotDigit(str)) {
                return false;
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) >= 0 && bigDecimal.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) <= 0;
        }
        return false;
    }

    public static boolean isInteger(Object obj) {
        if (obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Number) {
            long longValue = ((Number)obj).longValue();
            return longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (NumberUtil.isNotDigit(str)) {
                return false;
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) >= 0 && bigDecimal.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) <= 0;
        }
        return false;
    }

    public static boolean isShort(Object obj) {
        if (obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Number) {
            long longValue = ((Number)obj).longValue();
            return longValue <= 32767L && longValue >= -32768L;
        }
        if (obj instanceof String) {
            String str = ((String)obj).trim();
            if (NumberUtil.isNotDigit(str)) {
                return false;
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.compareTo(BigDecimal.valueOf(-32768L)) >= 0 && bigDecimal.compareTo(BigDecimal.valueOf(32767L)) <= 0;
        }
        return false;
    }

    public static boolean isByte(Object obj) {
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Number) {
            long longValue = ((Number)obj).longValue();
            return longValue <= 127L && longValue >= -128L;
        }
        if (obj instanceof String) {
            String str = ((String)obj).trim();
            if (NumberUtil.isNotDigit(str)) {
                return false;
            }
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.compareTo(BigDecimal.valueOf(-128L)) >= 0 && bigDecimal.compareTo(BigDecimal.valueOf(127L)) <= 0;
        }
        return false;
    }

    public static Double parseDouble(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (!NumberUtil.isDouble(obj)) {
            throw new KDBizException("data not match");
        }
        return new BigDecimal(String.valueOf(obj).trim()).doubleValue();
    }

    public static BigDecimal paresBigDecimal(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (!NumberUtil.isBigDecimal(obj)) {
            throw new KDBizException("data not match");
        }
        return new BigDecimal(String.valueOf(obj).trim());
    }

    public static Long parseLong(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (!NumberUtil.isLong(obj)) {
            throw new KDBizException("data not match");
        }
        return new BigDecimal(String.valueOf(obj).trim()).longValue();
    }

    public static Integer parseInteger(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (!NumberUtil.isInteger(obj)) {
            throw new KDBizException("");
        }
        return new BigDecimal(String.valueOf(obj).trim()).intValue();
    }

    public static Short parseShort(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (!NumberUtil.isShort(obj)) {
            throw new KDBizException("data not match");
        }
        return new BigDecimal(String.valueOf(obj).trim()).shortValue();
    }

    public static Byte parseByte(Object obj) {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (!NumberUtil.isByte(obj)) {
            throw new KDBizException("data not match");
        }
        return new BigDecimal(String.valueOf(obj).trim()).byteValue();
    }

    public static boolean isEmptyInFrame(Long id) {
        return id == null || id == 0L;
    }

    public static boolean isEmptyInFrame(Integer value) {
        return value == null || value == 0;
    }

    public static boolean isGreater(BigDecimal src, BigDecimal target) {
        if (src == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        return src.compareTo(target) > 0;
    }

    public static boolean isLess(BigDecimal src, BigDecimal target) {
        if (src == null) {
            return true;
        }
        if (target == null) {
            return false;
        }
        return src.compareTo(target) < 0;
    }

    public static BigDecimal sum(BigDecimal ... src) {
        if (src == null) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        for (BigDecimal num : src) {
            sum = sum.add(num);
        }
        return sum;
    }

    public static int or(Integer ... values) {
        int result = 0;
        for (Integer value : values) {
            if (value == null) continue;
            result |= value.intValue();
        }
        return result;
    }

    public static int numOfBitOne(int num) {
        int count = 0;
        while (num != 0) {
            ++count;
            num &= num - 1;
        }
        return count;
    }
}

