/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.sit.sitbp.common.enums.ResultStatusEnum;

public class ResultItem<T> {
    private T data;
    private String message;
    private int status;

    public ResultItem() {
    }

    public ResultItem(T data, String message, int status) {
        this.data = data;
        this.message = message;
        this.status = status;
    }

    static <T> List<ResultItem<T>> wrap(List<T> list, String message) {
        if (list == null) {
            return new ArrayList<ResultItem<T>>(0);
        }
        ArrayList<ResultItem<T>> res = new ArrayList<ResultItem<T>>(list.size());
        for (T item : list) {
            res.add(new ResultItem<T>(item, message, ResultStatusEnum.ERROR.getCode()));
        }
        return res;
    }

    static <T> List<T> unwrap(List<ResultItem<T>> list) {
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList<T> res = new ArrayList<T>(list.size());
        for (ResultItem<T> item : list) {
            res.add(item.data);
        }
        return res;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

