/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class SITDateTimeUtils {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY = "yyyy";
    private static TimeZone gmt = new SimpleTimeZone(0, "GMT");
    private static final Log logger = LogFactory.getLog(SITDateTimeUtils.class);
    private static final String EX_GMT_TO_DATE = "gmtToDate: invalid gmt date string!";
    private static final String EX_GET_MONTH_NAME = "getMonthName : month value must be between 1 and 12!";
    private static final String EX_GET_ELAPSED_TIME = "getElapsedTime : begin date must be inferior to end date !";
    private static final String EX_GET_DAY_NAME = "getDayName: day value must be between 1 and 7!";
    private static final String EX_FORMAT_MONTH = "Invalid month name";
    private static final String EX_DATE_TO_GMT = "dateToGmt: unknown RFC format";

    public static String format(Date date, String fmt) {
        return SITDateTimeUtils.format(date, fmt, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone) {
        return SITDateTimeUtils.format(date, fmt, timezone, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = YYYY_MM_DD_HH_MM_SS;
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(KDDateUtils.getSysTimeZone());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(date);
    }

    public static String format(Date date) {
        return SITDateTimeUtils.format(date, null, null);
    }

    public static String format(Date date, TimeZone timezone) {
        return SITDateTimeUtils.format(date, null, timezone);
    }

    public static String formatDate(Date date, TimeZone timezone) {
        return SITDateTimeUtils.format(date, YYYY_MM_DD, timezone);
    }

    public static String formatDate(Date date) {
        return SITDateTimeUtils.formatDate(date, null);
    }

    public static String formatTime(Date date, TimeZone timezone) {
        return SITDateTimeUtils.format(date, "HH:mm:ss", timezone);
    }

    public static String formatTime(Date date) {
        return SITDateTimeUtils.formatTime(date, null);
    }

    public static String defaultDateString(Date date) {
        return SITDateTimeUtils.defaultDateString(date, null);
    }

    public static String defaultDateString(Date date, TimeZone timezone) {
        if (timezone == null) {
            timezone = KDDateUtils.getSysTimeZone();
        }
        long timeOfLong = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(SITDateTimeUtils.format(date, timezone));
        if (timeOfLong > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            timeOfLong = -timeOfLong;
        }
        temp.append(SITDateTimeUtils.format(new Date(timeOfLong), "HH:mm", gmt));
        return temp.toString();
    }

    public static Date parseDate(String dateStr) throws ParseException {
        try {
            return SITDateTimeUtils.parseDate(dateStr, YYYY_MM_DD_HH_MM_SS);
        }
        catch (ParseException parseException) {
            try {
                return SITDateTimeUtils.parseDate(dateStr, YYYY_MM_DD);
            }
            catch (ParseException parseException2) {
                try {
                    return SITDateTimeUtils.parseDate(dateStr, "MM/dd/yyyy HH:mm:ss");
                }
                catch (ParseException parseException3) {
                    try {
                        return SITDateTimeUtils.parseDate(dateStr, "MM/dd/yyyy");
                    }
                    catch (ParseException parseException4) {
                        try {
                            return SITDateTimeUtils.parseDate(dateStr, "HH:mm:ss");
                        }
                        catch (ParseException parseException5) {
                            throw new ParseException("can not understand your format:" + dateStr, -1);
                        }
                    }
                }
            }
        }
    }

    public static Date parseDate(String dateStr, String fmt) throws ParseException {
        return SITDateTimeUtils.parseDate(dateStr, fmt, null);
    }

    public static Date parseDate(String dateStr, String fmt, TimeZone timezone) throws ParseException {
        return SITDateTimeUtils.parseDate(dateStr, fmt, timezone, null);
    }

    public static Date parseDate(String dateStr, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = KDDateUtils.getSysTimeZone();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(dateStr);
    }

    public static Date parseDefaultDate(String dateStr) throws ParseException {
        int indexOfSplit = dateStr.lastIndexOf(32);
        char charOfDate = dateStr.charAt(indexOfSplit + 1);
        long timeOfLong = SITDateTimeUtils.parseDate(dateStr.substring(indexOfSplit + 2), "HH:mm", gmt).getTime();
        if (charOfDate == '-') {
            timeOfLong = -timeOfLong;
        }
        return SITDateTimeUtils.parseDate(dateStr.substring(0, indexOfSplit), YYYY_MM_DD_HH_MM_SS, new SimpleTimeZone((int)timeOfLong, "XXX"));
    }

    public static String emailDate(Date date) {
        return SITDateTimeUtils.emailDate(date, null);
    }

    public static String emailDate(Date date, TimeZone timezone) {
        if (timezone == null) {
            timezone = KDDateUtils.getSysTimeZone();
        }
        long timeOfLong = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(SITDateTimeUtils.format(date, "E, d MMM yyyy HH:mm:ss", timezone, Locale.UK));
        if (timeOfLong > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            timeOfLong = -timeOfLong;
        }
        temp.append(SITDateTimeUtils.format(new Date(timeOfLong), "HHmm", gmt));
        return temp.toString();
    }

    public static Date parseEmailDate(String dateStr) throws ParseException {
        try {
            int indexOfSplit = dateStr.lastIndexOf(32);
            char charOfSplit = dateStr.charAt(indexOfSplit + 1);
            long timeOfLong = SITDateTimeUtils.parseDate(dateStr.substring(indexOfSplit + 2), "HHmm", gmt).getTime();
            if (charOfSplit == '-') {
                timeOfLong = -timeOfLong;
            }
            return SITDateTimeUtils.parseDate(dateStr.substring(0, indexOfSplit), "E, d MMM yyyy HH:mm:ss", new SimpleTimeZone((int)timeOfLong, "XXX"), Locale.UK);
        }
        catch (Exception exception) {
            return SITDateTimeUtils.parseDate(dateStr, "E, d MMM yyyy HH:mm:ss z", gmt, Locale.UK);
        }
    }

    public static boolean dayBefore(Date dt, Date dt1) {
        return dt.before(dt1);
    }

    public static boolean dayAfter(Date dt, Date dt1) {
        return dt.after(dt1);
    }

    public static boolean dayEquals(Date dt, Date dt1) {
        return dt.equals(dt1);
    }

    public static int getQuarter(Date date) {
        int quarter = 0;
        int month = SITDateTimeUtils.getMonth(date);
        if (month >= 1 && month <= 3) {
            quarter = 1;
        } else if (month >= 4 && month <= 6) {
            quarter = 2;
        } else if (month >= 7 && month <= 9) {
            quarter = 3;
        } else if (month >= 10 && month <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static int daysOfMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (SITDateTimeUtils.isLeap(year)) {
                    return 29;
                }
                return 28;
            }
        }
        return 0;
    }

    public static Date addDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long add = date1Ms + date2Ms;
        return new Date(add);
    }

    public static Date addDay(Date dDate, long iNbDay) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(dDate);
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth) {
        Date result = (Date)dDate.clone();
        result = SITDateTimeUtils.addMonth(result, iNbMonth);
        result = SITDateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay) {
        Date result = (Date)dDate.clone();
        result = SITDateTimeUtils.addDay(result, iNbDay);
        result = SITDateTimeUtils.addMonth(result, iNbMonth);
        result = SITDateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour) {
        Date result = (Date)dDate.clone();
        result = SITDateTimeUtils.addHour(result, iNbHour);
        result = SITDateTimeUtils.addDay(result, iNbDay);
        result = SITDateTimeUtils.addMonth(result, iNbMonth);
        result = SITDateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute) {
        Date result = (Date)dDate.clone();
        result = SITDateTimeUtils.addMinute(result, iNbMinute);
        result = SITDateTimeUtils.addHour(result, iNbHour);
        result = SITDateTimeUtils.addDay(result, iNbDay);
        result = SITDateTimeUtils.addMonth(result, iNbMonth);
        result = SITDateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute, int iNbSecond) {
        Date result = (Date)dDate.clone();
        result = SITDateTimeUtils.addSecond(result, iNbSecond);
        result = SITDateTimeUtils.addMinute(result, iNbMinute);
        result = SITDateTimeUtils.addHour(result, iNbHour);
        result = SITDateTimeUtils.addDay(result, iNbDay);
        result = SITDateTimeUtils.addMonth(result, iNbMonth);
        result = SITDateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addHour(Date dDate, long iNbHour) {
        long datems = dDate.getTime();
        long hourMs = iNbHour * 60L * 60L * 1000L;
        long newDateMs = datems + hourMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMinute(Date dDate, long iNbMinute) {
        long datems = dDate.getTime();
        long minuteMs = iNbMinute * 60L * 1000L;
        long newDateMs = datems + minuteMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMonth(Date dDate, int iNbMonth) {
        int resDay;
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(dDate);
        int initDay = cal.get(5);
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        if (initDay == 31) {
            cal.set(5, 1);
            resDay = cal.getActualMaximum(5);
            cal.set(5, resDay);
            return cal.getTime();
        }
        if (initDay > 28 && month == 1) {
            cal.set(5, 1);
            resDay = cal.getActualMaximum(5);
            cal.set(5, resDay);
            return cal.getTime();
        }
        return cal.getTime();
    }

    public static Date addMonth(Date dDate, int iNbMonth, boolean isNatural) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(dDate);
        int initDay = cal.get(5);
        int maxDay = cal.getActualMaximum(5);
        if (!isNatural || initDay != maxDay) {
            return SITDateTimeUtils.addMonth(dDate, iNbMonth);
        }
        Date result = SITDateTimeUtils.addMonth(dDate, iNbMonth);
        cal.setTime(result);
        int resDay = cal.getActualMaximum(5);
        cal.set(5, resDay);
        result = cal.getTime();
        return result;
    }

    public static Date addSecond(Date dDate, long iNbSecond) {
        long datems = dDate.getTime();
        long secondms = iNbSecond * 1000L;
        long newDateMs = datems + secondms;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addYear(Date dDate, int iNbYear) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(dDate);
        int oldYear = cal.get(1);
        cal.set(1, iNbYear + oldYear);
        return cal.getTime();
    }

    public static long dateDiff(String interval, Date dDate1, Date dDate2) {
        int field;
        Date date2;
        Date date1;
        int desiredField = 0;
        int coef = 1;
        if (dDate1.getTime() > dDate2.getTime()) {
            coef = -1;
            date1 = dDate2;
            date2 = dDate1;
        } else {
            date1 = dDate1;
            date2 = dDate2;
        }
        if (YYYY.equals(interval)) {
            field = 1;
        } else if ("m".equals(interval)) {
            field = 2;
        } else if ("d".equals(interval)) {
            field = 5;
        } else if ("y".equals(interval)) {
            field = 5;
        } else if ("w".equals(interval)) {
            field = 4;
        } else if ("ww".equals(interval)) {
            field = 3;
        } else if ("h".equals(interval)) {
            field = 5;
            desiredField = 11;
        } else if ("n".equals(interval)) {
            field = 5;
            desiredField = 12;
        } else if ("s".equals(interval)) {
            field = 5;
            desiredField = 13;
        } else {
            return -1L;
        }
        Calendar calTmp = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calTmp.setTime(date1);
        long nbOccurence = 0L;
        calTmp.add(field, 1);
        Date dateTemp = calTmp.getTime();
        while (dateTemp.getTime() <= date2.getTime()) {
            calTmp.add(field, 1);
            dateTemp = calTmp.getTime();
            ++nbOccurence;
        }
        if (desiredField == 11 || desiredField == 12 || desiredField == 13) {
            calTmp.setTime(date1);
            calTmp.add(field, (int)nbOccurence);
            dateTemp = calTmp.getTime();
            switch (desiredField) {
                case 11: {
                    nbOccurence *= 24L;
                    break;
                }
                case 12: {
                    nbOccurence = nbOccurence * 24L * 60L;
                    break;
                }
                case 13: {
                    nbOccurence = nbOccurence * 24L * 60L * 60L;
                    break;
                }
            }
            calTmp.add(desiredField, 1);
            dateTemp = calTmp.getTime();
            while (dateTemp.getTime() <= date2.getTime()) {
                calTmp.add(desiredField, 1);
                dateTemp = calTmp.getTime();
                ++nbOccurence;
            }
        }
        return nbOccurence * (long)coef;
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static String dateToGMT(Date vDate, String sFormat) throws Exception {
        String resultString = "";
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(vDate);
        int iDay = cal.get(7);
        int iMonth = cal.get(2);
        String sWeekDay = "";
        String sMonth = "";
        String pattern = "";
        switch (iDay) {
            case 1: {
                sWeekDay = "Sunday";
                break;
            }
            case 2: {
                sWeekDay = "Monday";
                break;
            }
            case 3: {
                sWeekDay = "Tuesday";
                break;
            }
            case 4: {
                sWeekDay = "Wednesday";
                break;
            }
            case 5: {
                sWeekDay = "Thursday";
                break;
            }
            case 6: {
                sWeekDay = "Friday";
                break;
            }
            case 7: {
                sWeekDay = "Saturday";
                break;
            }
        }
        switch (iMonth) {
            case 0: {
                sMonth = "Jan";
                break;
            }
            case 1: {
                sMonth = "Feb";
                break;
            }
            case 2: {
                sMonth = "Mar";
                break;
            }
            case 3: {
                sMonth = "Apr";
                break;
            }
            case 4: {
                sMonth = "May";
                break;
            }
            case 5: {
                sMonth = "Jun";
                break;
            }
            case 6: {
                sMonth = "Jul";
                break;
            }
            case 7: {
                sMonth = "Aug";
                break;
            }
            case 8: {
                sMonth = "Sep";
                break;
            }
            case 9: {
                sMonth = "Oct";
                break;
            }
            case 10: {
                sMonth = "Nov";
                break;
            }
            case 11: {
                sMonth = "Dec";
                break;
            }
        }
        if ("RFC822".equals(sFormat) || "RFC1123".equals(sFormat)) {
            pattern = "'" + sWeekDay.substring(0, 3) + "', dd '" + sMonth + "' yyyy HH:mm:ss 'GMT'";
            resultString = SITDateTimeUtils.format(vDate, pattern);
        } else if ("RFC850".equals(sFormat) || "RFC1036".equals(sFormat)) {
            pattern = "'" + sWeekDay + "', dd-'" + sMonth + "'-yy HH:mm:ss 'GMT'";
            resultString = SITDateTimeUtils.format(vDate, pattern);
        } else if ("ASCTIME".equals(sFormat)) {
            pattern = "'" + sWeekDay.substring(0, 3) + " " + sMonth + "' d HH:mm:ss yyyy";
            resultString = SITDateTimeUtils.format(vDate, pattern);
        } else {
            throw new Exception(EX_DATE_TO_GMT);
        }
        return resultString;
    }

    public static String dateToSQL(Date vDate) {
        String sqlDate = "#" + SITDateTimeUtils.format(vDate, "M/d/yyyy H:m:s") + "#";
        return sqlDate;
    }

    private static int formatMonth(String sMonth) throws Exception {
        if (sMonth.equalsIgnoreCase("jan")) {
            return 0;
        }
        if (sMonth.equalsIgnoreCase("feb")) {
            return 1;
        }
        if (sMonth.equalsIgnoreCase("mar")) {
            return 2;
        }
        if (sMonth.equalsIgnoreCase("apr")) {
            return 3;
        }
        if (sMonth.equalsIgnoreCase("may")) {
            return 4;
        }
        if (sMonth.equalsIgnoreCase("jun")) {
            return 5;
        }
        if (sMonth.equalsIgnoreCase("jul")) {
            return 6;
        }
        if (sMonth.equalsIgnoreCase("aug")) {
            return 7;
        }
        if (sMonth.equalsIgnoreCase("sep")) {
            return 8;
        }
        if (sMonth.equalsIgnoreCase("oct")) {
            return 9;
        }
        if (sMonth.equalsIgnoreCase("nov")) {
            return 10;
        }
        if (sMonth.equalsIgnoreCase("dec")) {
            return 11;
        }
        throw new Exception(EX_FORMAT_MONTH);
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(date);
        return cal.get(5);
    }

    public static String getDayName(int iNDay) throws Exception {
        if (iNDay >= 1 && iNDay <= 7) {
            Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
            cal.set(7, iNDay);
            return SITDateTimeUtils.format(cal.getTime(), "EEEE");
        }
        throw new Exception(EX_GET_DAY_NAME);
    }

    public static String getDayName(Date vDate) {
        return SITDateTimeUtils.format(vDate, "EEEE");
    }

    public static int getElapsedTime(Date vDateBegin, Date vDateEnd, Date vDate) throws Exception {
        long begin = vDateBegin.getTime();
        long end = vDateEnd.getTime();
        long current = vDate.getTime();
        if (begin > end) {
            throw new Exception(EX_GET_ELAPSED_TIME);
        }
        if (current <= begin) {
            return 0;
        }
        if (current >= end) {
            return 100;
        }
        long result = 100L * SITDateTimeUtils.dateDiff(vDateBegin, vDate) / SITDateTimeUtils.dateDiff(vDateBegin, vDateEnd);
        return (int)result;
    }

    public static Date getGMTDate() {
        Date now = new Date();
        long nowMs = now.getTime();
        long gmtOffetsMs = (long)(SITDateTimeUtils.getServerGMTOffset() * 60) * 1000L;
        return new Date(nowMs - gmtOffetsMs);
    }

    public static int getGMTHour() {
        Date nowGMT = SITDateTimeUtils.getGMTDate();
        int gmtHour = Integer.parseInt(SITDateTimeUtils.format(nowGMT, "H"));
        return gmtHour;
    }

    public static long getGMTOffset(Date vDate) {
        Date nowGMT = SITDateTimeUtils.getGMTDate();
        long nowGMTMs = nowGMT.getTime();
        long vDateMs = vDate.getTime();
        double diffMs = (double)vDateMs - (double)nowGMTMs;
        double diffSec = diffMs / 1000.0;
        double diffMinute = (double)Math.round(diffSec) / 60.0;
        return Math.round(diffMinute);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String getMonthName(int iMonth) throws Exception {
        if (--iMonth >= 0 && iMonth <= 11) {
            Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
            cal.set(5, 1);
            cal.set(2, iMonth);
            return SITDateTimeUtils.format(cal.getTime(), "MMMM");
        }
        throw new Exception(EX_GET_MONTH_NAME);
    }

    public static String getMonthName(Date vDate) {
        return SITDateTimeUtils.format(vDate, "MMMM");
    }

    public static Hashtable<String, Integer> getRemainTime(Date vDate) {
        boolean dataDiff4;
        boolean dataDiff3;
        boolean dataDiff2;
        boolean dataDiff;
        int coef;
        Date now = new Date();
        Hashtable<String, Integer> numbers = new Hashtable<String, Integer>();
        long iNbMilisecSeconds = vDate.getTime() - now.getTime();
        int m_iYears = 0;
        int m_iMonths = 0;
        int m_iDays = 0;
        int m_iHours = 0;
        int m_iMinutes = 0;
        int m_iSeconds = 0;
        int m_iMillisec = 0;
        if (iNbMilisecSeconds < 0L) {
            coef = -1;
            iNbMilisecSeconds = -iNbMilisecSeconds;
        } else {
            coef = 1;
        }
        Date m_date = new Date(now.getTime() + iNbMilisecSeconds);
        m_iYears = (int)SITDateTimeUtils.dateDiff(YYYY, now, m_date);
        m_date = SITDateTimeUtils.addYear(m_date, -m_iYears);
        boolean bl = dataDiff = SITDateTimeUtils.dateDiff("m", now, m_date) < 0L || SITDateTimeUtils.dateDiff("d", now, m_date) < 0L || SITDateTimeUtils.dateDiff("h", now, m_date) < 0L || SITDateTimeUtils.dateDiff("n", now, m_date) < 0L || SITDateTimeUtils.dateDiff("s", now, m_date) < 0L;
        if (dataDiff && m_iYears != 0) {
            --m_iYears;
            m_date = SITDateTimeUtils.addYear(m_date, 1);
        }
        boolean bl2 = dataDiff2 = SITDateTimeUtils.dateDiff("d", now, m_date = SITDateTimeUtils.addMonth(m_date, -(m_iMonths = (int)SITDateTimeUtils.dateDiff("m", now, m_date)))) < 0L || SITDateTimeUtils.dateDiff("h", now, m_date) < 0L || SITDateTimeUtils.dateDiff("n", now, m_date) < 0L || SITDateTimeUtils.dateDiff("s", now, m_date) < 0L;
        if (dataDiff2 && m_iMonths != 0) {
            --m_iMonths;
            m_date = SITDateTimeUtils.addMonth(m_date, 1);
        }
        boolean bl3 = dataDiff3 = SITDateTimeUtils.dateDiff("h", now, m_date = SITDateTimeUtils.addDay(m_date, -(m_iDays = (int)SITDateTimeUtils.dateDiff("d", now, m_date)))) < 0L || SITDateTimeUtils.dateDiff("n", now, m_date) < 0L || SITDateTimeUtils.dateDiff("s", now, m_date) < 0L;
        if (dataDiff3 && m_iDays != 0) {
            --m_iDays;
            m_date = SITDateTimeUtils.addDay(m_date, 1L);
        }
        boolean bl4 = dataDiff4 = SITDateTimeUtils.dateDiff("n", now, m_date = SITDateTimeUtils.addHour(m_date, -(m_iHours = (int)SITDateTimeUtils.dateDiff("h", now, m_date)))) < 0L || SITDateTimeUtils.dateDiff("s", now, m_date) < 0L;
        if (dataDiff4 && m_iHours != 0) {
            --m_iHours;
            m_date = SITDateTimeUtils.addHour(m_date, 1L);
        }
        m_iMinutes = (int)SITDateTimeUtils.dateDiff("n", now, m_date);
        m_date = SITDateTimeUtils.addMinute(m_date, -m_iMinutes);
        if (m_iMinutes != 0 && SITDateTimeUtils.dateDiff("s", now, m_date) < 0L) {
            --m_iMinutes;
            m_date = SITDateTimeUtils.addMinute(m_date, 1L);
        }
        if ((m_iMillisec = (int)((m_date = SITDateTimeUtils.addSecond(m_date, -(m_iSeconds = (int)SITDateTimeUtils.dateDiff("s", now, m_date)))).getTime() - now.getTime())) < 0 && m_iSeconds != 0) {
            --m_iSeconds;
            m_date = SITDateTimeUtils.addSecond(m_date, 1L);
            m_iMillisec = (int)(m_date.getTime() - now.getTime());
        }
        numbers.put("year", m_iYears * coef);
        numbers.put("month", m_iMonths * coef);
        numbers.put("day", m_iDays * coef);
        numbers.put("hour", m_iHours * coef);
        numbers.put("minute", m_iMinutes * coef);
        numbers.put("second", m_iSeconds * coef);
        return numbers;
    }

    public static int getServerGMTOffset() {
        Calendar now = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        int era = now.get(0);
        int year = now.get(1);
        int month = now.get(2);
        int day = now.get(5);
        int dayofweek = now.get(7);
        int milliseconds = now.get(14);
        int resultMs = Calendar.getInstance(KDDateUtils.getSysTimeZone()).getTimeZone().getOffset(era, year, month, day, dayofweek, milliseconds);
        return resultMs / 1000 / 60;
    }

    public static String getServerTimeZone() {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        TimeZone tz = cal.getTimeZone();
        return tz.getID();
    }

    public static int getWeek(Date vDate) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(vDate);
        int week = cal.get(3);
        return week;
    }

    public static int getWeekDay(Date date) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(date);
        int year = cal.get(1);
        int era = cal.get(0);
        if (era == 0) {
            return -1 * year;
        }
        return year;
    }

    public static Date gmtToDate(String sDate) throws Exception {
        int beginSpace;
        int totalNbSpace = 0;
        int iDay = 0;
        String month = "";
        int year = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        for (int i = 0; i < sDate.length(); ++i) {
            if (sDate.charAt(i) != ' ') continue;
            ++totalNbSpace;
        }
        if (totalNbSpace == 5) {
            beginSpace = 1 + sDate.indexOf(32);
            int endSpace = sDate.indexOf(32, beginSpace);
            iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            month = sDate.substring(beginSpace, endSpace);
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            year = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        } else if (totalNbSpace == 3) {
            beginSpace = 1 + sDate.indexOf(32);
            int endSpace = sDate.indexOf(45, beginSpace);
            iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(45, beginSpace);
            month = sDate.substring(beginSpace, endSpace);
            beginSpace = 1 + endSpace;
            year = Integer.parseInt(sDate.substring(beginSpace, endSpace = sDate.indexOf(32, beginSpace)));
            year = year < 70 ? (year += 2000) : (year += 1900);
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        } else if (totalNbSpace == 4) {
            beginSpace = 1 + sDate.indexOf(32);
            int endSpace = sDate.indexOf(32, beginSpace);
            month = sDate.substring(beginSpace, endSpace);
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(58, beginSpace);
            minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.indexOf(32, beginSpace);
            seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
            beginSpace = 1 + endSpace;
            endSpace = sDate.length();
            year = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        } else {
            throw new Exception(EX_GMT_TO_DATE);
        }
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.set(1, year);
        cal.set(2, SITDateTimeUtils.formatMonth(month));
        cal.set(5, iDay);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return cal.getTime();
    }

    public static boolean isLeap(int year) {
        boolean div4 = year % 4 == 0;
        boolean div100 = year % 100 == 0;
        boolean div400 = year % 400 == 0;
        return div4 && (!div100 || div400);
    }

    public static Date secondsTo(long lNbSeconds) {
        return new Date(lNbSeconds * 1000L);
    }

    public static Date subDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long diff = date1Ms - date2Ms;
        return new Date(diff);
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static String getTrancateDateFromTimestamp(Timestamp time) {
        if (time == null) {
            return null;
        }
        SimpleDateFormat sFormat = new SimpleDateFormat(YYYY_MM_DD);
        Date date = new Date(time.getTime());
        return sFormat.format(date);
    }

    public static String getTrancateDateFromDate(Date date) {
        if (date == null) {
            return null;
        }
        return SITDateTimeUtils.format(date, YYYY_MM_DD);
    }

    public static List<String> getDateScope(int day, Calendar calendar, int days, int dateType) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        ArrayList<String> date = new ArrayList<String>();
        int dayInt = calendar.get(dateType) == 1 ? 0 : 1 - calendar.get(dateType);
        calendar.add(dateType, dayInt);
        String dtstartdate = sdf.format(calendar.getTime());
        calendar.add(dateType, days - 1);
        String dtenddate = sdf.format(calendar.getTime());
        date.add(dtstartdate);
        date.add(dtenddate);
        return date;
    }

    public static int getCurrentMonthDays() {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.set(5, 1);
        cal.roll(5, -1);
        int maxDate = cal.get(5);
        return maxDate;
    }

    public static int getCurrentYearDays() {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY);
        boolean days = false;
        int year = Integer.parseInt(sdf.format(new Date()));
        return SITDateTimeUtils.getYearDays(year);
    }

    public static int getYearDays(int year) {
        boolean isLeap = year % 4 == 0 && year % 100 != 0;
        int days = isLeap || year % 400 == 0 ? 366 : 365;
        return days;
    }

    public static List<String> getCurrentQuarterDate() {
        String startDate = null;
        String endDate = null;
        ArrayList<String> quarterDate = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        SimpleDateFormat year_sdf = new SimpleDateFormat(YYYY);
        String year = year_sdf.format(new Date());
        String now = sdf.format(new Date());
        try {
            Date nowDate = sdf.parse(now);
            if (nowDate.compareTo(sdf.parse("01-01")) >= 0 && nowDate.compareTo(sdf.parse("03-31")) <= 0) {
                startDate = year + "-01-01";
                endDate = year + "-03-31";
            } else if (nowDate.compareTo(sdf.parse("04-01")) >= 0 && nowDate.compareTo(sdf.parse("06-30")) <= 0) {
                startDate = year + "-04-01";
                endDate = year + "-06-30";
            } else if (nowDate.compareTo(sdf.parse("07-01")) >= 0 && nowDate.compareTo(sdf.parse("09-30")) <= 0) {
                startDate = year + "-07-01";
                endDate = year + "-09-30";
            } else if (nowDate.compareTo(sdf.parse("10-01")) >= 0 && nowDate.compareTo(sdf.parse("12-31")) <= 0) {
                startDate = year + "-10-01";
                endDate = year + "-12-31";
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        quarterDate.add(startDate);
        quarterDate.add(endDate);
        return quarterDate;
    }

    public static String getDateStrWithoutMin(Date date) {
        if (date == null) {
            return null;
        }
        return SITDateTimeUtils.format(date, YYYY_MM_DD);
    }

    public static String getDateStrWithoutMinTs(Date date) {
        if (date == null) {
            return null;
        }
        String dateString = SITDateTimeUtils.getDateStrWithoutMin(date);
        return " {ts'" + dateString + "'} ";
    }

    public static Date getDateWithoutMinTs(Date date) {
        if (date == null) {
            return null;
        }
        String dateString = SITDateTimeUtils.getDateStrWithoutMin(date);
        Date rDate = null;
        try {
            rDate = SITDateTimeUtils.parseDate(dateString, YYYY_MM_DD);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return rDate;
    }

    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getDateWithoutTime(LocalDate localDate) {
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static Date getTodayDateWithoutTime() {
        LocalDate now = LocalDate.now();
        Date today = SITDateTimeUtils.getDateWithoutTime(now);
        return today;
    }

    public static Date getDateWithoutTime(int year, int month, int dayOfMonth) {
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        Date date = SITDateTimeUtils.getDateWithoutTime(localDate);
        return date;
    }

    public static Date getDateWithoutTime(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Date dateWithoutTime = SITDateTimeUtils.getDateWithoutTime(localDate);
        return dateWithoutTime;
    }

    public static Date getOffsetDate(Date date, int offset) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.add(5, offset);
        return calendar.getTime();
    }

    public static Date formatDateToDate(Date date, String fmt) throws ParseException {
        String dateStr = SITDateTimeUtils.format(date, fmt);
        return SITDateTimeUtils.parseDate(dateStr, fmt);
    }

    public static int dayIndexInYear(Date date) {
        int[] monthDayCount = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] leapMonthDayCount = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int seq = 0;
        int month = SITDateTimeUtils.getMonth(date);
        boolean isLeap = SITDateTimeUtils.isLeap(SITDateTimeUtils.getYear(date));
        for (int i = 0; i < month - 1; ++i) {
            if (isLeap) {
                seq += leapMonthDayCount[i];
                continue;
            }
            seq += monthDayCount[i];
        }
        return seq += SITDateTimeUtils.getDay(date);
    }

    public static Date getDayDate(Date date) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getConsumeTime(Date startTime) {
        return SITDateTimeUtils.getConsumeTime(startTime, new Date());
    }

    public static String getConsumeTime(Date startTime, Date endTime) {
        long between = endTime.getTime() - startTime.getTime();
        long hour = between / 3600000L;
        long min = between / 60000L - hour * 60L;
        long second = between / 1000L - hour * 60L * 60L - min * 60L;
        return (hour < 10L ? "0" + hour : Long.valueOf(hour)) + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (second < 10L ? "0" + second : Long.valueOf(second));
    }
}

