/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.util.SITIDCardUtils;

public abstract class SITFormatUtils {
    private static final String PASSPORT_REGEX = "[^\u4e00-\u9fa5]+$";
    private static final String HKANDMC_ID_REGEX = "^(810000|820000)[0-9]{12}$";
    private static final String TAIWAN_ID_REGEX = "^(830000)[0-9]{12}$";

    public static String certfTypeCheck(String certfTypeId, String certfNumber) {
        String msg = "";
        switch (certfTypeId) {
            case "1010": {
                if (SITFormatUtils.checkIDCardValid(certfNumber)) break;
                msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef", (String)"SITFormatUtils_0", (String)"sit-sitbp-common", (Object[])new Object[0]);
                break;
            }
            case "1020": {
                if (SITFormatUtils.checkPassPort(certfNumber)) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7\u7801", (String)"SITFormatUtils_1", (String)"sit-sitbp-common", (Object[])new Object[0]);
                break;
            }
            case "1030": {
                if (SITFormatUtils.checkHKAndMCId(certfNumber)) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7\u7801", (String)"SITFormatUtils_1", (String)"sit-sitbp-common", (Object[])new Object[0]);
                break;
            }
            case "1040": {
                if (SITFormatUtils.checkTWId(certfNumber)) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7\u7801", (String)"SITFormatUtils_1", (String)"sit-sitbp-common", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    public static boolean checkIDCardValid(String idCardNo) {
        return SITIDCardUtils.checkIDCard(idCardNo);
    }

    public static boolean checkHKAndMCId(String idCardNo) {
        Pattern pattern = Pattern.compile(HKANDMC_ID_REGEX);
        Matcher matcher = pattern.matcher(idCardNo);
        return matcher.matches() && SITIDCardUtils.checkIDCard(idCardNo);
    }

    public static boolean checkTWId(String idCardNo) {
        Pattern pattern = Pattern.compile(TAIWAN_ID_REGEX);
        Matcher matcher = pattern.matcher(idCardNo);
        return matcher.matches() && SITIDCardUtils.checkIDCard(idCardNo);
    }

    public static boolean checkPassPort(String passPort) {
        Pattern pattern = Pattern.compile(PASSPORT_REGEX);
        Matcher matcher = pattern.matcher(passPort);
        return matcher.matches();
    }

    public static boolean checkEmail(String email) {
        return StringUtils.isEmail((String)email);
    }

    public static boolean checkPhone(String phone) {
        return StringUtils.isPhoneNumberValid((String)phone);
    }

    public static boolean simpleCheckPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return false;
        }
        return (phone = phone.trim()).startsWith("1") && phone.length() == 11;
    }
}

