/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SITIDCardUtils {
    private static final Log logger = LogFactory.getLog(SITIDCardUtils.class);
    private static final String VERIFY18PATTERNSTR = "(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})";
    private static final Pattern VERIFY18PATTERN = Pattern.compile("(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})");
    private static final int[] VERIFY18RIGHTS = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final String[] VERIFY18CHECKDIGIT = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "83", "91"};

    private SITIDCardUtils() {
    }

    public static boolean checkIDCard(String idCardNo) {
        int length = idCardNo.length();
        if (length == 18) {
            return SITIDCardUtils.verify18(idCardNo);
        }
        return false;
    }

    public static boolean verify18(String idCardNo) {
        Matcher matcher = VERIFY18PATTERN.matcher(idCardNo);
        if (!matcher.matches()) {
            return false;
        }
        String cityNo = idCardNo.substring(0, 2);
        List<String> cityList = Arrays.asList(cityCode);
        if (!cityList.contains(cityNo)) {
            return false;
        }
        String birthday = idCardNo.substring(6, 14);
        Date birthdate = null;
        try {
            birthdate = new SimpleDateFormat("yyyyMMdd").parse(birthday);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        if (birthdate == null || new Date().before(birthdate)) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int curYear = calendar.get(1);
        int year = Integer.parseInt(idCardNo.substring(6, 10));
        int month = Integer.parseInt(idCardNo.substring(10, 12));
        int day = Integer.parseInt(idCardNo.substring(12, 14));
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int maxDay = calendar.getActualMaximum(5);
        if (year < 1900 || year > curYear || month > 12 || month < 1 || day > maxDay || day < 1) {
            return false;
        }
        String checkDigit = matcher.group(4);
        String expectCheckDigit = SITIDCardUtils.getCheckDigit18(idCardNo);
        return expectCheckDigit.equalsIgnoreCase(checkDigit);
    }

    public static String getCheckDigit18(String idCardNO) {
        int sum = 0;
        for (int i = 0; i <= 16; ++i) {
            int num = Integer.parseInt(idCardNO.substring(i, i + 1));
            int right = VERIFY18RIGHTS[i];
            sum += num * right;
        }
        int index = sum % 11;
        return VERIFY18CHECKDIGIT[index];
    }
}

