/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;

public class SITStringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    private static final char[] HEX_DIGITS_HIGH = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_DIGITS_LOW = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] JAVA_KEYWORDS = new String[]{"assert", "abstract", "continue", "for", "new", "switch", "boolean", "default", "goto", "null", "synchronized", "break", "do", "if", "package", "this", "byte", "double", "implements", "private", "threadsafe", "byvalue", "else", "import", "protected", "throw", "case", "extends", "instanceof", "public", "transient", "catch", "false", "int", "return", "true", "char", "final", "interface", "short", "try", "class", "finally", "long", "static", "void", "const", "float", "native", "super", "while", "volatile", "strictfp"};
    private static String VOWELS = "AEIOU";
    private static String FRONTV = "EIY";
    private static String VARSON = "CSPTG";
    private static final int SEPERATOR_DEFAULT_SIZE = 9;

    public static String[] split(String line, int seperator) {
        int indexOf;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        if (line.indexOf(seperator) < 0) {
            return new String[]{line};
        }
        ArrayList<String> values = new ArrayList<String>(10);
        int index = 0;
        while ((indexOf = line.indexOf(seperator, index)) >= 0) {
            values.add(line.substring(index, indexOf).trim());
            index = indexOf + 1;
        }
        values.add(line.substring(index).trim());
        return values.toArray(new String[values.size()]);
    }

    public static String[] split(String line, String seperator) {
        int indexOf;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        if (line.indexOf(seperator) < 0) {
            return new String[]{line};
        }
        ArrayList<String> values = new ArrayList<String>(10);
        int index = 0;
        while ((indexOf = line.indexOf(seperator, index)) >= 0) {
            values.add(line.substring(index, indexOf).trim());
            index = indexOf + seperator.length();
        }
        values.add(line.substring(index).trim());
        return values.toArray(new String[values.size()]);
    }

    public static String fixNumber(long num) {
        return SITStringUtils.fixNumber(num, 8);
    }

    public static String fixNumber(long num, int len) {
        char[] tempArr = new char[len];
        for (int i = 0; i < len; ++i) {
            tempArr[i] = 48;
        }
        return new DecimalFormat(new String(tempArr)).format(num);
    }

    public static String fixNumber(int num) {
        return SITStringUtils.fixNumber((long)num, 4);
    }

    public static String fixNumber(int num, int len) {
        return SITStringUtils.fixNumber((long)num, len);
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return !SITStringUtils.isEmpty(str);
    }

    public static boolean equals(String s1, String s2) {
        if (SITStringUtils.isEmpty(s1)) {
            return SITStringUtils.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (SITStringUtils.isEmpty(s1)) {
            return SITStringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String numStr4Java(String str, char char1, char char2) {
        if (str == null) {
            return null;
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c2 = str.charAt(i);
            if (c2 == char1) continue;
            if (c2 == char2) {
                stringbuilder.append('.');
                continue;
            }
            stringbuilder.append(c2);
        }
        return stringbuilder.toString();
    }

    public static String takeCommasFromNumStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(44) == -1) {
            return str;
        }
        return SITStringUtils.numStr4Java(str, ',', '.');
    }

    public static String[] enumeration2StringArray(Enumeration<String> enumeration, int index) {
        int resIndex = 0;
        String[] as = new String[index];
        while (enumeration.hasMoreElements()) {
            as[resIndex++] = enumeration.nextElement();
        }
        return as;
    }

    public static byte[] chars2bytes(char[] ac) {
        byte[] resultByte = new byte[ac.length * 2];
        int index = 0;
        for (int j = 0; j < ac.length; ++j) {
            char chOfJ = ac[j];
            char c1 = ac[j];
            resultByte[index++] = (byte)(chOfJ >> 8);
            resultByte[index++] = (byte)c1;
        }
        return resultByte;
    }

    public static char[] bytes2chars(byte[] abyte0) throws Exception {
        if (abyte0.length % 2 != 0) {
            throw new Exception("Cannot convert an odd number of bytes");
        }
        char[] ac = new char[abyte0.length / 2];
        int index = 0;
        for (int j = 0; j < ac.length; ++j) {
            byte byte0 = abyte0[index++];
            byte byte1 = abyte0[index++];
            ac[j] = (char)(byte0 << 8 & 0xFF00 | byte1 & 0xFF);
        }
        return ac;
    }

    public static String padStringWidth(String str, int length) {
        StringBuilder stringBuild;
        if (str != null) {
            int stringLen;
            stringBuild = new StringBuilder(str);
            stringBuild.setLength(length);
            for (int l = stringLen = str.length(); l < length; ++l) {
                stringBuild.setCharAt(l, ' ');
            }
        } else {
            stringBuild = new StringBuilder(length);
            stringBuild.setLength(length);
            for (int k = 0; k < length; ++k) {
                stringBuild.setCharAt(k, ' ');
            }
        }
        return stringBuild.toString();
    }

    public static String padStringWidth(int num, int length) {
        return SITStringUtils.padStringWidth(String.valueOf(num), length);
    }

    public static String padStringWidth(float num, int length) {
        return SITStringUtils.padStringWidth(String.valueOf(num), length);
    }

    public static String padStringWidth(long num, int length) {
        return SITStringUtils.padStringWidth(String.valueOf(num), length);
    }

    public static String padStringWidth(double num, int length) {
        return SITStringUtils.padStringWidth(String.valueOf(num), length);
    }

    public static String toHexString(long num, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = HEX_DIGITS_LOW[(int)(num & 0xFL)];
            num >>>= 4;
        }
        return new String(buf);
    }

    public static String GBToUnicode(String str) {
        try {
            return new String(str.getBytes("8859_1"), "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String unicodeToGB(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            return new String(str.getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String cnulls(Object obj) {
        return SITStringUtils.cnulls(obj, "");
    }

    public static String cnulls(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static String cnulls(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public static String cnulls(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String formatCurrency(double cy) {
        return NumberFormat.getCurrencyInstance().format(cy);
    }

    public static String formatNumber(double num, int length) {
        StringBuilder patternBuilder = new StringBuilder("#,##0");
        if (length > 0) {
            patternBuilder.append('.');
            for (int i = 0; i < length; ++i) {
                patternBuilder.append('0');
            }
        }
        return new DecimalFormat(patternBuilder.toString()).format(num);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ROOT).compareTo(str2.toLowerCase(Locale.ROOT));
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT));
    }

    public static int indexOfIgnoreCase(String str, int find) {
        return str.toLowerCase().indexOf(Character.toLowerCase((char)find));
    }

    public static int indexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase().indexOf(Character.toLowerCase((char)find), start);
    }

    public static int indexOfIgnoreCase(String str, String find) {
        return str.toLowerCase().indexOf(find.toLowerCase());
    }

    public static int indexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase().indexOf(find.toLowerCase(), start);
    }

    public static int lastIndexOfIgnoreCase(String str, int find) {
        return str.toLowerCase().lastIndexOf(Character.toLowerCase((char)find));
    }

    public static int lastIndexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase().lastIndexOf(Character.toLowerCase((char)find), start);
    }

    public static int lastIndexOfIgnoreCase(String str, String find) {
        return str.toLowerCase().lastIndexOf(find.toLowerCase());
    }

    public static int lastIndexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase().lastIndexOf(find.toLowerCase(), start);
    }

    public static int occurencesOf(String str, char ch) {
        char[] charArr = new char[str.length()];
        str.getChars(0, charArr.length, charArr, 0);
        int count = 0;
        for (int i = 0; i < charArr.length; ++i) {
            if (charArr[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int occurencesOfIgnoreCase(String str, char ch) {
        return SITStringUtils.occurencesOf(str.toLowerCase(), Character.toLowerCase(ch));
    }

    public static final String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    public static String replaceIgnoreCase(String chars, String oldChars, String newChars) {
        int pos;
        String lowerStr = chars.toLowerCase();
        int len = newChars.length();
        int lastPos = pos = lowerStr.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = chars.substring(0, pos);
            String lastPart = chars.substring(pos + oldChars.length(), chars.length());
            chars = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = chars.indexOf(oldChars, lastPos);
        }
        return chars;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT));
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int start) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT), start);
    }

    public static String byteArrayToString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS_HIGH[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS_HIGH[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] hexFromString(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int index = 0;
        int newIndex = 0;
        if (len % 2 == 1) {
            buf[newIndex++] = (byte)SITStringUtils.fromDigit(hex.charAt(index++));
        }
        while (index < len) {
            buf[newIndex++] = (byte)(SITStringUtils.fromDigit(hex.charAt(index++)) << 4 | SITStringUtils.fromDigit(hex.charAt(index++)));
        }
        return buf;
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
    }

    public static String escapeXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String escapeHTMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String headCharUpperCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toUpperCase();
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String headCharLowerCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toLowerCase();
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String left(String str, int length) {
        return str.substring(str.length() - length);
    }

    public static String right(String str, int length) {
        return str.substring(str.length() - length, str.length());
    }

    public static boolean isJavaIdentifier(String str) {
        if (SITStringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean startByNotIdentifier;
            boolean bl = startByNotIdentifier = i == 0 && !Character.isJavaIdentifierStart(chars[i]);
            if (Character.isJavaIdentifierPart(chars[i]) && !startByNotIdentifier) continue;
            return false;
        }
        return !Arrays.asList(JAVA_KEYWORDS).contains(str);
    }

    public static boolean isJavaClassName(String name) {
        if (SITStringUtils.isEmpty(name)) {
            return true;
        }
        if (name.startsWith(" ") || name.startsWith(".") || name.endsWith(" ") || name.endsWith(".")) {
            return false;
        }
        String[] pks = SITStringUtils.split(name, ".");
        for (int i = 0; i < pks.length; ++i) {
            if (SITStringUtils.isJavaIdentifier(pks[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileName(String name) {
        return !SITStringUtils.isEmpty(name) && name.indexOf(60) <= -1 && name.indexOf(42) <= -1 && name.indexOf(47) <= -1 && name.indexOf(58) <= -1 && name.indexOf(63) <= -1 && name.indexOf(92) <= -1 && name.indexOf(34) <= -1;
    }

    public static String arrayToString(Object[] objArray, String operator) {
        if (objArray != null && objArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < objArray.length; ++i) {
                sb.append(objArray[i]);
                sb.append(operator);
            }
            if (operator != null && operator.length() > 0) {
                if (sb.indexOf(operator) == 0) {
                    sb.delete(0, operator.length());
                } else if (sb.lastIndexOf(operator) == sb.length() - operator.length()) {
                    sb.delete(sb.length() - operator.length(), sb.length());
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String[] stringArrayAppend(String[] array, String appendObj) {
        if (array == null) {
            array = new String[]{};
        }
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = appendObj;
        return newArray;
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String addBracket(String str) {
        if (SITStringUtils.isEmpty(str)) {
            return str;
        }
        return "(" + str + ")";
    }

    public static String abbreviate(String txt, int len) {
        StringBuilder resultBuilder = new StringBuilder();
        String[] str = SITStringUtils.splitByUpperCaseChar(txt);
        if (str.length < len) {
            String abb = SITStringUtils.metaphone(str[0], len - str.length + 1);
            if (abb.length() == 0) {
                abb = str[0].substring(0, len - str.length + 1).toUpperCase();
            }
            abb = abb.substring(0, 1) + abb.substring(1).toLowerCase();
            resultBuilder.append(abb);
            for (int i = 1; i < str.length; ++i) {
                resultBuilder.append(str[i].charAt(0));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                resultBuilder.append(str[i].charAt(0));
            }
        }
        return resultBuilder.toString();
    }

    private static String metaphone(String txt, int maxCodeLen) {
        if (txt == null || txt.length() == 0) {
            return "";
        }
        if (maxCodeLen <= 0) {
            return "";
        }
        if (maxCodeLen > txt.length()) {
            return txt;
        }
        if (txt.length() == 1) {
            return txt.toUpperCase();
        }
        boolean hard = false;
        char[] inwd = txt.toUpperCase().toCharArray();
        StringBuilder local = new StringBuilder();
        StringBuilder code = new StringBuilder();
        switch (inwd[0]) {
            case 'G': 
            case 'K': 
            case 'P': {
                if (inwd[1] == 'N') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'A': {
                if (inwd[1] == 'E') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'W': {
                if (inwd[1] == 'R') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                if (inwd[1] == 'H') {
                    local.append(inwd, 1, inwd.length - 1);
                    local.setCharAt(0, 'W');
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'X': {
                inwd[0] = 83;
                local.append(inwd);
                break;
            }
            default: {
                local.append(inwd);
            }
        }
        int wdsz = local.length();
        int count = 0;
        while (code.length() < maxCodeLen && count < wdsz) {
            char symb = local.charAt(count);
            if (symb != 'C' && SITStringUtils.isPreviousChar(local, count, symb)) {
                ++count;
            } else {
                switch (symb) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        if (count != 0) break;
                        code.append(symb);
                        break;
                    }
                    case 'B': {
                        if (SITStringUtils.isPreviousChar(local, count, 'M') && SITStringUtils.isLastChar(wdsz, count)) break;
                        code.append(symb);
                        break;
                    }
                    case 'C': {
                        if (SITStringUtils.isPreviousChar(local, count, 'S') && !SITStringUtils.isLastChar(wdsz, count) && FRONTV.indexOf(local.charAt(count + 1)) >= 0) break;
                        if (SITStringUtils.regionMatch(local, count, "CIA")) {
                            code.append('X');
                            break;
                        }
                        if (!SITStringUtils.isLastChar(wdsz, count) && FRONTV.indexOf(local.charAt(count + 1)) >= 0) {
                            code.append('S');
                            break;
                        }
                        if (SITStringUtils.isPreviousChar(local, count, 'S') && SITStringUtils.isNextChar(local, count, 'H')) {
                            code.append('K');
                            break;
                        }
                        if (SITStringUtils.isNextChar(local, count, 'H')) {
                            if (count == 0 && wdsz >= 3 && SITStringUtils.isVowel(local, 2)) {
                                code.append('K');
                                break;
                            }
                            code.append('X');
                            break;
                        }
                        code.append('C');
                        break;
                    }
                    case 'D': {
                        if (!SITStringUtils.isLastChar(wdsz, count + 1) && SITStringUtils.isNextChar(local, count, 'G') && FRONTV.indexOf(local.charAt(count + 2)) >= 0) {
                            code.append('J');
                            count += 2;
                            break;
                        }
                        code.append('D');
                        break;
                    }
                    case 'G': {
                        boolean regionMatch;
                        if (SITStringUtils.isLastChar(wdsz, count + 1) && SITStringUtils.isNextChar(local, count, 'H') || !SITStringUtils.isLastChar(wdsz, count + 1) && SITStringUtils.isNextChar(local, count, 'H') && !SITStringUtils.isVowel(local, count + 2)) break;
                        boolean bl = regionMatch = SITStringUtils.regionMatch(local, count, "GN") || SITStringUtils.regionMatch(local, count, "GNED");
                        if (count > 0 && regionMatch) break;
                        hard = SITStringUtils.isPreviousChar(local, count, 'G');
                        if (!SITStringUtils.isLastChar(wdsz, count) && FRONTV.indexOf(local.charAt(count + 1)) >= 0 && !hard) {
                            code.append('J');
                            break;
                        }
                        code.append('G');
                        break;
                    }
                    case 'H': {
                        if (SITStringUtils.isLastChar(wdsz, count) || count > 0 && VARSON.indexOf(local.charAt(count - 1)) >= 0 || !SITStringUtils.isVowel(local, count + 1)) break;
                        code.append('H');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        code.append(symb);
                        break;
                    }
                    case 'K': {
                        if (count > 0) {
                            if (SITStringUtils.isPreviousChar(local, count, 'C')) break;
                            code.append(symb);
                            break;
                        }
                        code.append(symb);
                        break;
                    }
                    case 'P': {
                        code.append(symb);
                        break;
                    }
                    case 'Q': {
                        code.append('Q');
                        break;
                    }
                    case 'S': {
                        if (SITStringUtils.regionMatch(local, count, "SH") || SITStringUtils.regionMatch(local, count, "SIO") || SITStringUtils.regionMatch(local, count, "SIA")) {
                            code.append('X');
                            break;
                        }
                        code.append('S');
                        break;
                    }
                    case 'T': {
                        if (SITStringUtils.regionMatch(local, count, "TIA") || SITStringUtils.regionMatch(local, count, "TIO")) {
                            code.append('X');
                            break;
                        }
                        if (SITStringUtils.regionMatch(local, count, "TCH") || SITStringUtils.regionMatch(local, count, "TH")) break;
                        code.append('T');
                        break;
                    }
                    case 'V': {
                        code.append('V');
                        break;
                    }
                    case 'W': 
                    case 'Y': {
                        if (SITStringUtils.isLastChar(wdsz, count) || !SITStringUtils.isVowel(local, count + 1)) break;
                        code.append(symb);
                        break;
                    }
                    case 'X': {
                        code.append('X');
                        break;
                    }
                    case 'Z': {
                        code.append('Z');
                        break;
                    }
                }
                ++count;
            }
            if (code.length() <= maxCodeLen) continue;
            code.setLength(maxCodeLen);
        }
        return code.toString();
    }

    private static String[] splitByUpperCaseChar(String line) {
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        ArrayList<String> values = new ArrayList<String>();
        int pos = 0;
        for (int i = 0; i < line.length(); ++i) {
            boolean isNum;
            char ch = line.charAt(i);
            boolean isAlpha = ch >= 'A' && ch <= 'Z';
            boolean bl = isNum = ch >= '0' && ch <= '9';
            if (!isAlpha && !isNum) continue;
            String str = line.substring(pos, i).trim();
            if (str.length() > 0) {
                values.add(str);
            }
            pos = i;
        }
        values.add(line.substring(pos).trim());
        return values.toArray(new String[values.size()]);
    }

    private static final boolean isVowel(StringBuilder string, int index) {
        return VOWELS.indexOf(string.charAt(index)) >= 0;
    }

    private static boolean isPreviousChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index > 0 && index < string.length()) {
            matches = string.charAt(index - 1) == ch;
        }
        return matches;
    }

    private static boolean isNextChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index >= 0 && index < string.length() - 1) {
            matches = string.charAt(index + 1) == ch;
        }
        return matches;
    }

    private static boolean regionMatch(StringBuilder string, int index, String test) {
        boolean matches = false;
        if (index >= 0 && index + test.length() - 1 < string.length()) {
            String substring = string.substring(index, index + test.length());
            matches = substring.equals(test);
        }
        return matches;
    }

    private static final boolean isLastChar(int wdsz, int index) {
        return index + 1 == wdsz;
    }

    public static String[] fastSplit(String line, int seperator) {
        if (line == null || line.length() == 0) {
            return null;
        }
        line = line.trim();
        int[] pos = new int[9];
        int iTimes = SITStringUtils.calcSeperatorTimes(line, seperator, pos);
        String[] arr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arr[0] = line;
        } else if (iTimes > 9) {
            int indexOf;
            int times = 0;
            int index = 0;
            while ((indexOf = line.indexOf(seperator, index)) >= 0) {
                arr[times] = line.substring(index, indexOf).trim();
                index = indexOf + 1;
                ++times;
            }
            arr[times] = line.substring(index).trim();
        } else {
            arr[0] = line.substring(0, pos[0]).trim();
            for (int i = 0; i < iTimes - 1; ++i) {
                arr[i + 1] = line.substring(pos[i] + 1, pos[i + 1]).trim();
            }
            arr[iTimes] = line.substring(pos[iTimes - 1] + 1).trim();
        }
        return arr;
    }

    private static int calcSeperatorTimes(String src, int seperator, int[] pos) {
        int indexOf;
        if (src == null || src.equals("")) {
            return 0;
        }
        int times = 0;
        int index = 0;
        while ((indexOf = src.indexOf(seperator, index)) >= 0) {
            if (times < 9) {
                pos[times] = indexOf;
            }
            index = indexOf + 1;
            ++times;
        }
        return times;
    }

    public static String[] fastSplit(String line, String seperator) {
        if (line == null || line.length() == 0) {
            return null;
        }
        line = line.trim();
        int[] pos = new int[9];
        int iTimes = SITStringUtils.calcSeperatorTimes(line, seperator, pos);
        String[] arr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arr[0] = line;
        } else if (iTimes > 9) {
            int indexOf;
            int times = 0;
            int index = 0;
            while ((indexOf = line.indexOf(seperator, index)) >= 0) {
                arr[times] = line.substring(index, indexOf).trim();
                index = indexOf + 1;
                ++times;
            }
            arr[times] = line.substring(index).trim();
        } else {
            arr[0] = line.substring(0, pos[0]).trim();
            for (int i = 0; i < iTimes - 1; ++i) {
                arr[i + 1] = line.substring(pos[i] + 1, pos[i + 1]).trim();
            }
            arr[iTimes] = line.substring(pos[iTimes - 1] + 1).trim();
        }
        return arr;
    }

    private static int calcSeperatorTimes(String src, String seperator, int[] pos) {
        int indexOf;
        if (src == null || src.equals("")) {
            return 0;
        }
        int times = 0;
        int index = 0;
        while ((indexOf = src.indexOf(seperator, index)) >= 0) {
            if (times < 9) {
                pos[times] = indexOf;
            }
            index = indexOf + 1;
            ++times;
        }
        return times;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (SITStringUtils.isEmpty(str) || SITStringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String replaceParamsOfMsg(String[] params, String strMsg) {
        for (int i = 0; i < params.length; ++i) {
            String replacement = params[i];
            if (null == replacement) {
                replacement = "";
            }
            strMsg = strMsg.replaceFirst("#" + i, replacement);
        }
        return strMsg;
    }

    public static String replaceOneParamOfString(String param, String strMsg) {
        String[] params = new String[]{param};
        strMsg = SITStringUtils.replaceParamsOfMsg(params, strMsg);
        return strMsg;
    }

    public static LocaleString joinLocaleString(String separator, LocaleString ... localeStrings) {
        if (localeStrings == null || localeStrings.length == 0) {
            return null;
        }
        LocaleString first = localeStrings[0];
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)first.keySet().size());
        for (String lcId : first.keySet()) {
            ArrayList tempValues = Lists.newArrayListWithCapacity((int)localeStrings.length);
            for (int i = 0; i < localeStrings.length; ++i) {
                LocaleString tempLocalString = localeStrings[i];
                String str = (String)tempLocalString.get((Object)lcId);
                tempValues.add(str);
            }
            resultMap.putIfAbsent(lcId, StringUtils.join((Object[])tempValues.toArray(new String[0]), (String)separator));
        }
        return LocaleString.fromMap((Map)resultMap);
    }
}

