/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.sdk.sit.sitbp.entity.SInsurFormulaConditionDTO;
import kd.sit.sitbp.common.entity.SInsurCalItemEntity;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SInsurFormulaCalUtils {
    private static Log logger = LogFactory.getLog(SInsurFormulaCalUtils.class);

    public static SInsurCalItemEntity getCalDataType(String metaTag, String fields, String showFields, SInsurFormulaConditionDTO sInsurFormulaConditionDTO) {
        String currShowFields;
        SInsurCalItemEntity sinsurCalItemEntity = new SInsurCalItemEntity();
        SInsurFormulaCalUtils.assembleCalVO(metaTag, fields, sinsurCalItemEntity, false, sInsurFormulaConditionDTO);
        List filters = (List)sInsurFormulaConditionDTO.getNodeNumAndRefQFiltersMap().get(fields);
        if (filters != null && filters.size() > 0) {
            boolean isOnlyUseCustomQFilter = Boolean.TRUE.equals(sInsurFormulaConditionDTO.getNodeNumAndOnlyUseCustomQFilterMap().get(fields));
            QFilter[] qFilters = sinsurCalItemEntity.getqFilters();
            ArrayList<QFilter> lastQFilters = new ArrayList<QFilter>(10);
            if (!isOnlyUseCustomQFilter) {
                lastQFilters.addAll(Arrays.asList(qFilters));
            }
            lastQFilters.addAll(filters);
            sinsurCalItemEntity.setqFilters(lastQFilters.toArray(new QFilter[0]));
        }
        if ((currShowFields = sInsurFormulaConditionDTO.getNodeNumAndShowFieldsMap().getOrDefault(fields, "")).trim().length() == 0) {
            currShowFields = showFields;
        }
        if (currShowFields != null && currShowFields.trim().length() > 0) {
            showFields = currShowFields.trim();
            sinsurCalItemEntity.setPropertyField(showFields.trim());
        }
        return sinsurCalItemEntity;
    }

    public static CalItemVO getCalItemVO(String metaTag, String fields, Map<String, MainEntityType> typeMap) {
        return SInsurFormulaCalUtils.assembleCalVO(metaTag, fields, typeMap, false);
    }

    private static CalItemVO assembleCalVO(String metaTag, String fields, Map<String, MainEntityType> typeMap, boolean isBasedataType) {
        MainEntityType mainEntityType = typeMap.computeIfAbsent(metaTag, key -> MetadataServiceHelper.getDataEntityType((String)metaTag));
        int index = fields.indexOf(46);
        if (index < 0) {
            Object property = mainEntityType.getAllFields().get(fields);
            CalItemVO calItemVO = new CalItemVO();
            if (property instanceof BasedataProp) {
                calItemVO.setDataType(DataTypeEnum.BASE);
            } else if (property instanceof TextProp) {
                calItemVO.setName(((TextProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.TEXT);
                calItemVO.setDataLength(Integer.valueOf(((TextProp)property).getMaxLenth()));
                if (isBasedataType) {
                    calItemVO.setDataType(DataTypeEnum.BASE);
                }
            } else if (property instanceof IntegerProp) {
                calItemVO.setName(((IntegerProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((IntegerProp)property).getScale()));
            } else if (property instanceof BigIntProp) {
                calItemVO.setName(((BigIntProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((BigIntProp)property).getScale()));
            } else if (property instanceof DecimalProp) {
                calItemVO.setName(((DecimalProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.NUM);
                calItemVO.setScale(Integer.valueOf(((DecimalProp)property).getScale()));
            } else if (property instanceof DateTimeProp) {
                calItemVO.setName(((DateTimeProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.DATE);
            } else if (property instanceof BooleanProp) {
                calItemVO.setName(((BooleanProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.BOOLEAN);
            } else if (property instanceof ComboProp) {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            } else {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            }
            return calItemVO;
        }
        Object property = mainEntityType.getAllFields().get(fields.substring(0, index));
        if (property instanceof BasedataProp) {
            return SInsurFormulaCalUtils.assembleCalVO(((BasedataProp)property).getBaseEntityId(), fields.substring(index + 1), typeMap, true);
        }
        return new CalItemVO();
    }

    private static void assembleCalVO(String metaTag, String fields, SInsurCalItemEntity SInsurCalItemEntity2, boolean isBasedataType, SInsurFormulaConditionDTO sInsurFormulaConditionDTO) {
        if (SITStringUtils.isEmpty(metaTag) || SITStringUtils.isEmpty(fields)) {
            return;
        }
        fields = fields.trim();
        metaTag = metaTag.trim();
        String[] str = fields.split("[.]");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = MetadataServiceHelper.getDataEntityType((String)metaTag);
        }
        catch (Exception ex) {
            logger.error("SInsurFormulaCalUtils.assembleCalVO\uff1a getDataEntityType error, ", (Throwable)ex);
        }
        if (mainEntityType == null) {
            logger.error("SInsurFormulaCalUtils.assembleCalVO\uff1a metaTag of {} is null", (Object)metaTag);
            return;
        }
        Object property = mainEntityType.getAllFields().get(str[0]);
        if (str.length == 1) {
            CalItemVO calItemVO = new CalItemVO();
            if (property instanceof BasedataProp) {
                calItemVO.setDataType(DataTypeEnum.BASE);
                SInsurCalItemEntity2.setItemType(CalItemTypeEnum.BASE_DATA);
                SInsurCalItemEntity2.setEntityNumber(((BasedataProp)property).getBaseEntityId());
                SInsurCalItemEntity2.setPropertyField("name");
            } else if (property instanceof TextProp) {
                calItemVO.setName(((TextProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.TEXT);
                calItemVO.setDataLength(Integer.valueOf(((TextProp)property).getMaxLenth()));
                if (isBasedataType) {
                    calItemVO.setDataType(DataTypeEnum.BASE);
                    SInsurCalItemEntity2.setItemType(CalItemTypeEnum.BASE_DATA);
                    SInsurCalItemEntity2.setEntityNumber(mainEntityType.getName());
                    SInsurCalItemEntity2.setPropertyField(fields);
                    QFilter filter = SInsurFormulaCalUtils.getBaseDataFilter(mainEntityType, sInsurFormulaConditionDTO);
                    SInsurCalItemEntity2.setqFilters(filter.toArray());
                }
            } else if (property instanceof IntegerProp) {
                calItemVO.setName(((IntegerProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((IntegerProp)property).getScale()));
            } else if (property instanceof BigIntProp) {
                calItemVO.setName(((BigIntProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((BigIntProp)property).getScale()));
            } else if (property instanceof DecimalProp) {
                calItemVO.setName(((DecimalProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.NUM);
                calItemVO.setScale(Integer.valueOf(((DecimalProp)property).getScale()));
            } else if (property instanceof DateTimeProp) {
                calItemVO.setName(((DateTimeProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.DATE);
            } else if (property instanceof BooleanProp) {
                calItemVO.setName(((BooleanProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.BOOLEAN);
            } else if (property instanceof ComboProp) {
                calItemVO.setDataType(DataTypeEnum.TEXT);
                SInsurCalItemEntity2.setItemType(CalItemTypeEnum.ENUM);
                SInsurCalItemEntity2.setEntityNumber(mainEntityType.getName());
                SInsurCalItemEntity2.setPropertyField(fields);
            } else {
                calItemVO.setDataType(DataTypeEnum.TEXT);
            }
            SInsurCalItemEntity2.setCalItemVO(calItemVO);
        } else if (property instanceof BasedataProp) {
            SInsurFormulaCalUtils.assembleCalVO(((BasedataProp)property).getBaseEntityId(), fields.substring(str[0].length() + 1, fields.length()), SInsurCalItemEntity2, true, sInsurFormulaConditionDTO);
        }
    }

    private static QFilter getBaseDataFilter(MainEntityType mainEntityType, SInsurFormulaConditionDTO sInsurFormulaConditionDTO) {
        boolean hasCtrlStrategy;
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (properties == null || properties.isEmpty()) {
            return filter;
        }
        String entityTypeName = mainEntityType.getName();
        if (properties.containsKey((Object)"status")) {
            filter = new QFilter("status", "=", (Object)"C");
        }
        if (properties.containsKey((Object)"enable")) {
            filter.and("enable", "=", (Object)"1");
        }
        if (properties.containsKey((Object)"iscurrentversion")) {
            filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        }
        if (hasCtrlStrategy = properties.containsKey((Object)"ctrlstrategy")) {
            filter.and(SInsurFormulaCalUtils.getBaseDataFilter(entityTypeName, sInsurFormulaConditionDTO.getCreateOrgId()));
        }
        if (entityTypeName == null) {
            return filter;
        }
        switch (entityTypeName) {
            case "bd_country": {
                filter.and("id", "=", (Object)sInsurFormulaConditionDTO.getCountryId());
                break;
            }
            case "sitbs_welfarepayer": {
                filter.and("org", "=", (Object)sInsurFormulaConditionDTO.getCreateOrgId());
                filter.and("country", "=", (Object)sInsurFormulaConditionDTO.getCountryId());
                break;
            }
            case "sitbs_placeofwelfare": {
                filter.and("country", "=", (Object)sInsurFormulaConditionDTO.getCountryId());
            }
        }
        return filter;
    }

    private static QFilter getBaseDataFilter(String entityID, Long orgID) {
        return ((IBaseDataService)ServiceFactory.getService(IBaseDataService.class)).getBaseDataFilter(entityID, orgID);
    }
}

