/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.StringMapKeyValue;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SitBaseUtil {
    private SitBaseUtil() {
    }

    public static long getBaseDataIdFromObject(DynamicObject object, String propName) {
        if (object == null) {
            return 0L;
        }
        Object res = object.get(propName);
        if (res instanceof Long) {
            return (Long)res;
        }
        return object.getLong(propName + ".id");
    }

    public static void initSystemProp(DynamicObject object) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        object.set("creator", (Object)userId);
        object.set("modifier", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
    }

    public static void initSystemProp(DynamicObject object, Long userId, Date now) {
        object.set("creator", (Object)userId);
        object.set("modifier", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
    }

    public static void initSystemProp4Update(DynamicObject object) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
    }

    public static void initSystemProp4Update(DynamicObject object, Long userId, Date now) {
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
    }

    public static void initSystemProp4Create(DynamicObject object) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        SitBaseUtil.initSystemProp4Create(object, userId, now);
    }

    public static void initSystemProp4Create(DynamicObject object, Long userId, Date now) {
        object.set("creator", (Object)userId);
        object.set("createtime", (Object)now);
    }

    public static void plainAdd(Collection collection, Object obj) {
        if (obj == null) {
            return;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                SitBaseUtil.plainAdd(collection, Array.get(obj, i));
            }
            return;
        }
        if (obj instanceof Collection) {
            for (Object item : (Collection)obj) {
                SitBaseUtil.plainAdd(collection, item);
            }
            return;
        }
        collection.add(obj);
    }

    public static Comparable limit(Comparable base, List<?> srcData, boolean max) {
        Comparable result = base;
        if (!ObjectUtils.isEmpty(srcData)) {
            for (Object obj : srcData) {
                if (!(obj instanceof Comparable)) continue;
                if (result == null) {
                    result = (Comparable)obj;
                    continue;
                }
                Comparable com = result.getClass() != obj.getClass() ? (Comparable)BaseDataConverter.convert(obj, result.getClass()) : (Comparable)obj;
                if (max && com.compareTo(result) > 0) {
                    result = com;
                    continue;
                }
                if (max || com.compareTo(result) >= 0) continue;
                result = com;
            }
        }
        return result;
    }

    public static Collection<?> toCollection(Object obj) {
        if (obj instanceof Collection || obj == null) {
            return (Collection)obj;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            ArrayList<Object> objects = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                objects.add(Array.get(obj, i));
            }
            return objects;
        }
        return Collections.singleton(obj);
    }

    public static StringMapKeyValue fromDynamicObject(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        StringMapKeyValue result = new StringMapKeyValue();
        result.setId(dynamicObject.getLong("id"));
        result.setKey(dynamicObject.getString("number"));
        result.setValue(dynamicObject.getLocaleString("name"));
        return result;
    }

    public static BatchResult<ExtendedDataEntity> validateCombField(ExtendedDataEntity[] dynamicObjects) {
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new BatchResult<ExtendedDataEntity>(true, Collections.emptyList());
        }
        IDataEntityType dataEntityType = dynamicObjects[0].getDataEntity().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        List collect = properties.stream().filter(ele -> ele instanceof ComboProp).map(ele -> (ComboProp)ele).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new BatchResult<ExtendedDataEntity>(true, Arrays.asList(dynamicObjects));
        }
        HashMap combValues = Maps.newHashMapWithExpectedSize((int)collect.size());
        for (ComboProp property : collect) {
            List comboItems = property.getComboItems();
            Set values = comboItems.stream().map(ValueMapItem::getValue).collect(Collectors.toSet());
            combValues.put(property, values);
        }
        BatchResult<ExtendedDataEntity> result = new BatchResult<ExtendedDataEntity>(Lists.newArrayListWithCapacity((int)dynamicObjects.length), Lists.newArrayListWithCapacity((int)dynamicObjects.length));
        String msg = ResManager.loadKDString((String)"\u65b9\u6848\u3010{0}\u3011\u7684\u3010{1}\u3011\u503c\u4e0d\u89c4\u8303", (String)"SitBaseUtil_0", (String)"sit-sitbp-common", (Object[])new Object[0]);
        block1: for (ExtendedDataEntity dynamicObjectExt : dynamicObjects) {
            DynamicObject dynamicObject = dynamicObjectExt.getDataEntity();
            for (Map.Entry entry : combValues.entrySet()) {
                Object value = ((ComboProp)entry.getKey()).getValue((Object)dynamicObject);
                if (ObjectUtils.isEmpty((Object)value) || ((Set)entry.getValue()).contains(value)) {
                    result.addSuccessResult(dynamicObjectExt);
                    continue;
                }
                result.addFailItem(dynamicObjectExt, MessageFormat.format(msg, "{0}", ((ComboProp)entry.getKey()).getDisplayName()));
                continue block1;
            }
        }
        return result;
    }
}

