/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util;

import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.KDDateUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class SitDateUtil {
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_1 = Pattern.compile("\\d{4}-[0,1][0-9]-[0-3][0-9]");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_2 = Pattern.compile("\\d{4}/[0,1][0-9]/[0-3][0-9]");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_NO_SEPARATOR = Pattern.compile("\\d{4}[0,1][0-9][0-3][0-9]");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_1 = Pattern.compile("\\d{4}-[0,1][0-9]-[0-3][0-9] [0,2][0-9](:[0-5][0-9]){2}");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_2 = Pattern.compile("\\d{4}/[0,1][0-9]/[0-3][0-9] [0,2][0-9](:[0-5][0-9]){2}");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_NO_SEPARATOR = Pattern.compile("\\d{4}[0,1][0-9][0-3][0-9][0,2][0-9]([0-5][0-9]){2}");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_1 = Pattern.compile("\\d{4}-[0,1][0-9]-[0-3][0-9] [0,2][0-9](:[0-5][0-9]){2}\\.\\d{3}");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_2 = Pattern.compile("\\d{4}/[0,1][0-9]/[0-3][0-9] [0,2][0-9](:[0-5][0-9]){2}\\.\\d{3}");
    private static final Pattern P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_NO_SEPARATOR = Pattern.compile("\\d{4}[0,1][0-9][0-3][0-9][0,2][0-9]([0-5][0-9]){2}\\.\\d{3}");
    private static final String S_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_1 = "yyyy-MM-dd";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_2 = "yyyy/MM/dd";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_NO_SEPARATOR = "yyyyMMdd";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_1 = "yyyy-MM-dd HH:mm:ss";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_2 = "yyyy/MM/dd HH:mm:ss";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_NO_SEPARATOR = "yyyyMMddHHmmss";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_1 = "yyyy-MM-DD HH:mm:ss.SSS";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_2 = "yyyy/MM/DD HH:mm:ss.SSS";
    private static final String S_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_NO_SEPARATOR = "yyyyMMddHHmmss.SSS";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final char DATE_SPLIT = '-';
    public static final char DATE_SPLIT_SLASH = '/';
    public static final char TIME_SPLIT = ':';
    public static final char DATE_TIME_SPLIT = ' ';
    public static final String MIN_DATE_STR = "1970-01-01";
    public static final String MIN_TIME_STR = "00:00:00";
    private static final Date MIN_DATE = new Date(0L);
    private static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    private static final Map<Pattern, String> SUPPORT_PATTEN = ImmutableMap.builder().put((Object)P_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_1, (Object)"yyyy-MM-dd").put((Object)P_DATE_PATTEN_YYYY_MM_DD_SEPARATOR_2, (Object)"yyyy/MM/dd").put((Object)P_DATE_PATTEN_YYYY_MM_DD_NO_SEPARATOR, (Object)"yyyyMMdd").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_1, (Object)"yyyy-MM-dd HH:mm:ss").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SEPARATOR_2, (Object)"yyyy/MM/dd HH:mm:ss").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_NO_SEPARATOR, (Object)"yyyyMMddHHmmss").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_1, (Object)"yyyy-MM-DD HH:mm:ss.SSS").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_SEPARATOR_2, (Object)"yyyy/MM/DD HH:mm:ss.SSS").put((Object)P_DATE_PATTEN_YYYY_MM_DD_HH_MM_SS_SSS_NO_SEPARATOR, (Object)"yyyyMMddHHmmss.SSS").build();

    public static boolean isDate(Object obj) {
        if (obj instanceof TemporalAccessor || obj instanceof Date || obj instanceof Number) {
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            for (Map.Entry<Pattern, String> entry : SUPPORT_PATTEN.entrySet()) {
                if (!entry.getKey().matcher(str).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDateRangeOverlap(Date effectDate, Date expireDate, Date anotherEffectDate, Date anotherExpireDate) {
        effectDate = effectDate == null ? MIN_DATE : effectDate;
        expireDate = expireDate == null ? MAX_DATE : expireDate;
        anotherEffectDate = anotherEffectDate == null ? MIN_DATE : anotherEffectDate;
        anotherExpireDate = anotherExpireDate == null ? MAX_DATE : anotherExpireDate;
        return !effectDate.after(anotherExpireDate) && !expireDate.before(anotherEffectDate);
    }

    public static boolean isCover(Date inDate, Date start, Date end) {
        if (inDate == null) {
            return false;
        }
        start = start == null ? MIN_DATE : start;
        end = end == null ? MAX_DATE : end;
        return !inDate.before(start) && !inDate.after(end);
    }

    public static void convertDate(Map<String, Object> data, String ... fields) {
        for (String field : fields) {
            data.put(field, BaseDataConverter.convert(data.get(field), Date.class));
        }
    }

    public static Date ceil(Object date) {
        if (date == null) {
            return null;
        }
        return BaseDataConverter.convert((Object)BaseDataConverter.convert(date, LocalDate.class), Date.class);
    }

    public static int toYearMonth(Date date) {
        if (date == null) {
            return 0;
        }
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        return convert.getYear() * 100 + convert.getMonthValue();
    }

    public static int toYearMonthDay(Date date) {
        if (date == null) {
            return 0;
        }
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        return convert.getYear() * 10000 + convert.getMonthValue() * 100 + convert.getDayOfMonth();
    }

    public static Date parseDate(String dateStr, String fmt) throws ParseException {
        return SitDateUtil.parseDate(dateStr, fmt, null);
    }

    public static Date parseDate(String dateStr, String fmt, TimeZone timezone) throws ParseException {
        return SitDateUtil.parseDate(dateStr, fmt, timezone, null);
    }

    public static Date parseDate(String dataStr, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = KDDateUtils.getSysTimeZone();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(dataStr);
    }

    public static Date parseDate(String dataStr) throws ParseException {
        try {
            return SitDateUtil.parseDate(dataStr, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException parseException) {
            try {
                return SitDateUtil.parseDate(dataStr, "yyyy-MM-dd");
            }
            catch (ParseException parseException2) {
                try {
                    return SitDateUtil.parseDate(dataStr, "MM/dd/yyyy HH:mm:ss");
                }
                catch (ParseException parseException3) {
                    try {
                        return SitDateUtil.parseDate(dataStr, "MM/dd/yyyy");
                    }
                    catch (ParseException parseException4) {
                        try {
                            return SitDateUtil.parseDate(dataStr, DEFAULT_TIME_FORMAT);
                        }
                        catch (ParseException parseException5) {
                            throw new ParseException("can not understand your format:" + dataStr, -1);
                        }
                    }
                }
            }
        }
    }

    public static Date lastDateOfMonth(Date date) {
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        LocalDate with = convert.with(TemporalAdjusters.lastDayOfMonth());
        return BaseDataConverter.convert((Object)with, Date.class);
    }

    public static Date lastDayOfYear(Date date) {
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        LocalDate with = convert.with(TemporalAdjusters.lastDayOfYear());
        return BaseDataConverter.convert((Object)with, Date.class);
    }

    public static Date firstDayOfYear(Date date) {
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        LocalDate with = convert.with(TemporalAdjusters.firstDayOfYear());
        return BaseDataConverter.convert((Object)with, Date.class);
    }

    public static Date firstDayOfMonth(Date date) {
        LocalDate convert = BaseDataConverter.convert((Object)date, LocalDate.class);
        LocalDate with = convert.with(TemporalAdjusters.firstDayOfMonth());
        return BaseDataConverter.convert((Object)with, Date.class);
    }

    public static Date toLastSecond(Date date) {
        if (date == null) {
            return null;
        }
        LocalDateTime covert = BaseDataConverter.convert((Object)date, LocalDateTime.class);
        return (Date)BaseDataConverter.convert((Object)covert.withHour(23).withMinute(59).withSecond(59).withNano(999999999), DataTypeEnum.DATE_TIME.name());
    }

    public static String timeDifference(Date startTime, Date finishTime) {
        if (startTime != null && finishTime != null && finishTime.compareTo(startTime) >= 0) {
            long timeDifference = finishTime.getTime() - startTime.getTime();
            long seconds = TimeUnit.MILLISECONDS.toSeconds(timeDifference);
            long minutes = TimeUnit.MILLISECONDS.toMinutes(timeDifference);
            long hours = TimeUnit.MILLISECONDS.toHours(timeDifference);
            String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"SitDateUtil_0", (String)"sit-sitbp-common", (Object[])new Object[0]);
            String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"SitDateUtil_1", (String)"sit-sitbp-common", (Object[])new Object[0]);
            String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"SitDateUtil_2", (String)"sit-sitbp-common", (Object[])new Object[0]);
            StringBuilder stringBuilder = new StringBuilder();
            if (hours != 0L) {
                stringBuilder.append(hours).append(hourDes);
                stringBuilder.append(minutes).append(minuteDes);
                stringBuilder.append(seconds).append(secondDes);
            } else if (minutes != 0L) {
                stringBuilder.append(minutes).append(minuteDes);
                stringBuilder.append(seconds).append(secondDes);
            } else {
                stringBuilder.append(seconds).append(secondDes);
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

